/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.zntsnew.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.geoway.ns.smart.zntsnew.dto.CloudAnalaysParamDTO;
import com.geoway.ns.smart.zntsnew.entity.CloudQueryTask;
import com.geoway.ns.smart.zntsnew.service.CloudQueryManageService;
import com.geoway.ns.sys.dto.RestResult;
import com.geoway.ns.sys.service.ITokenService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4e91\u67e5\u8be2\u76f8\u5173\u63a5\u53e3\uff08\u65b0\uff09"})
@RestController
@CrossOrigin
@RequestMapping(value={"/cloudQuerys"})
public class CloudQueryControllerNew {
    @Autowired
    private CloudQueryManageService cloudQueryManageService;
    @Autowired
    private ITokenService tokenService;

    @ApiOperation(value="\u4e91\u67e5\u8be2 - \u67e5\u8be2\u5206\u6790\u914d\u7f6e\u4fe1\u606f")
    @ApiOperationSupport(order=1)
    @GetMapping(value={"/config"})
    public RestResult<Map<String, Object>> queryConfigs(@RequestHeader(value="Access_token") String token, String planId) throws Exception {
        return RestResult.success(this.cloudQueryManageService.queryCloudConfig(planId));
    }

    @ApiOperation(value="\u4e91\u67e5\u8be2 - \u83b7\u53d6\u89c4\u5219\u8be6\u60c5\u5217\u8868")
    @ApiOperationSupport(order=2)
    @GetMapping(value={"/rules"})
    public RestResult<JSONArray> queryCloudRule(@RequestHeader(value="Access_token") String token, String planId) throws Exception {
        String userId = this.getUserId();
        return RestResult.success((Object)this.cloudQueryManageService.queryCloudRule(planId, userId));
    }

    @ApiOperation(value="\u4e91\u67e5\u8be2 - \u65b0\u589e\u4e91\u67e5\u8be2")
    @ApiOperationSupport(order=3)
    @PostMapping(value={"/add"})
    public RestResult<String> addCloudQeury(@RequestHeader(value="Access_token") String token, @RequestBody CloudAnalaysParamDTO param) throws Exception {
        String userId = this.getUserId();
        return RestResult.success((Object)this.cloudQueryManageService.addCloudQuery(param, userId));
    }

    @ApiOperation(value="\u4e91\u67e5\u8be2 - \u5206\u9875\u67e5\u8be2")
    @ApiOperationSupport(order=4)
    @RequestMapping(value={"/page"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public RestResult<IPage<CloudQueryTask>> PageCloudQeury(@RequestHeader(value="Access_token") String token, @RequestParam Integer page, @RequestParam Integer size, String tag) throws Exception {
        String userId = this.getUserId();
        return RestResult.success(this.cloudQueryManageService.queryTaskPage(userId, page, size, tag));
    }

    @ApiOperation(value="\u4e91\u67e5\u8be2 - \u8be6\u60c5")
    @ApiOperationSupport(order=5)
    @RequestMapping(value={"/info/{id}"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public RestResult<CloudQueryTask> PageCloudQeury(@RequestHeader(value="Access_token") String token, @PathVariable(value="id") String id) throws Exception {
        return RestResult.success((Object)this.cloudQueryManageService.queryTaskInfo(id));
    }

    @ApiOperation(value="\u4e91\u67e5\u8be2 - \u5220\u9664")
    @ApiOperationSupport(order=6)
    @RequestMapping(value={"/delete/{id}"}, method={RequestMethod.DELETE}, produces={"application/json;charset=UTF-8"})
    public RestResult<String> deleleById(@RequestHeader(value="Access_token") String token, @PathVariable(value="id") String id) throws Exception {
        this.getUserId();
        this.cloudQueryManageService.deleteTaskById(id);
        return RestResult.success((Object)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u4e91\u67e5\u8be2 - \u5ba1\u6279\u7ed3\u679c")
    @ApiOperationSupport(order=7)
    @RequestMapping(value={"/result/rule"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public RestResult<JSONObject> queryRuleResult(@RequestHeader(value="Access_token") String token, @RequestParam String rid) throws Exception {
        this.getUserId();
        return RestResult.success((Object)this.cloudQueryManageService.queryRuleResult(rid));
    }

    @ApiOperation(value="\u4e91\u67e5\u8be2 - \u7701\u7ea7\u5206\u6790\u7ed3\u679c")
    @ApiOperationSupport(order=8)
    @RequestMapping(value={"/result/analysis"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public RestResult<JSONArray> queryAnalysResult(@RequestHeader(value="Access_token") String token, @RequestParam String rid, String serviceIds) throws Exception {
        return RestResult.success((Object)this.cloudQueryManageService.queryAnalysResult(rid, serviceIds));
    }

    @ApiOperation(value="\u4e91\u67e5\u8be2 - \u7701\u7ea7\u5206\u6790\u72b6\u6001")
    @ApiOperationSupport(order=9)
    @RequestMapping(value={"/status/analysis"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public RestResult<List<JSONObject>> queryAnalysStatus(@RequestHeader(value="Access_token") String token, @RequestParam String rid) throws Exception {
        return RestResult.success(this.cloudQueryManageService.queryAnalysStatus(rid));
    }

    @ApiOperation(value="\u4e91\u67e5\u8be2 - \u56fd\u5bb6\u7ea7\u5206\u6790\u7ed3\u679c")
    @ApiOperationSupport(order=10)
    @RequestMapping(value={"/result/analysis/country"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public RestResult<JSONObject> queryAnalysResultCountry(@RequestHeader(value="Access_token") String token, @RequestParam String rid, @RequestParam String group) throws Exception {
        return RestResult.success((Object)this.cloudQueryManageService.queryAnalysResultCountry(rid, group));
    }

    @ApiOperation(value="\u4e91\u67e5\u8be2 - \u8be6\u60c5 - \u5305\u542b\u914d\u7f6e\u9879")
    @ApiOperationSupport(order=11)
    @RequestMapping(value={"/all/info/{id}"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public RestResult<Map<String, Object>> AllInfoCloudQeury(@RequestHeader(value="Access_token") String token, @PathVariable(value="id") String id, String planId) throws Exception {
        return RestResult.success(this.cloudQueryManageService.queryTaskInfoWithConfig(id, planId));
    }

    @ApiOperation(value="\u4e91\u67e5\u8be2 - \u5bfc\u51fa\u62a5\u544a")
    @ApiOperationSupport(order=12)
    @RequestMapping(value={"/result/export/{taskId}"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public void exportReport(HttpServletResponse response, @PathVariable String taskId) throws Exception {
        this.cloudQueryManageService.exportReport(response, taskId);
    }

    @ApiOperation(value="\u4e91\u67e5\u8be2 - \u83b7\u53d6\u62a5\u544a\u4fe1\u606f")
    @ApiOperationSupport(order=13)
    @GetMapping(value={"/report"}, produces={"application/json;charset=UTF-8"})
    public RestResult<JSONObject> report(String planId) throws Exception {
        return RestResult.success((Object)this.cloudQueryManageService.findReport(planId, this.tokenService.queryCurrentSysUserId()));
    }

    @ApiOperation(value="\u4e91\u67e5\u8be2 - \u83b7\u53d6\u7701\u7ea7\u4e91\u5206\u6790\u4efb\u52a1\u53c2\u6570")
    @ApiOperationSupport(order=14)
    @GetMapping(value={"/taskParam"}, produces={"application/json;charset=UTF-8"})
    public RestResult<JSONObject> taskParam(String rid) throws Exception {
        return RestResult.success((Object)this.cloudQueryManageService.findTaskParam(rid));
    }

    @ApiOperation(value="\u4e91\u67e5\u8be2 - \u83b7\u53d6\u89c4\u5219\u5206\u6790\u8be6\u60c5\u7ed3\u679c\u8868")
    @ApiOperationSupport(order=15)
    @GetMapping(value={"/result/rule/detail"}, produces={"application/json;charset=UTF-8"})
    public RestResult<List> ruleDetail(String taskId, String planId, String limitType, Boolean result, Integer verify) throws Exception {
        return RestResult.success((Object)this.cloudQueryManageService.findRuleRes(taskId, planId, limitType, result, verify));
    }

    private String getUserId() throws Exception {
        String userId = this.tokenService.queryCurrentSysUserId();
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)userId), (String)"\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u767b\u5f55\u4fe1\u606f\uff01");
        return userId;
    }
}

