/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.zntsnew.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.ns.geoserver3.service.IDTSPService;
import com.geoway.ns.smart.zntsnew.dto.BlockDTO;
import com.geoway.ns.smart.zntsnew.dto.CloudAnalaysParamDTO;
import com.geoway.ns.smart.zntsnew.dto.XmxxInfoFieldDTO;
import com.geoway.ns.smart.zntsnew.dto.XmxxInfoFilter;
import com.geoway.ns.smart.zntsnew.dto.XmxxQueryParam;
import com.geoway.ns.smart.zntsnew.entity.CloudQueryXmxx;
import com.geoway.ns.smart.zntsnew.mapper.CloudQueryXmxxMapper;
import com.geoway.ns.smart.zntsnew.service.CloudQueryManageService;
import com.geoway.ns.smart.zntsnew.service.CloudQueryXmxxService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CloudQueryXmxxServiceImpl
extends ServiceImpl<CloudQueryXmxxMapper, CloudQueryXmxx>
implements CloudQueryXmxxService {
    private static final String cache_key = "cloud-query-xm";
    @Autowired
    private CloudQueryManageService manageService;
    @Autowired
    private IDTSPService dtspService;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private ThreadPoolTaskExecutor executor;

    @Override
    public String uploadXm(MultipartFile file, String userId, String tag, String toolId) throws Exception {
        CloudQueryXmxx xmxx = this.getFileXmxx(file, userId, tag);
        xmxx.setToolId(toolId);
        this.save(xmxx);
        return xmxx.getId();
    }

    @Override
    public String saveXm(CloudQueryXmxx xmxx) {
        List<XmxxInfoFieldDTO> fields = xmxx.getFields();
        if (CollectionUtil.isNotEmpty(fields)) {
            JSONObject info = xmxx.getInfo();
            List<XmxxInfoFilter> filters = fields.stream().filter(f -> f.getUnique() != null && f.getUnique() != false).map(m -> XmxxInfoFilter.builder().name(m.getProp()).value(info.getString(m.getProp())).build()).collect(Collectors.toList());
            CloudQueryXmxx query = ((CloudQueryXmxxMapper)this.baseMapper).queryByInfo(xmxx.getUserId(), xmxx.getTag(), xmxx.getId(), filters);
            if (query != null) {
                throw new RuntimeException("\u9879\u76ee\u4fe1\u606f\u552f\u4e00\u503c\u5b57\u6bb5\u5b58\u5728\u91cd\u590d\uff01");
            }
        }
        if (StringUtils.isEmpty((CharSequence)xmxx.getId())) {
            this.save(xmxx);
        } else {
            this.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(CloudQueryXmxx.class).eq(CloudQueryXmxx::getId, (Object)xmxx.getId())).set(CloudQueryXmxx::getInfo, (Object)xmxx.getInfo()));
        }
        return xmxx.getId();
    }

    @Override
    public IPage<CloudQueryXmxx> queryPage(XmxxQueryParam param, String userId) {
        Page taskPage = new Page();
        Map<String, String> filter = param.getFilter();
        StringBuilder jsonFilter = new StringBuilder();
        if (filter != null && !filter.isEmpty()) {
            for (Map.Entry<String, String> entry : filter.entrySet()) {
                jsonFilter.append(" x.f_info::json ->> ");
                jsonFilter.append("'" + entry.getKey() + "'::text ");
                jsonFilter.append(" like ");
                jsonFilter.append("'%" + entry.getValue() + "%'");
                jsonFilter.append(" or");
            }
            jsonFilter.delete(jsonFilter.length() - 2, jsonFilter.length());
        }
        taskPage.setRecords(((CloudQueryXmxxMapper)this.baseMapper).queryPage(userId, (param.getPage() - 1) * param.getSize(), param.getSize(), param.getStatus(), jsonFilter.toString(), param.getTag(), param.getToolId()));
        taskPage.setTotal((long)((CloudQueryXmxxMapper)this.baseMapper).queryPageCount(userId, jsonFilter.toString(), param).intValue());
        return taskPage;
    }

    @Override
    public String analysis(CloudAnalaysParamDTO param) throws Exception {
        CloudQueryXmxx xmxx = (CloudQueryXmxx)((CloudQueryXmxxMapper)this.baseMapper).selectById((Serializable)((Object)param.getId()));
        xmxx.setTaskId(this.startAnalys(param, xmxx.getBlocks(), xmxx.getUserId(), param.getPlanId(), xmxx.getInfo()));
        xmxx.setStatus(1);
        this.updateById(xmxx);
        return xmxx.getTaskId();
    }

    @Override
    public void analysisBatch(CloudAnalaysParamDTO param) throws Exception {
        List<String> idList = Arrays.asList(param.getIds().split(","));
        List xmxxList = ((CloudQueryXmxxMapper)this.baseMapper).selectBatchIds(idList);
        for (CloudQueryXmxx xmxx : xmxxList) {
            CompletableFuture.runAsync(() -> {
                Boolean absent = this.redisTemplate.boundValueOps((Object)("cloud-query-xm:" + xmxx.getId())).setIfAbsent((Object)1);
                if (absent.booleanValue()) {
                    try {
                        this.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(CloudQueryXmxx.class).eq(CloudQueryXmxx::getId, (Object)xmxx.getId())).set(CloudQueryXmxx::getStatus, (Object)0));
                        xmxx.setTaskId(this.startAnalys(param, xmxx.getBlocks(), xmxx.getUserId(), param.getPlanId(), xmxx.getInfo()));
                        xmxx.setStatus(1);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        xmxx.setStatus(-1);
                    }
                    finally {
                        this.redisTemplate.delete((Object)("cloud-query-xm:" + xmxx.getId()));
                        this.updateById(xmxx);
                    }
                }
            }, (Executor)this.executor);
        }
    }

    public boolean removeById(Serializable id) {
        CloudQueryXmxx xmxx = (CloudQueryXmxx)this.getById(id);
        Assert.isTrue((xmxx != null ? 1 : 0) != 0, (String)"\u672a\u67e5\u5230\u9879\u76ee\u4fe1\u606f\uff01");
        this.manageService.deleteTaskById(xmxx.getTaskId());
        return super.removeById(id);
    }

    public String startAnalys(CloudAnalaysParamDTO param, List<BlockDTO> blocks, String userId, String planId, JSONObject xmInfo) throws Exception {
        param.setWkts(blocks.stream().map(m -> m.getWkt()).collect(Collectors.toList()));
        param.setBlocks(blocks);
        param.setTag("sys_xm");
        return this.manageService.addCloudQuery(param, userId, planId, xmInfo);
    }

    private CloudQueryXmxx getFileXmxx(MultipartFile file, String userId, String tag) {
        JSONObject object = this.dtspService.uploadXm(file);
        JSONObject xmxxJson = object.getJSONObject("xmxx");
        List blocks = xmxxJson.getJSONArray("blocks").toJavaList(BlockDTO.class);
        xmxxJson.remove((Object)"blocks");
        JSONObject xmAttributes = xmxxJson.getJSONObject("xmAttributes");
        CloudQueryXmxx xmxx = new CloudQueryXmxx();
        xmxx.setBlocks(blocks);
        xmxx.setInfo(xmAttributes.isEmpty() ? xmxxJson : xmAttributes);
        xmxx.setUserId(userId);
        xmxx.setTag(tag);
        return xmxx;
    }
}

