/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.znts.controller;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONArray;
import com.geoway.ns.smart.znts.dto.AppCloudQueryParam;
import com.geoway.ns.smart.znts.dto.CloudQueryDTO;
import com.geoway.ns.smart.znts.dto.WebCloudQueryParam;
import com.geoway.ns.smart.znts.dto.WebCombineCloudQueryParam;
import com.geoway.ns.smart.znts.entity.CloudQuery;
import com.geoway.ns.smart.znts.entity.CloudQueryItem;
import com.geoway.ns.smart.znts.entity.CloudQueryItemSj;
import com.geoway.ns.smart.znts.entity.CloudQueryNode;
import com.geoway.ns.smart.znts.entity.CloudQueryStatistics;
import com.geoway.ns.smart.znts.entity.MultiMapConfig;
import com.geoway.ns.smart.znts.service.CloudQueryItemSjService;
import com.geoway.ns.smart.znts.service.CloudQueryRecordService;
import com.geoway.ns.smart.znts.service.CloudQueryService;
import com.geoway.ns.smart.znts.service.CloudQueryStatisticsService;
import com.geoway.ns.smart.znts.service.CombineCloudQueryService;
import com.geoway.ns.smart.znts.service.IExportCloudDOCService;
import com.geoway.ns.smart.znts.service.MultiMapConfigService;
import com.geoway.ns.smart.znts.service.NationalCloudQueryService;
import com.geoway.ns.smart.znts.service.ProvincialCloudQueryService;
import com.geoway.ns.sys.dto.BaseObjectResponse;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.dto.RestResult;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.google.gson.Gson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4e91\u67e5\u8be2\u76f8\u5173\u63a5\u53e3"})
@RestController
@CrossOrigin
@RequestMapping(value={"/cloudQuery"})
public class CloudQueryController {
    @Resource
    private CloudQueryStatisticsService cloudQueryStatisticsService;
    @Resource
    private NationalCloudQueryService nationalCloudQueryService;
    @Resource
    private ProvincialCloudQueryService provincialCloudQueryService;
    @Resource
    private MultiMapConfigService multiMapConfigService;
    @Resource
    private CloudQueryService cloudQueryService;
    @Resource
    private CloudQueryRecordService cloudQueryRecordService;
    @Resource
    private CombineCloudQueryService combineCloudQueryService;
    @Resource
    private IExportCloudDOCService exportCloudDOCService;
    @Resource
    private CloudQueryItemSjService cloudQueryItemSjService;

    @ApiOperation(value="\u56fd\u5bb6\u7ea7 - \u67e5\u8be2\uff08\u79fb\u52a8\u7aef\u4f7f\u7528\uff09")
    @ApiOperationSupport(order=1)
    @PostMapping(value={"/addOne.action"})
    public RestResult<com.alibaba.fastjson.JSONObject> addOne(AppCloudQueryParam appCloudQueryParam) {
        try {
            return RestResult.success((Object)this.nationalCloudQueryService.sendAppCloudQuery(appCloudQueryParam));
        }
        catch (Exception ex) {
            return RestResult.error((Integer)200, (String)ex.getLocalizedMessage());
        }
    }

    @ApiOperation(value="\u56fd\u5bb6\u7ea7 - \u67e5\u8be2\uff08\u79fb\u52a8\u7aef\u4f7f\u7528\uff09")
    @ApiOperationSupport(order=1)
    @PostMapping(value={"/queryById.action"})
    public RestResult<List<CloudQuery>> queryById(@RequestParam String cloudId) {
        ArrayList<CloudQuery> result = new ArrayList<CloudQuery>();
        CloudQuery cloudQuery = (CloudQuery)this.cloudQueryService.getById((Serializable)((Object)cloudId));
        if (cloudQuery != null) {
            result.add(cloudQuery);
        }
        return RestResult.success(result);
    }

    @ApiOperation(value="\u67e5\u8be2db\u5730\u5740\uff08\u79fb\u52a8\u7aef\u4f7f\u7528\uff09")
    @ApiOperationSupport(order=1)
    @GetMapping(value={"/getCloudQueryDbUrl.action"})
    public RestResult<JSONArray> getCloudQueryDbUrl(@RequestParam String cloudids) {
        return RestResult.success((Object)this.cloudQueryService.getCloudQueryDbUrl(cloudids));
    }

    @ApiOperation(value="\u56fd\u5bb6\u7ea7 - \u67e5\u8be2")
    @ApiOperationSupport(order=1)
    @PostMapping(value={"/addGJCloudQueryWeb.action"})
    public RestResult<String> sendWebNationalCloudQuery(@RequestHeader(value="Access_token") String token, WebCloudQueryParam webCloudQueryParam) throws Exception {
        return RestResult.success((Object)this.nationalCloudQueryService.sendCloudQuery(webCloudQueryParam));
    }

    @ApiOperation(value="\u56fd\u5bb6\u7ea7\u548c\u7701\u7ea7\u7ec4\u5408 - \u67e5\u8be2")
    @ApiOperationSupport(order=1)
    @PostMapping(value={"/addCombineCloudQueryWeb.action"})
    public RestResult<String> sendWebCombineCloudQuery(@RequestHeader(value="Access_token") String token, @ApiParam(value="wkt \u5b57\u7b26\u4e32", required=true) @RequestParam(name="wkt", required=true) String wkt, @ApiParam(value="\u9ad8\u5ea6", required=false) @RequestParam(name="height", required=false) Integer height, @ApiParam(value="\u5bbd\u5ea6", required=false) @RequestParam(name="width", required=false) Integer width, @ApiParam(value="\u7ec4\u67e5\u8be2Json", required=true) @RequestParam(name="queryInfo", required=true) String queryInfo) throws Exception {
        WebCombineCloudQueryParam webCombineCloudQueryParam = null;
        if (StringUtils.isBlank((CharSequence)wkt)) {
            return RestResult.error((String)"wkt\u53c2\u6570\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isNotBlank((CharSequence)queryInfo)) {
            try {
                Gson gson = new Gson();
                webCombineCloudQueryParam = (WebCombineCloudQueryParam)gson.fromJson(queryInfo.toString(), WebCombineCloudQueryParam.class);
            }
            catch (Exception e) {
                e.printStackTrace();
                return RestResult.error((String)"queryInfo\u53c2\u6570\u6570\u636e\u4e0d\u6b63\u786e\uff01");
            }
        } else {
            return RestResult.error((String)"queryInfo\u53c2\u6570\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        webCombineCloudQueryParam.setWkt(wkt);
        if (width != null && width != 0 && width > 0) {
            webCombineCloudQueryParam.setWidth(width);
        }
        if (height != null && height != 0 && height > 0) {
            webCombineCloudQueryParam.setHeight(height);
        }
        return RestResult.success((Object)this.combineCloudQueryService.sendCloudQuery(webCombineCloudQueryParam));
    }

    @ApiOperation(value="\u56fd\u5bb6\u7ea7 - web \u7aef\u7ed3\u679c\u9875 url")
    @ApiOperationSupport(order=2)
    @GetMapping(value={"/getGJCloudQueryIframe.action"})
    public RestResult<String> getWebNationalCloudQueryResultUrl(@RequestHeader(value="Access_token") String token, String requestId, String type) throws Exception {
        return RestResult.success((Object)this.nationalCloudQueryService.getResultDetailUrl(requestId, type));
    }

    @ApiOperation(value="\u56fd\u5bb6\u7ea7 - web \u7aef\u7ed3\u679c\u96c6")
    @ApiOperationSupport(order=2)
    @RequestMapping(value={"getGJCloudQueryResultsById.action"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseObjectResponse getGJCloudQueryResultsById(HttpServletRequest request, @RequestParam String requestId) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            JSONObject jsonObject = this.nationalCloudQueryService.getResultDetail(requestId);
            response.setData((Object)jsonObject);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setMessage(e.getMessage());
            response.setStatus("FAILURE");
        }
        return response;
    }

    @ApiOperation(value="\u56fd\u5bb6\u7ea7 - \u67e5\u8be2\u9879")
    @ApiOperationSupport(order=3)
    @GetMapping(value={"/queryMyCloudItem.json"})
    public RestResult<List<CloudQueryNode>> getCloudQueryItem(@RequestHeader(value="Access_token") String token, Integer displaySet) throws Exception {
        return RestResult.success(this.nationalCloudQueryService.getCloudQueryItem(displaySet));
    }

    @ApiOperation(value="\u56fd\u5bb6\u7ea7 - \u67e5\u8be2\u9879 -\u5143\u6570\u636e")
    @RequestMapping(value={"/getGJCloudMeta.action"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public RestResult<LinkedHashMap<String, List<CloudQueryItem>>> getGJCloudMeta(HttpServletRequest request) {
        try {
            return RestResult.success(this.nationalCloudQueryService.getCloudMeta(null));
        }
        catch (Exception e) {
            e.printStackTrace();
            return RestResult.error((String)"\u67e5\u8be2\u5931\u8d25");
        }
    }

    @ApiOperation(value="\u7701\u7ea7 - \u67e5\u8be2\u914d\u7f6e")
    @ApiOperationSupport(order=5)
    @GetMapping(value={"/getSJCloudMeta.action"})
    public RestResult<LinkedHashMap<String, List<CloudQueryItemSj>>> getSJCloudMeta(@RequestHeader(value="Access_token") String token) throws Exception {
        return RestResult.success(this.provincialCloudQueryService.getCloudQueryMeta());
    }

    @ApiOperation(value="\u7701\u7ea7 - \u4e91\u5ba1\u6279\u89c4\u5219\u5143-\u5143\u6570\u636e")
    @ApiOperationSupport(order=5)
    @GetMapping(value={"/getSJRuleMeta.action"})
    public RestResult<JSONArray> getSJRuleMeta(@RequestHeader(value="Access_token") String token) throws Exception {
        return RestResult.success((Object)this.provincialCloudQueryService.getCloudRuleMeta());
    }

    @ApiOperation(value="\u7701\u7ea7 - \u67e5\u8be2")
    @ApiOperationSupport(order=4)
    @PostMapping(value={"/addSJCloudQuery.action"})
    public RestResult<String> addWebCloudQuery(@RequestHeader(value="Access_token") String token, @RequestBody Map<String, Object> params) throws Exception {
        return RestResult.success((Object)this.provincialCloudQueryService.sendCloudQuery(params));
    }

    @ApiOperation(value="\u7701\u7ea7 - \u4e91\u5ba1\u6279")
    @ApiOperationSupport(order=4)
    @PostMapping(value={"/addSJCloudRule.action"})
    public RestResult<String> addSJCloudRule(@RequestHeader(value="Access_token") String token, @RequestBody Map<String, Object> params) throws Exception {
        return RestResult.success((Object)this.provincialCloudQueryService.sendCloudQuery(params));
    }

    @ApiOperation(value="\u7701\u7ea7 - \u67e5\u8be2\u914d\u7f6e")
    @ApiOperationSupport(order=5)
    @GetMapping(value={"/getSJCloudQueryConfig.action"})
    public RestResult<List<Map<String, Object>>> getSJCloudQueryConfig(@RequestHeader(value="Access_token") String token) throws Exception {
        return RestResult.success(this.provincialCloudQueryService.getCloudQueryConfig());
    }

    @ApiOperation(value="\u7701\u7ea7 - \u67e5\u8be2\u914d\u7f6e\uff08\u79fb\u52a8\u7aef\u4f7f\u7528\uff09")
    @ApiOperationSupport(order=5)
    @GetMapping(value={"/getSJCloudQueryConfigApp.action"})
    public RestResult<Map> getSJCloudQueryConfigApp(@RequestHeader(value="Access_token") String token) throws Exception {
        List<Map<String, Object>> config = this.provincialCloudQueryService.getCloudQueryConfig();
        return RestResult.success((Object)MapUtil.builder((Object)"Results", config).put((Object)"Message", (Object)"success").put((Object)"StatusCode", (Object)"200").build());
    }

    @ApiOperation(value="\u7701\u7ea7 - \u67e5\u8be2\u7ed3\u679c")
    @ApiOperationSupport(order=6)
    @GetMapping(value={"/getCloudQueryInfo.action"})
    public RestResult<JSONArray> getCloudQueryResult(@RequestHeader(value="Access_token") String token, String id, String serviceId) {
        return RestResult.success((Object)this.provincialCloudQueryService.getCloudQueryInfo(id, serviceId));
    }

    @ApiOperation(value="\u7701\u7ea7 - \u67e5\u8be2\u7ed3\u679c\uff08\u5168\u90e8\uff09")
    @ApiOperationSupport(order=6)
    @RequestMapping(value={"/getSJCloudQueryResultsById.action"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public RestResult<JSONObject> getSJCloudQueryInfo(@RequestHeader(value="Access_token") String token, @RequestParam String requestId) {
        return RestResult.success((Object)this.provincialCloudQueryService.getResultDetail(requestId));
    }

    @ApiOperation(value="\u7701\u7ea7 - \u5ba1\u6279\u7ed3\u679c\uff08\u5168\u90e8\uff09")
    @ApiOperationSupport(order=6)
    @RequestMapping(value={"/getSJCloudRuleResultsById.action"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public RestResult<com.alibaba.fastjson.JSONObject> getSJCloudRuleInfo(@RequestHeader(value="Access_token") String token, @RequestParam String ruleId) {
        return RestResult.success((Object)this.provincialCloudQueryService.getRuleResultDetail(ruleId));
    }

    @ApiOperation(value="\u7701\u7ea7 - \u66f4\u65b0\u4e91\u67e5\u8be2\u9879")
    @ApiOperationSupport(order=7)
    @GetMapping(value={"/updateSJCloudQueryConfig.action"})
    public RestResult<Boolean> updateSJCloudQueryConfig(@RequestHeader(value="Access_token") String token, String planId) throws Exception {
        this.provincialCloudQueryService.updateCloudQueryConfig(planId);
        return RestResult.success((Object)true);
    }

    @ApiOperation(value="\u7701\u7ea7 - \u91cd\u65b0\u63d0\u4ea4")
    @ApiOperationSupport(order=8)
    @PostMapping(value={"/resetSJCloudQuery.action"})
    public RestResult<com.alibaba.fastjson.JSONObject> resetCloudQuery(@RequestHeader(value="Access_token") String token, @RequestParam String id, String serviceId) {
        return RestResult.success((Object)this.provincialCloudQueryService.resetCloudQuery(id, serviceId));
    }

    @ApiOperation(value="\u7701\u7ea7 - \u83b7\u53d6\u56fe\u7247")
    @ApiOperationSupport(order=9)
    @GetMapping(value={"/getCloudQueryImg.action"})
    public RestResult<JSONArray> getProvincialImages(@RequestHeader(value="Access_token") String token, String id, String serviceId) {
        return RestResult.success((Object)this.provincialCloudQueryService.getProvincialImages(id, serviceId));
    }

    @ApiOperation(value="\u914d\u7f6e - \u591a\u56fe\u5c42\u914d\u7f6e")
    @ApiOperationSupport(order=10)
    @GetMapping(value={"/multiMap/getMultiMapConfig"})
    public RestResult<MultiMapConfig> getMultiMapConfig(@RequestHeader(value="Access_token") String token, String key) {
        return RestResult.success((Object)this.multiMapConfigService.getByKey(key));
    }

    @ApiOperation(value="\u7edf\u8ba1 - \u4fdd\u5b58\u76f8\u5173id")
    @ApiOperationSupport(order=11)
    @PostMapping(value={"/statis/saveQueryId"})
    public RestResult<Boolean> addStatistics(CloudQueryStatistics statistics) {
        this.cloudQueryStatisticsService.addStatistics(statistics);
        return RestResult.success((Object)true);
    }

    @ApiOperation(value="\u7edf\u8ba1 - \u83b7\u53d6\u7edf\u8ba1")
    @ApiOperationSupport(order=12)
    @PostMapping(value={"/statis/{serviceName}"})
    public RestResult<Map<String, Object>> statisticsByServiceName2(@RequestBody String analysisResult, @ApiParam(value="\u7701\u7ea7\u670d\u52a1Id\uff08\u9ed8\u8ba4\u53d6\u7cfb\u7edf\u914d\u7f6e\u53c2\u6570 geoServerOpen-dtsp\uff09") @RequestParam(value="dtspId", required=false) String serviceId, @PathVariable(value="serviceName") String serviceName) {
        return RestResult.success(this.provincialCloudQueryService.statisticsByServiceName(serviceName, serviceId, analysisResult));
    }

    @ApiOperation(value="\u7edf\u8ba1 - \u83b7\u53d6\u6700\u65b0\u7edf\u8ba1")
    @ApiOperationSupport(order=13)
    @GetMapping(value={"/statis/query"})
    public RestResult<CloudQueryStatistics> queryId(@ApiParam(value="\u4efb\u52a1id", required=true) @RequestParam String taskId, @ApiParam(value="\u6570\u636eid", required=true) @RequestParam String dataId, @ApiParam(value="\u7c7b\u578b\uff080\u3001\u56fd\u5bb6\u7ea7\uff1b1\u3001\u7701\u7ea7\uff09", required=true) @RequestParam(value="type", required=false) Integer type) {
        return RestResult.success((Object)this.cloudQueryStatisticsService.getLatest(taskId, dataId, type));
    }

    @ApiOperation(value="\u7edf\u8ba1 - \u4efb\u52a1\u56fe\u6591\u4e91\u67e5\u8be2")
    @ApiOperationSupport(order=14)
    @GetMapping(value={"/task/queryData"})
    public RestResult<Object> taskQueryDataId(@RequestParam String dataId, @RequestParam String taskId, @RequestParam Integer type, String requestId, Integer update, String param) {
        return RestResult.success((Object)this.cloudQueryStatisticsService.queryByDataId(dataId, taskId, requestId, update != null && update == 1, type, param));
    }

    @RequestMapping(value={"getCloudQueryTaskByRequestId.action"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse getCloudQueryTaskByRequestId(HttpServletRequest request, @RequestParam String requestId) {
        BaseObjectResponse baseResponse = new BaseObjectResponse();
        try {
            List<CloudQueryDTO> querys = this.cloudQueryRecordService.getCloudQueryTaskByRequestId(requestId);
            ArrayList<com.alibaba.fastjson.JSONObject> list = new ArrayList<com.alibaba.fastjson.JSONObject>();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (int i = 0; i < querys.size(); ++i) {
                com.alibaba.fastjson.JSONObject cloudQuery = new com.alibaba.fastjson.JSONObject();
                cloudQuery.put("id", (Object)querys.get(i).getF_id());
                cloudQuery.put("name", (Object)querys.get(i).getUnionnames());
                cloudQuery.put("querytime", (Object)querys.get(i).getQuerytime());
                cloudQuery.put("state", (Object)querys.get(i).getUnionstates());
                cloudQuery.put("requestId", (Object)querys.get(i).getF_requestid());
                cloudQuery.put("cloudRuleId", (Object)querys.get(i).getF_cloudruleid());
                cloudQuery.put("lon", (Object)querys.get(i).getLon());
                cloudQuery.put("lat", (Object)querys.get(i).getLat());
                cloudQuery.put("wkt", (Object)querys.get(i).getWkt());
                cloudQuery.put("area", (Object)querys.get(i).getMj());
                list.add(cloudQuery);
            }
            baseResponse.setData(list);
        }
        catch (Exception e) {
            e.printStackTrace();
            baseResponse.setStatus("FAILURE");
            baseResponse.setMessage(e.getMessage());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u5bfc\u51fa - pdf \u6587\u6863")
    @ApiOperationSupport(order=15)
    @GetMapping(value={"/exportPdf"})
    public RestResult<String> exportPdf(@RequestParam String requestId, @RequestParam String templateId, @RequestParam(value="jsonParam", required=false) String jsonParam, @RequestParam(value="nodeId", required=false) String nodeId) {
        return RestResult.success((Object)this.cloudQueryStatisticsService.exportPdf(requestId, templateId, jsonParam, nodeId));
    }

    @ApiOperation(value="\u67e5\u8be2\u7ed3\u679c\u72b6\u6001")
    @ApiOperationSupport(order=1)
    @PostMapping(value={"/getRecordStateByRequestIds.action"})
    public RestResult<Map<String, Integer>> getRecordStateByRequestIds(@RequestHeader(value="Access_token") String token, @ApiParam(value="RequestId", required=true) @RequestParam(name="requestId", required=true) String requestId) throws Exception {
        return RestResult.success(this.combineCloudQueryService.getRecordStateByRequestIds(requestId));
    }

    @RequestMapping(value={"/exportReport"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public RestResult<String> exportModel(HttpServletRequest request, @ApiParam(value="RequestId", required=true) @RequestParam(name="requestId", required=true) String requestId) {
        try {
            List<CloudQueryItemSj> sjMetas = this.cloudQueryItemSjService.queryALL();
            List<CloudQueryDTO> querys = this.cloudQueryRecordService.getCloudQueryTaskByRequestId(requestId);
            JSONObject sjResult = this.provincialCloudQueryService.getResultDetail(requestId);
            String result = this.exportCloudDOCService.getCloudComplianceReports(querys.get(0), sjMetas, com.alibaba.fastjson.JSONObject.parseObject((String)sjResult.toString()));
            return RestResult.success((Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return RestResult.error((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/downReport"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public void downReport(HttpServletRequest request, HttpServletResponse response, @ApiParam(value="RequestId", required=true) @RequestParam(name="requestId", required=false) String requestId, @RequestParam(value="outFileName", required=false) String outFileName, @RequestParam(value="fullpath", required=false) String fullpath) {
        try {
            CloudQueryDTO cloudQueryDTO = null;
            if (StringUtils.isNotEmpty((CharSequence)requestId)) {
                List<CloudQueryDTO> querys = this.cloudQueryRecordService.getCloudQueryTaskByRequestId(requestId);
                cloudQueryDTO = querys.get(0);
            }
            this.exportCloudDOCService.down(response, fullpath, cloudQueryDTO, outFileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

