/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.znts.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.ns.smart.znts.entity.CloudQueryItemSj;
import com.geoway.ns.smart.znts.entity.CloudQueryPlan;
import com.geoway.ns.smart.znts.entity.CloudQueryPlanItem;
import com.geoway.ns.smart.znts.entity.CloudQueryPlanUser;
import com.geoway.ns.smart.znts.mapper.CloudQueryItemSjMapper;
import com.geoway.ns.smart.znts.service.CloudQueryItemSjService;
import com.geoway.ns.smart.znts.service.CloudQueryPlanItemService;
import com.geoway.ns.smart.znts.service.CloudQueryPlanService;
import com.geoway.ns.smart.znts.service.CloudQueryPlanUserService;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CloudQueryItemSjServiceImpl
extends ServiceImpl<CloudQueryItemSjMapper, CloudQueryItemSj>
implements CloudQueryItemSjService {
    @Resource
    private CloudQueryPlanUserService cloudQueryPlanUserService;
    @Resource
    private CloudQueryPlanService cloudQueryPlanService;
    @Resource
    private CloudQueryPlanItemService cloudQueryPlanItemService;

    @Override
    @Cacheable(value={"defaultCloudQueryItemSj"})
    public List<CloudQueryItemSj> queryDefault() {
        return this.queryByGroupTypeOrAll("\u57fa\u7840\u67e5\u8be2");
    }

    @Override
    public List<CloudQueryItemSj> queryALL() {
        return this.lambdaQuery().list();
    }

    @Override
    public List<CloudQueryItemSj> queryByDtsp(String dtspId) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(CloudQueryItemSj::getDtspid, (Object)dtspId)).list();
    }

    @Override
    public List<CloudQueryItemSj> queryByGroupTypeOrAll(String groupType) {
        if (StringUtils.isBlank((CharSequence)groupType)) {
            return this.lambdaQuery().list();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(CloudQueryItemSj::getGrouptype, (Object)groupType)).list();
    }

    @Override
    public List<CloudQueryItemSj> queryByGroupTypeOrAll(String groupType, String layers) {
        if (StringUtils.isBlank((CharSequence)groupType)) {
            return this.lambdaQuery().list();
        }
        LambdaQueryChainWrapper lambdaQuery = this.lambdaQuery();
        if (StringUtils.isNotBlank((CharSequence)layers)) {
            Object[] names = layers.split(",");
            ((LambdaQueryChainWrapper)lambdaQuery.eq(CloudQueryItemSj::getGrouptype, (Object)groupType)).in(CloudQueryItemSj::getServicealias, names);
        } else if (StringUtils.isNotBlank((CharSequence)groupType)) {
            return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(CloudQueryItemSj::getGrouptype, (Object)groupType)).list();
        }
        return lambdaQuery.list();
    }

    @Override
    public List<CloudQueryItemSj> getUserCloudQueryItems(String userId, String wkt, String group, String layers) {
        CloudQueryPlanUser cloudQueryPlanUser = this.cloudQueryPlanUserService.getByUserId(userId);
        if (cloudQueryPlanUser == null) {
            return this.queryDefault();
        }
        List<CloudQueryItemSj> cloudQueryItems = this.queryByGroupTypeOrAll(group, layers);
        List<CloudQueryPlanItem> cloudQueryPlanItems = this.cloudQueryPlanItemService.queryByPlanId(cloudQueryPlanUser.getPlanId());
        if (!CollectionUtils.isEmpty(cloudQueryPlanItems)) {
            cloudQueryItems = cloudQueryItems.stream().filter(cloudQueryItem -> cloudQueryPlanItems.stream().noneMatch(cloudQueryPlanItem -> cloudQueryPlanItem.getItemId().equals(cloudQueryItem.getServiceid()))).collect(Collectors.toList());
        }
        return cloudQueryItems;
    }

    @Override
    public List<CloudQueryItemSj> getService(String planId, List<String> wkt, List<String> layers) {
        CloudQueryPlan plan = (CloudQueryPlan)this.cloudQueryPlanService.getById((Serializable)((Object)planId));
        List<CloudQueryItemSj> cloudQueryItems = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(CloudQueryItemSj::getDtspid, (Object)plan.getDtspId())).list();
        cloudQueryItems = cloudQueryItems.stream().filter(f -> layers.contains(f.getServiceid())).collect(Collectors.toList());
        List<CloudQueryPlanItem> cloudQueryPlanItems = this.cloudQueryPlanItemService.queryByPlanId(planId);
        if (!CollectionUtils.isEmpty(cloudQueryPlanItems)) {
            List itemIds = cloudQueryPlanItems.stream().map(m -> m.getItemId()).collect(Collectors.toList());
            cloudQueryItems = cloudQueryItems.stream().filter(f -> !itemIds.contains(f.getServiceid())).collect(Collectors.toList());
        }
        return cloudQueryItems;
    }

    @Override
    public void truncate() {
        ((CloudQueryItemSjMapper)this.baseMapper).truncate();
    }
}

