/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.zntsnew.service.impl;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.geoway.ns.base.util.CommonsUtil;
import com.geoway.ns.onemap.encrypttool.entity.EncryptType;
import com.geoway.ns.onemap.encrypttool.service.BizEncryptRecordsService;
import com.geoway.ns.smart.znts.entity.CloudQueryItem;
import com.geoway.ns.smart.znts.service.CloudQueryItemService;
import com.geoway.ns.smart.znts.util.CloudQueryHttpUtil;
import com.geoway.ns.smart.zntsnew.dto.CentroidInfo;
import com.geoway.ns.smart.zntsnew.dto.CloudAnalaysParamDTO;
import com.geoway.ns.smart.zntsnew.dto.CloudGjQueryParamDTO;
import com.geoway.ns.smart.zntsnew.entity.CloudQueryRecordNew;
import com.geoway.ns.smart.zntsnew.enums.CloudQueryType;
import com.geoway.ns.smart.zntsnew.service.CloudQueryGJService;
import com.geoway.ns.smart.zntsnew.service.CloudQueryRecordNewService;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CloudQueryGJServiceImpl
implements CloudQueryGJService {
    @Autowired
    private CloudQueryItemService cloudQueryItemService;
    @Autowired
    private CloudQueryHttpUtil cloudQueryHttpUtil;
    @Autowired
    private CloudQueryRecordNewService cloudQueryRecordNewService;
    @Autowired
    private BizEncryptRecordsService bizEncryptRecordsService;
    @Value(value="${cloud.encryption.enable:false}")
    private boolean encryptioneEnable;

    @Override
    public String sendCloudQuery(String userId, String taskId, CloudAnalaysParamDTO param, CentroidInfo info) {
        Map queryParam = MapUtil.builder().put((Object)"width", (Object)param.getWidth()).put((Object)"height", (Object)param.getHeight()).put((Object)"range", (Object)info.getWkt()).put((Object)"options", (Object)3).put((Object)"lon", (Object)info.getLon()).put((Object)"lat", (Object)info.getLat()).put((Object)"mj", (Object)CommonsUtil.BigDecimals.divDouble((double)info.getArea(), (double)666.7, (Integer)2)).build();
        HashMap<String, List<CloudQueryItem>> requestMap = new HashMap<String, List<CloudQueryItem>>();
        HashMap cidMap = new HashMap();
        String requestId = null;
        List<CloudGjQueryParamDTO> country = param.getCountry();
        for (CloudGjQueryParamDTO paramDTO : country) {
            List<CloudQueryItem> items = this.cloudQueryItemService.getUserCloudQueryItems(userId, info.getWkt(), paramDTO.getGroup(), String.join((CharSequence)",", paramDTO.getLayer()), null);
            if (items.isEmpty()) continue;
            requestMap.put(paramDTO.getGroup(), items);
        }
        if (requestMap.isEmpty()) {
            throw new RuntimeException("\u8be5\u7528\u6237\u672a\u627e\u5230\u53ef\u7528\u5206\u6790\u9879\uff01");
        }
        CloudQueryRecordNew record = CloudQueryRecordNew.builder().startTime(new Date()).type(CloudQueryType.GJ.value).status(0).taskId(taskId).total(requestMap.size()).build();
        for (Map.Entry entry : requestMap.entrySet()) {
            queryParam.put("analyzetype", String.join((CharSequence)"\u3001", ((List)entry.getValue()).stream().map(m -> {
                String analyze = m.getName();
                if (m.getTime() != null) {
                    String format = DateFormatUtils.format((Date)m.getTime(), (String)"yyyyMMdd");
                    analyze = analyze + "_" + format;
                }
                return analyze;
            }).collect(Collectors.toList())));
            queryParam.put("group", entry.getKey());
            queryParam.put("requestId", requestId);
            JSONObject object = this.cloudQueryHttpUtil.sendCloudQuery(userId, JSON.toJSONString((Object)queryParam), requestId, null, (String)entry.getKey());
            if (MapUtil.isEmpty((Map)object)) {
                throw new RuntimeException("\u56fd\u5bb6\u4e91\u67e5\u8be2\u5931\u8d25\uff01");
            }
            String id = object.getString("id");
            requestId = object.getString("requestId");
            cidMap.put(entry.getKey(), id);
        }
        record.setRid(requestId);
        record.setCid(JSON.toJSONString(cidMap));
        this.cloudQueryRecordNewService.save(record);
        return record.getRid();
    }

    @Override
    public JSONObject queryAnalysResult(String rid, String group) {
        CloudQueryRecordNew one = (CloudQueryRecordNew)this.cloudQueryRecordNewService.getOne((Wrapper)Wrappers.lambdaQuery(CloudQueryRecordNew.class).eq(CloudQueryRecordNew::getRid, (Object)rid));
        if (one == null) {
            throw new RuntimeException("\u672a\u67e5\u5230\u4e91\u67e5\u8be2\u5206\u6790\u8bb0\u5f55\uff01");
        }
        if (one.getStatus() == 0) {
            throw new RuntimeException("\u56fd\u5bb6\u4e91\u67e5\u8be2\uff1a\u4efb\u52a1\u6b63\u5728\u8fdb\u884c\u4e2d\uff01");
        }
        String cid = one.getCid();
        Map map = (Map)JSON.parseObject((String)cid, Map.class);
        String id = (String)map.get(group);
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new RuntimeException("\u56fd\u5bb6\u4e91\u67e5\u8be2\uff1a\u8be5\u5206\u7ec4\u4e0b\u65e0\u6570\u636e\uff01");
        }
        JSONObject cloudQueryResultDetail = this.cloudQueryHttpUtil.getCloudQueryResultDetail(id);
        if (this.encryptioneEnable) {
            try {
                for (String groupKey : cloudQueryResultDetail.keySet()) {
                    JSONObject groupObject = cloudQueryResultDetail.getJSONObject(groupKey);
                    for (String key : groupObject.keySet()) {
                        JSONObject object = groupObject.getJSONObject(key);
                        if (object == null) continue;
                        for (String valueKey : object.keySet()) {
                            GeometryFactory geometryFactory = new GeometryFactory();
                            if (!valueKey.equals("location")) continue;
                            ObjectMapper mapper = new ObjectMapper();
                            double[][] imageBounds = (double[][])mapper.readValue(object.getString(valueKey), double[][].class);
                            double xMin = imageBounds[0][0];
                            double yMin = imageBounds[0][1];
                            double xMax = imageBounds[1][0];
                            double yMax = imageBounds[1][1];
                            ArrayList<Coordinate> colist1 = new ArrayList<Coordinate>();
                            colist1.add(new Coordinate(xMin, yMin));
                            colist1.add(new Coordinate(xMin, yMax));
                            colist1.add(new Coordinate(xMax, yMax));
                            colist1.add(new Coordinate(xMax, yMin));
                            colist1.add(new Coordinate(xMin, yMin));
                            Coordinate[] cn = colist1.toArray(new Coordinate[colist1.size()]);
                            Polygon polygon1 = geometryFactory.createPolygon(cn);
                            String newWkt = this.bizEncryptRecordsService.wktEncrypt(polygon1.toText(), EncryptType.Encrypt);
                            List coordinates = this.bizEncryptRecordsService.fromWKT(newWkt);
                            imageBounds[0][0] = ((Coordinate[])coordinates.get((int)0))[0].x;
                            imageBounds[0][1] = ((Coordinate[])coordinates.get((int)0))[0].y;
                            imageBounds[1][0] = ((Coordinate[])coordinates.get((int)0))[2].x;
                            imageBounds[1][1] = ((Coordinate[])coordinates.get((int)0))[2].y;
                            object.put("location", (Object)mapper.writeValueAsString((Object)imageBounds));
                        }
                        groupObject.put(key, (Object)object);
                    }
                    cloudQueryResultDetail.put(groupKey, (Object)groupObject);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return cloudQueryResultDetail;
    }
}

