-- ----------------------------
--2024年7月15日，oyyh，创建联动更新工具相关业务库表
-- ----------------------------


CREATE TABLE IF NOT EXISTS tb_smart_update_business (
    f_id varchar NOT NULL,
    f_business_name varchar(200),
    f_app_name varchar(200),
    f_order int4,
    CONSTRAINT tb_smart_update_business_pkey PRIMARY KEY (f_id)
);
COMMENT ON COLUMN tb_smart_update_business.f_id IS '主键id';
COMMENT ON COLUMN tb_smart_update_business.f_business_name IS '业务名称';
COMMENT ON COLUMN tb_smart_update_business.f_app_name IS '更新系统';
COMMENT ON COLUMN tb_smart_update_business.f_order IS '排序';


CREATE TABLE IF NOT EXISTS tb_smart_update_business_item (
    f_id varchar(40) NOT NULL,
    f_business_id varchar(40),
    f_update_service_id varchar(40),
    f_content_field varchar(100),
    f_bz text,
    CONSTRAINT tb_smart_update_business_item_pkey PRIMARY KEY (f_id)
);
COMMENT ON COLUMN tb_smart_update_business_item.f_id IS '主键id';
COMMENT ON COLUMN tb_smart_update_business_item.f_business_id IS '业务id';
COMMENT ON COLUMN tb_smart_update_business_item.f_update_service_id IS '联动更新服务id';
COMMENT ON COLUMN tb_smart_update_business_item.f_content_field IS '更新内容展示字段';
COMMENT ON COLUMN tb_smart_update_business_item.f_bz IS '备注';


CREATE TABLE IF NOT EXISTS tb_smart_update_record (
    f_uniquetaskid varchar(40) NOT NULL,
    f_business_id varchar(40),
    f_update_service_id varchar(40),
    f_updatetime timestamp(6),
    f_update_rows int4,
    CONSTRAINT tb_smart_update_record_pkey PRIMARY KEY (f_uniquetaskid)
);
COMMENT ON COLUMN tb_smart_update_record.f_uniquetaskid IS '主键id';
COMMENT ON COLUMN tb_smart_update_record.f_business_id IS '业务id';
COMMENT ON COLUMN tb_smart_update_record.f_update_service_id IS '联动更新服务类型';
COMMENT ON COLUMN tb_smart_update_record.f_updatetime IS '更新时间';
COMMENT ON COLUMN tb_smart_update_record.f_update_rows IS '更新记录数';


CREATE INDEX IF NOT EXISTS i_tb_smart_update_business_item ON tb_smart_update_business_item(f_business_id);
CREATE INDEX IF NOT EXISTS i_tb_smart_update_record ON tb_smart_update_record(
    f_business_id,
    f_update_service_id,
    f_updatetime
    );