/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.codequery.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.ns.smart.codequery.entity.CodequeryCatalog;
import com.geoway.ns.smart.codequery.entity.CodequeryGroup;
import com.geoway.ns.smart.codequery.mapper.CodequeryGroupMapper;
import com.geoway.ns.smart.codequery.service.CodequeryCatalogService;
import com.geoway.ns.smart.codequery.service.CodequeryGroupService;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CodequeryGroupServiceImpl
extends ServiceImpl<CodequeryGroupMapper, CodequeryGroup>
implements CodequeryGroupService {
    @Autowired
    CodequeryCatalogService codequeryCatalogService;
    @Autowired
    CodequeryGroupMapper codequeryGroupMapper;

    @Override
    public List<CodequeryGroup> queryBySchemeId(String schemeId) {
        return this.list((Wrapper)Wrappers.lambdaQuery(CodequeryGroup.class).eq(CodequeryGroup::getSchemeId, (Object)schemeId));
    }

    @Override
    public List<CodequeryGroup> queryListWithCatalogsBySchemeId(String schemeId) {
        List groups = this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CodequeryGroup.class).eq(CodequeryGroup::getSchemeId, (Object)schemeId)).orderByAsc(CodequeryGroup::getOrder));
        if (groups != null && groups.size() > 0) {
            for (CodequeryGroup group : groups) {
                List<CodequeryCatalog> catalogs = this.codequeryCatalogService.queryTree(schemeId, group.getId(), null);
                group.setCatalogList(catalogs);
            }
        }
        return groups;
    }

    @Override
    public boolean saveOrUpdateInfo(CodequeryGroup codequeryGroup) {
        if (codequeryGroup == null) {
            return false;
        }
        if (StringUtil.isEmpty((String)codequeryGroup.getId())) {
            Integer order = this.codequeryGroupMapper.selectMaxOrder(codequeryGroup.getSchemeId());
            order = order == null ? 1 : order + 1;
            codequeryGroup.setOrder(order);
        }
        return this.saveOrUpdate(codequeryGroup);
    }

    @Override
    public boolean deleteById(String id) {
        CodequeryGroup codequeryGroup = (CodequeryGroup)this.getById((Serializable)((Object)id));
        if (codequeryGroup == null) {
            return false;
        }
        List<CodequeryCatalog> catalogs = this.codequeryCatalogService.queryList(codequeryGroup.getSchemeId(), codequeryGroup.getId(), null);
        List<String> ids = catalogs.stream().map(CodequeryCatalog::getId).collect(Collectors.toList());
        this.codequeryCatalogService.deleteMulti(ids);
        return this.removeById((Serializable)((Object)id));
    }

    @Override
    public boolean deleteBySchemeId(String schemeId) {
        return this.remove((Wrapper)Wrappers.lambdaQuery(CodequeryGroup.class).eq(CodequeryGroup::getSchemeId, (Object)schemeId));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean sort(String id, int order) {
        CodequeryGroup curGroup = (CodequeryGroup)this.getById((Serializable)((Object)id));
        if (curGroup == null) {
            return true;
        }
        if (curGroup.getOrder().equals(order)) {
            return true;
        }
        List needUpdateList = null;
        if (curGroup.getOrder() > order) {
            needUpdateList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CodequeryGroup.class).eq(CodequeryGroup::getSchemeId, (Object)curGroup.getSchemeId())).ge(CodequeryGroup::getOrder, (Object)order)).lt(CodequeryGroup::getOrder, (Object)curGroup.getOrder())).orderByAsc(CodequeryGroup::getOrder));
            for (int i = 0; i < needUpdateList.size(); ++i) {
                ((CodequeryGroup)needUpdateList.get(i)).setOrder(order + i + 1);
            }
        } else {
            needUpdateList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CodequeryGroup.class).eq(CodequeryGroup::getSchemeId, (Object)curGroup.getSchemeId())).gt(CodequeryGroup::getOrder, (Object)curGroup.getOrder())).le(CodequeryGroup::getOrder, (Object)order)).orderByAsc(CodequeryGroup::getOrder));
            for (int i = 0; i < needUpdateList.size(); ++i) {
                ((CodequeryGroup)needUpdateList.get(i)).setOrder(curGroup.getOrder() + i);
            }
        }
        curGroup.setOrder(order);
        needUpdateList.add(curGroup);
        return this.updateBatchById(needUpdateList);
    }
}

