/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.ydsphlpd.service.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ZipUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.adf.dms.config.dto.sysparam.SysParamDTO;
import com.geoway.adf.dms.config.dto.sysparam.SysParamGroupDTO;
import com.geoway.adf.dms.config.service.SysParamsService;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.file.FileDTO;
import com.geoway.adf.dms.datasource.manager.DataSourceManager;
import com.geoway.adf.dms.datasource.service.FileStorageService;
import com.geoway.adf.gis.fs.IFileStorage;
import com.geoway.adf.gis.fs.obstorage.IObjectStorage;
import com.geoway.ns.geoserver3.dto.SpatialBlock;
import com.geoway.ns.geoserver3.dto.TbAnalysisTask;
import com.geoway.ns.geoserver3.dto.WktExportDTO;
import com.geoway.ns.geoserver3.dto.file2wkt.FileDataDTO;
import com.geoway.ns.geoserver3.dto.file2wkt.XmBlockDTO;
import com.geoway.ns.geoserver3.service.IGeoserver3ConfigService;
import com.geoway.ns.geoserver3.service.IGeoserver3TaskService;
import com.geoway.ns.geoserver3.service.IYZFXService;
import com.geoway.ns.smart.ydsphlpd.dto.TbYdsphTaskFilterDTO;
import com.geoway.ns.smart.ydsphlpd.dto.YdsphlpdConfigDTO;
import com.geoway.ns.smart.ydsphlpd.dto.YdsphlpdTaskDetailDTO;
import com.geoway.ns.smart.ydsphlpd.entity.TbYdsphlpdTask;
import com.geoway.ns.smart.ydsphlpd.entity.TbYdsphlpdTaskData;
import com.geoway.ns.smart.ydsphlpd.mapper.TbYdsphlpdTaskMapper;
import com.geoway.ns.smart.ydsphlpd.service.TbYdsphlpdTaskService;
import com.geoway.ns.smart.ydsphlpd.service.impl.TbYdsphlpdTaskDataServiceImpl;
import com.geoway.ns.sys.dto.SysUserDTO;
import com.geoway.ns.sys.service.ITokenService;
import com.geoway.ns.sys.utils.MyRequestUtil;
import com.geoway.ns.sys.utils.UpAndDownloadUtil;
import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class TbYdsphlpdTaskServiceImpl
extends ServiceImpl<TbYdsphlpdTaskMapper, TbYdsphlpdTask>
implements TbYdsphlpdTaskService {
    private final String YZFXCustomDatasourceServiceName = "custom-datasource";
    private final String Smart_Ydspldpd_Key = "smart_ydsphlpd";
    private final String UplaodDsKey = "uplaodDsKey";
    private final String UploadRelativePath = "uploadRelativePath";
    private final String DownloadUrlPrefix = "downloadUrlPrefix";
    private final String ZipShpLayerName = "zipShpLayerName";
    private final String TxtReadType = "txtReadType";
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    @Autowired
    private DataSourceManager dataSourceManager;
    @Autowired
    private IGeoserver3ConfigService geoserver3ConfigService;
    @Autowired
    private IGeoserver3TaskService geoserver3TaskService;
    @Autowired
    private IYZFXService yzfxService;
    @Autowired
    private TbYdsphlpdTaskDataServiceImpl tbYdsphlpdTaskDataService;
    @Autowired
    private FileStorageService fileStorageService;
    @Autowired
    private ITokenService tokenService;
    @Autowired
    private SysParamsService sysParamsService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TbYdsphlpdTask createTask(MultipartFile txt, MultipartFile shp) throws Exception {
        YdsphlpdConfigDTO ydsphlpdConfig = this.checkConfig();
        FileDataDTO fileDataDTO = this.checkTxt(ydsphlpdConfig, txt);
        String shpLayerName = this.checkShp(ydsphlpdConfig, shp);
        LocalDateTime localDateTime = LocalDateTime.now();
        String txtNameWithoutExt = FileUtil.mainName((String)txt.getOriginalFilename());
        String taskName = txtNameWithoutExt + localDateTime.format(this.formatter);
        TbYdsphlpdTask exist = (TbYdsphlpdTask)this.getOne((Wrapper)Wrappers.lambdaQuery(TbYdsphlpdTask.class).eq(TbYdsphlpdTask::getName, (Object)taskName));
        if (exist != null) {
            throw new RuntimeException(String.format("\u4efb\u52a1\u3010%s\u3011\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u63d0\u4ea4", taskName));
        }
        String taskId = UUID.randomUUID().toString();
        String uploadPath = this.getUploadPath(ydsphlpdConfig);
        FileDTO uploadDirFileDTO = this.fileStorageService.createDirectory(ydsphlpdConfig.getUplaodDsKey(), uploadPath, taskName);
        this.fileStorageService.uploadFile(txt, ydsphlpdConfig.getUplaodDsKey(), uploadDirFileDTO.getFullPath(), Boolean.valueOf(true));
        this.fileStorageService.uploadFile(shp, ydsphlpdConfig.getUplaodDsKey(), uploadDirFileDTO.getFullPath(), Boolean.valueOf(true));
        return this.saveTask(ydsphlpdConfig, taskId, taskName, localDateTime, uploadDirFileDTO, txt, fileDataDTO, shp, shpLayerName);
    }

    @Override
    public IPage<TbYdsphlpdTask> pageTask(TbYdsphTaskFilterDTO taskFilterDTO) throws Exception {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(TbYdsphlpdTask.class);
        if (taskFilterDTO != null && taskFilterDTO.getStatus() != -9999) {
            wrapper.eq(TbYdsphlpdTask::getStatus, (Object)taskFilterDTO.getStatus());
        }
        if (taskFilterDTO != null && taskFilterDTO.getStartTime() != null) {
            wrapper.ge(TbYdsphlpdTask::getCreateTime, (Object)taskFilterDTO.getStartTime());
        }
        if (taskFilterDTO != null && taskFilterDTO.getEndTime() != null) {
            wrapper.le(TbYdsphlpdTask::getCreateTime, (Object)taskFilterDTO.getEndTime());
        }
        wrapper.orderByDesc(TbYdsphlpdTask::getCreateTime);
        Page page = new Page((long)taskFilterDTO.getPage(), (long)taskFilterDTO.getSize());
        IPage pageRecords = this.page((IPage)page, (Wrapper)wrapper);
        this.updateTaskStatus(pageRecords.getRecords());
        this.queryUserName(pageRecords.getRecords());
        return pageRecords;
    }

    @Override
    public YdsphlpdTaskDetailDTO taskDetail(String taskId) throws Exception {
        TbYdsphlpdTask task = (TbYdsphlpdTask)this.getById((Serializable)((Object)taskId));
        if (task == null) {
            throw new RuntimeException("\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        if (task.getStatus() != 200) {
            throw new RuntimeException("\u4efb\u52a1\u672a\u5b8c\u6210\u65e0\u6cd5\u67e5\u8be2\u8be6\u60c5\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        this.queryUserName(new ArrayList<TbYdsphlpdTask>(Arrays.asList(task)));
        TbYdsphlpdTaskData taskData = (TbYdsphlpdTaskData)this.tbYdsphlpdTaskDataService.getById((Serializable)((Object)taskId));
        YdsphlpdTaskDetailDTO taskDetailDTO = null;
        if (StringUtils.isEmpty((CharSequence)taskData.getResultDetail())) {
            taskDetailDTO = this.queryByGeoserver(task, taskData);
            taskData.setResultDetail(JSON.toJSONString((Object)taskDetailDTO));
            this.tbYdsphlpdTaskDataService.saveOrUpdate(taskData);
        } else {
            taskDetailDTO = (YdsphlpdTaskDetailDTO)JSON.parseObject((String)taskData.getResultDetail(), YdsphlpdTaskDetailDTO.class);
        }
        taskDetailDTO.setUserName(task.getUserName());
        return taskDetailDTO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void startTask(List<String> taskIds) throws Exception {
        YdsphlpdConfigDTO ydsphlpdConfig = this.checkConfig();
        String token = MyRequestUtil.queryAccessTokenInHeader();
        List lstTasks = this.listByIds(taskIds);
        List lstTaskData = this.tbYdsphlpdTaskDataService.listByIds(taskIds);
        Map<String, TbYdsphlpdTaskData> mapTaskData = lstTaskData.stream().collect(Collectors.toMap(TbYdsphlpdTaskData::getId, p -> p));
        for (TbYdsphlpdTask task : lstTasks) {
            TbYdsphlpdTaskData taskData = mapTaskData.get(task.getId());
            this.startTask(ydsphlpdConfig, task, taskData, token);
        }
        this.updateBatchById(lstTasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteTask(List<String> taskIds) throws Exception {
        YdsphlpdConfigDTO ydsphlpdConfig = this.checkConfig();
        try (IFileStorage fileStorage = this.fileStorageService.openFileStorage(ydsphlpdConfig.getUplaodDsKey());){
            List lstTasks = this.listByIds(taskIds);
            String uploadPath = this.getUploadPath(ydsphlpdConfig);
            String delPath = null;
            for (TbYdsphlpdTask task : lstTasks) {
                delPath = uploadPath.endsWith(fileStorage.getSeparator()) ? uploadPath + task.getName() : uploadPath + fileStorage.getSeparator() + task.getName();
                if (fileStorage instanceof IObjectStorage) {
                    delPath = delPath + fileStorage.getSeparator();
                }
                this.fileStorageService.deleteFile(ydsphlpdConfig.getUplaodDsKey(), delPath, true);
            }
            fileStorage.close();
            this.removeBatchByIds(taskIds);
            this.tbYdsphlpdTaskDataService.removeBatchByIds(taskIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void txt2Shp(HttpServletResponse response, List<String> taskIds) throws Exception {
        String tempDirPath = this.getTempPath();
        try {
            List lstTasks = this.listByIds(taskIds);
            Map<String, TbYdsphlpdTask> mapTasks = lstTasks.stream().collect(Collectors.toMap(TbYdsphlpdTask::getId, p -> p));
            List lstTaskData = this.tbYdsphlpdTaskDataService.listByIds(taskIds);
            WktExportDTO wktExportDTO = null;
            for (TbYdsphlpdTaskData taskData : lstTaskData) {
                TbYdsphlpdTask task = mapTasks.get(taskData.getId());
                wktExportDTO = new WktExportDTO();
                wktExportDTO.setFileType(".shp");
                wktExportDTO.setFileName(task.getName().replace(".txt", ""));
                wktExportDTO.setBlocks(JSON.parseArray((String)taskData.getBlocks(), WktExportDTO.BlockDTO.class));
                String destFilePath = tempDirPath + File.separator + wktExportDTO.getFileName() + ".zip";
                String url = this.geoserver3ConfigService.getUrl();
                String serverUrl = url + "/rest/analysis/wktExport";
                String paramMapStr = JSON.toJSONString((Object)wktExportDTO);
                HttpResponse httpResponse = HttpRequest.post((String)serverUrl).body(paramMapStr).execute();
                httpResponse.writeBody(destFilePath);
                ZipUtil.unzip((String)destFilePath);
                FileUtil.del((String)destFilePath);
            }
            UpAndDownloadUtil.dowmloadDirectory((HttpServletResponse)response, (String)tempDirPath);
        }
        finally {
            FileUtils.deleteQuietly((File)new File(tempDirPath));
        }
    }

    private YdsphlpdConfigDTO checkConfig() throws Exception {
        YdsphlpdConfigDTO ydsphlpdConfig = this.queryConfig();
        if (StringUtils.isEmpty((CharSequence)ydsphlpdConfig.getUplaodDsKey())) {
            throw new RuntimeException("\u672a\u914d\u7f6e\u4e0a\u4f20\u6587\u4ef6\u6570\u636e\u6e90key\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)ydsphlpdConfig.getDownloadUrlPrefix())) {
            throw new RuntimeException("\u672a\u914d\u7f6e\u4e0b\u8f7d\u5730\u5740\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)ydsphlpdConfig.getDownloadUrlPrefix())) {
            throw new RuntimeException("\u672a\u914d\u7f6e\u538b\u7f29\u5305\u91cc\u8981\u5206\u6790\u7684shp\u56fe\u5c42\u540d\uff01");
        }
        try (IFileStorage fileStorage = null;){
            fileStorage = this.fileStorageService.openFileStorage(ydsphlpdConfig.getUplaodDsKey());
            if (fileStorage == null) {
                throw new RuntimeException("\u6587\u4ef6\u5e93\u6253\u5f00\u5931\u8d25");
            }
        }
        return ydsphlpdConfig;
    }

    private YdsphlpdConfigDTO queryConfig() {
        SysParamGroupDTO sysParamGroupDTO = this.sysParamsService.getGroupDetail("smart_ydsphlpd");
        if (sysParamGroupDTO == null || sysParamGroupDTO.getParams() == null) {
            throw new RuntimeException(String.format("\u672a\u914d\u7f6e\u7cfb\u7edf\u53c2\u6570\u3010%s\u3011", "smart_ydsphlpd"));
        }
        YdsphlpdConfigDTO ydsphlpdConfigDTO = new YdsphlpdConfigDTO();
        for (SysParamDTO sysParamDTO : sysParamGroupDTO.getParams()) {
            if ("uplaodDsKey".equals(sysParamDTO.getKey())) {
                ydsphlpdConfigDTO.setUplaodDsKey(sysParamDTO.getValue());
                continue;
            }
            if ("uploadRelativePath".equals(sysParamDTO.getKey())) {
                ydsphlpdConfigDTO.setUploadRelativePath(sysParamDTO.getValue());
                continue;
            }
            if ("downloadUrlPrefix".equals(sysParamDTO.getKey())) {
                ydsphlpdConfigDTO.setDownloadUrlPrefix(sysParamDTO.getValue());
                continue;
            }
            if ("zipShpLayerName".equals(sysParamDTO.getKey())) {
                ydsphlpdConfigDTO.setZipShpLayerName(sysParamDTO.getValue());
                continue;
            }
            if (!"txtReadType".equals(sysParamDTO.getKey())) continue;
            ydsphlpdConfigDTO.setTxtReadType(sysParamDTO.getValue());
        }
        return ydsphlpdConfigDTO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileDataDTO checkTxt(YdsphlpdConfigDTO ydsphlpdConfig, MultipartFile txt) throws Exception {
        if (!txt.getOriginalFilename().endsWith(".txt")) {
            throw new RuntimeException("\u9879\u76ee\u8303\u56f4\u6587\u4ef6\u53ea\u652f\u6301txt\u683c\u5f0f\uff01");
        }
        String tempDirPath = this.getTempPath();
        File tempDirFile = new File(tempDirPath);
        try {
            String tempFilePath = tempDirPath + File.separator + txt.getOriginalFilename();
            FileUtil.writeBytes((byte[])txt.getBytes(), (String)tempFilePath);
            File[] files1 = new File[]{new File(tempFilePath)};
            String url = this.geoserver3ConfigService.getUrl();
            String serverUrl = url + "/rest/analysis/upload";
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("fileData", files1);
            paramMap.put("readType", ydsphlpdConfig.getTxtReadType());
            String resultStr = HttpUtil.post((String)serverUrl, paramMap);
            JSONObject txtResult = JSON.parseObject((String)resultStr);
            FileDataDTO fileDataDTO = (FileDataDTO)txtResult.toJavaObject(FileDataDTO.class);
            if (fileDataDTO == null || fileDataDTO.getXmxx() == null || fileDataDTO.getXmxx().getBlocks() == null || fileDataDTO.getXmxx().getBlocks().size() == 0) {
                throw new RuntimeException("\u9879\u76ee\u8303\u56f4\u6587\u4ef6\u89e3\u6790\u5931\u8d25\uff1a" + txtResult.toString());
            }
            if (fileDataDTO.getXmin() < -180.0 || fileDataDTO.getXmax() > 180.0 || fileDataDTO.getYmin() < -90.0 || fileDataDTO.getYmax() > 90.0) {
                throw new RuntimeException("\u9879\u76ee\u8303\u56f4\u4e0d\u5728\u5408\u7406\u8303\u56f4\u5185\uff0c\u7ecf\u5ea6\uff08-180~180\uff09\uff0c\u7eac\u5ea6\uff08-90~90\uff09" + txtResult.toString());
            }
            FileDataDTO fileDataDTO2 = fileDataDTO;
            return fileDataDTO2;
        }
        finally {
            FileUtils.deleteQuietly((File)tempDirFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkShp(YdsphlpdConfigDTO ydsphlpdConfig, MultipartFile shp) throws Exception {
        if (!shp.getOriginalFilename().endsWith(".zip")) {
            throw new RuntimeException("\u6240\u6709\u6743\u6570\u636e\u53ea\u652f\u6301zip\u683c\u5f0f\uff01");
        }
        String tempDirPath = this.getTempPath();
        File tempDirFile = new File(tempDirPath);
        try {
            String shpLayerName;
            String tempFilePath = tempDirPath + File.separator + shp.getOriginalFilename();
            FileUtil.writeBytes((byte[])shp.getBytes(), (String)tempFilePath);
            File unZipDir = ZipUtil.unzip((String)tempFilePath);
            List matchedFiles = FileUtil.loopFiles((String)unZipDir.getAbsolutePath(), file -> file.getName().endsWith(ydsphlpdConfig.getZipShpLayerName() + ".shp"));
            if (matchedFiles == null || matchedFiles.size() == 0) {
                throw new RuntimeException(String.format("\u538b\u7f29\u5305\u4e2d\u672a\u67e5\u627e\u5230\u5305\u542b\u3010%s\u3011\u7684shp\u56fe\u5c42\uff01", ydsphlpdConfig.getZipShpLayerName()));
            }
            if (matchedFiles.size() > 1) {
                throw new RuntimeException(String.format("\u538b\u7f29\u5305\u4e2d\u67e5\u627e\u5230\u591a\u4e2a\u5305\u542b\u3010%s\u3011\u7684shp\u56fe\u5c42\uff01", ydsphlpdConfig.getZipShpLayerName()));
            }
            String string = shpLayerName = FileUtil.mainName((File)((File)matchedFiles.get(0)).getAbsoluteFile());
            return string;
        }
        finally {
            FileUtils.deleteQuietly((File)tempDirFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TbYdsphlpdTask saveTask(YdsphlpdConfigDTO ydsphlpdConfig, String taskId, String taskName, LocalDateTime localDateTime, FileDTO uploadDirFileDTO, MultipartFile txt, FileDataDTO txtDataDTO, MultipartFile shp, String shpLayerName) throws Exception {
        try (IFileStorage fileStorage = this.fileStorageService.openFileStorage(ydsphlpdConfig.getUplaodDsKey());){
            TbYdsphlpdTask task = new TbYdsphlpdTask();
            task.setId(taskId);
            task.setUserId(this.getUserId());
            task.setName(taskName);
            task.setCreateTime(Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant()));
            task.setStatus(0);
            TbYdsphlpdTaskData taskData = new TbYdsphlpdTaskData();
            taskData.setId(taskId);
            taskData.setDsKey(ydsphlpdConfig.getUplaodDsKey());
            String taskPath = uploadDirFileDTO.getRelativePath();
            if (!taskPath.endsWith(fileStorage.getSeparator())) {
                taskPath = taskPath + fileStorage.getSeparator();
            }
            taskData.setTxtPath(taskPath + txt.getOriginalFilename());
            taskData.setShpPath(taskPath + shp.getOriginalFilename());
            taskData.setShpLayerName(shpLayerName);
            taskData.setXmin(txtDataDTO.getXmin());
            taskData.setXmax(txtDataDTO.getXmax());
            taskData.setYmin(txtDataDTO.getYmin());
            taskData.setYmax(txtDataDTO.getYmax());
            ArrayList<SpatialBlock> lstBlocks = new ArrayList<SpatialBlock>();
            int i = 1;
            for (XmBlockDTO xmBlockDTO : txtDataDTO.getXmxx().getBlocks()) {
                SpatialBlock block = new SpatialBlock();
                block.setDK_ID("\u5730\u5757" + i);
                block.setWKT(xmBlockDTO.getWkt());
                block.setWKID(String.valueOf(xmBlockDTO.getWkid()));
                lstBlocks.add(block);
                ++i;
            }
            double totalArea = this.caculateArea(lstBlocks);
            taskData.setBlocks(JSON.toJSONString(lstBlocks));
            task.setDkzmj(totalArea);
            this.saveOrUpdate(task);
            this.tbYdsphlpdTaskDataService.saveOrUpdate(taskData);
            TbYdsphlpdTask tbYdsphlpdTask = task;
            return tbYdsphlpdTask;
        }
    }

    private String getTempPath() {
        String curProjectPath = System.getProperty("user.dir");
        String tempDirPath = curProjectPath + File.separator + UUID.randomUUID().toString();
        File tempDirFile = new File(tempDirPath);
        tempDirFile.mkdir();
        return tempDirPath;
    }

    private String getUserId() throws Exception {
        String userId = this.tokenService.queryCurrentSysUserId();
        return userId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUploadPath(YdsphlpdConfigDTO ydsphlpdConfig) throws Exception {
        try (IFileStorage fileStorage = this.fileStorageService.openFileStorage(ydsphlpdConfig.getUplaodDsKey());){
            DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(ydsphlpdConfig.getUplaodDsKey());
            String uploadPath = dataSourceDTO.getUrl();
            if (!StringUtils.isEmpty((CharSequence)ydsphlpdConfig.getUploadRelativePath())) {
                String relativePath = ydsphlpdConfig.getUploadRelativePath().trim().replace("/", fileStorage.getSeparator()).replace("\\", fileStorage.getSeparator());
                if (StringUtils.isEmpty((CharSequence)relativePath) || fileStorage.getSeparator().equalsIgnoreCase(relativePath)) {
                    String string = uploadPath;
                    return string;
                }
                uploadPath = relativePath.startsWith(fileStorage.getSeparator()) ? uploadPath + relativePath : uploadPath + fileStorage.getSeparator() + relativePath;
                if (fileStorage instanceof IObjectStorage && !uploadPath.endsWith(fileStorage.getSeparator())) {
                    uploadPath = uploadPath + fileStorage.getSeparator();
                }
            }
            String string = uploadPath;
            return string;
        }
    }

    private void queryUserName(List<TbYdsphlpdTask> lstTasks) throws Exception {
        String token = MyRequestUtil.queryAccessTokenInHeader();
        List lstUserIds = lstTasks.stream().map(p -> p.getUserId()).distinct().collect(Collectors.toList());
        HashMap<String, SysUserDTO> mapUsers = new HashMap<String, SysUserDTO>();
        for (String userId : lstUserIds) {
            SysUserDTO sysUserDTO;
            if (StringUtils.isEmpty((CharSequence)userId) || (sysUserDTO = this.tokenService.querySysUserByUserId(token, userId)) == null) continue;
            mapUsers.put(userId, sysUserDTO);
        }
        for (TbYdsphlpdTask task : lstTasks) {
            if (StringUtils.isEmpty((CharSequence)task.getUserId()) || !mapUsers.containsKey(task.getUserId())) continue;
            task.setUserName(((SysUserDTO)mapUsers.get(task.getUserId())).getUsername());
        }
    }

    private void updateTaskStatus(List<TbYdsphlpdTask> lstTasks) {
        if (lstTasks == null || lstTasks.size() == 0) {
            return;
        }
        List runningTasks = lstTasks.stream().filter(p -> p.getStatus() == -1).collect(Collectors.toList());
        if (runningTasks == null || runningTasks.size() == 0) {
            return;
        }
        List uniqueTaskIds = runningTasks.stream().map(p -> p.getUniqueTaskId()).collect(Collectors.toList());
        List tbAnalysisTasks = this.geoserver3TaskService.findTaskByIds(uniqueTaskIds);
        Map<String, TbAnalysisTask> tbAnalysisTaskMap = tbAnalysisTasks.stream().collect(Collectors.toMap(TbAnalysisTask::getId, p -> p));
        for (TbYdsphlpdTask task : runningTasks) {
            if (!tbAnalysisTaskMap.containsKey(task.getUniqueTaskId())) continue;
            TbAnalysisTask tbAnalysisTask = tbAnalysisTaskMap.get(task.getUniqueTaskId());
            if (tbAnalysisTask.getStatus() == 0 || tbAnalysisTask.getStatus() == -1) {
                task.setStatus(-1);
            }
            task.setStatus(tbAnalysisTask.getStatus());
            task.setAnalysisTime(tbAnalysisTask.getStartTime());
            task.setCost(tbAnalysisTask.getCost());
            task.setMsg(tbAnalysisTask.getMsg());
            if (tbAnalysisTask.getStatus() != 200) continue;
            JSONObject result = this.geoserver3TaskService.findResult(tbAnalysisTask.getId());
            double yzzmj = result.getDouble("YZZMJ");
            double yzbl = yzzmj / task.getDkzmj();
            task.setYzzmj(yzzmj);
            task.setYzbl(yzbl);
        }
        this.updateBatchById(runningTasks);
    }

    private double caculateArea(List<SpatialBlock> lstBlocks) {
        Map<String, SpatialBlock> mapBlocks = lstBlocks.stream().collect(Collectors.toMap(SpatialBlock::getDK_ID, p -> p));
        String url = String.format("%s/rest/tools/projectArea", this.geoserver3ConfigService.getUrl());
        HashMap<String, Object> requestParams = new HashMap<String, Object>();
        requestParams.put("Blocks", lstBlocks);
        requestParams.put("applicationGUID", this.geoserver3ConfigService.getApplicationGuid());
        String requestParamsStr = JSONObject.toJSONString(requestParams);
        HttpRequest post = HttpUtil.createPost((String)url).body(requestParamsStr);
        HttpResponse execute = post.execute();
        if (execute.getStatus() != 200) {
            throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\u8c03\u7528\u5931\u8d25\uff1a" + execute.body());
        }
        JSONObject responseObj = JSON.parseObject((String)execute.body());
        if (responseObj.getIntValue("StatusCode") != 200) {
            throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + responseObj.getString("Message"));
        }
        JSONArray resArray = responseObj.getJSONArray("Results");
        BigDecimal decimal = new BigDecimal(0.0);
        double totalArea = 0.0;
        for (JSONObject object : resArray.toJavaList(JSONObject.class)) {
            String dkid = object.getString("DK_ID");
            SpatialBlock block = mapBlocks.get(dkid);
            BigDecimal dkMj = object.getBigDecimal("DK_MJ");
            decimal = decimal.add(dkMj).setScale(4, 1);
            block.setDK_MJ(Double.valueOf(decimal.doubleValue()));
            totalArea += block.getDK_MJ().doubleValue();
        }
        return totalArea;
    }

    private YdsphlpdTaskDetailDTO queryByGeoserver(TbYdsphlpdTask task, TbYdsphlpdTaskData taskData) {
        YdsphlpdTaskDetailDTO taskDetailDTO = new YdsphlpdTaskDetailDTO();
        BeanUtils.copyProperties((Object)task, (Object)taskDetailDTO);
        taskDetailDTO.setXmin(taskData.getXmin());
        taskDetailDTO.setXmax(taskData.getXmax());
        taskDetailDTO.setYmin(taskData.getYmin());
        taskDetailDTO.setYmax(taskData.getYmax());
        HashMap<String, Double> mapDKYzmj = new HashMap<String, Double>();
        JSONObject result = this.geoserver3TaskService.findResult(task.getUniqueTaskId());
        JSONArray jsonArray = result.getJSONArray("Results");
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject resultObj = jsonArray.getJSONObject(i);
            String dkid = resultObj.getString("DK_ID");
            double yzmj = resultObj.getDouble("YZMJ");
            if (mapDKYzmj.containsKey(dkid)) {
                mapDKYzmj.put(dkid, (Double)mapDKYzmj.get(dkid) + yzmj);
                continue;
            }
            mapDKYzmj.put(dkid, yzmj);
        }
        ArrayList<YdsphlpdTaskDetailDTO.YdsphlpdTaskDkDetail> lstDKDeitail = new ArrayList<YdsphlpdTaskDetailDTO.YdsphlpdTaskDkDetail>();
        List lstBlocks = JSON.parseArray((String)taskData.getBlocks(), SpatialBlock.class);
        YdsphlpdTaskDetailDTO.YdsphlpdTaskDkDetail dkDetail = null;
        for (SpatialBlock block : lstBlocks) {
            dkDetail = new YdsphlpdTaskDetailDTO.YdsphlpdTaskDkDetail();
            dkDetail.setDkid(block.getDK_ID());
            dkDetail.setDkmj(block.getDK_MJ());
            dkDetail.setWkt(block.getWKT());
            dkDetail.setWkid(Integer.parseInt(block.getWKID()));
            if (mapDKYzmj.containsKey(block.getDK_ID())) {
                dkDetail.setYzmj((Double)mapDKYzmj.get(block.getDK_ID()));
            }
            lstDKDeitail.add(dkDetail);
        }
        taskDetailDTO.setListDK(lstDKDeitail);
        return taskDetailDTO;
    }

    private void startTask(YdsphlpdConfigDTO ydsphlpdConfig, TbYdsphlpdTask task, TbYdsphlpdTaskData taskData, String token) throws Exception {
        task.setAnalysisTime(new Date());
        task.setCost(0.0);
        task.setYzzmj(0.0);
        task.setYzbl(0.0);
        try {
            List lstBlocks = JSON.parseArray((String)taskData.getBlocks(), SpatialBlock.class);
            HashMap<String, Object> yzfxParams = new HashMap<String, Object>();
            yzfxParams.put("async", true);
            yzfxParams.put("SFFHTX", false);
            yzfxParams.put("SFFHTB", false);
            yzfxParams.put("Blocks", lstBlocks);
            String datasourceUrl = null;
            datasourceUrl = StringUtils.isEmpty((CharSequence)token) ? String.format("shapefile:%s/datasource/filestorage/download?dsKey=%s&filePath=%s/%s", ydsphlpdConfig.getDownloadUrlPrefix(), ydsphlpdConfig.getUplaodDsKey(), taskData.getShpPath(), taskData.getShpLayerName()) : String.format("shapefile:%s/datasource/filestorage/download?token=%s&dsKey=%s&filePath=%s/%s", ydsphlpdConfig.getDownloadUrlPrefix(), token, ydsphlpdConfig.getUplaodDsKey(), taskData.getShpPath(), taskData.getShpLayerName());
            yzfxParams.put("datasourceUrl", datasourceUrl);
            JSONObject yzfxResponse = this.yzfxService.analysis(yzfxParams, "custom-datasource");
            String uniqueTaskId = yzfxResponse.getString("UniqueTaskID");
            task.setUniqueTaskId(uniqueTaskId);
            if (yzfxResponse.getInteger("StatusCode").equals(500)) {
                task.setStatus(500);
                task.setMsg(yzfxResponse.getString("Message"));
            } else {
                task.setStatus(-1);
                task.setMsg("running");
            }
        }
        catch (Throwable e) {
            StringBuilder msgBuilder = new StringBuilder();
            msgBuilder.append(e.getMessage());
            for (StackTraceElement traceElement : e.getStackTrace()) {
                msgBuilder.append(traceElement.toString() + "\r\n");
            }
            task.setStatus(500);
            task.setMsg(msgBuilder.toString());
        }
    }
}

