-- ----------------------------
--2024年9月20日，oyyh，辅助选址业务库表初始化
-- ----------------------------

--1.创建辅助选址模型表
CREATE TABLE "tb_smart_fzxz_model" (
  "f_id" varchar(40) NOT NULL,
  "f_pid" varchar(40),
  "f_type" int2,
  "f_service_id" varchar(40),
  "f_name" varchar(200),
  "f_main_feature" text,
  "f_site_require" text,
  "f_ydlx" text,
  "f_ydmj_min" float8,
  "f_ydmj_max" float8,
  "f_ydmj_unit" varchar(6),
  "f_site_layer_name" varchar(100),
  "f_site_layer_alias" varchar(200),
  "f_site_layer_year" varchar(20),
  "f_resource_catalog_node_id" varchar(40),
  "f_order" int4,
  PRIMARY KEY ("f_id")
);
CREATE INDEX "i_tb_smart_fzxz_model" ON "tb_smart_fzxz_model" (
  "f_pid",
  "f_type",
  "f_name"
);
COMMENT ON COLUMN "tb_smart_fzxz_model"."f_pid" IS '父id';
COMMENT ON COLUMN "tb_smart_fzxz_model"."f_type" IS '类型，1：分组节点，2：模型节点';
COMMENT ON COLUMN "tb_smart_fzxz_model"."f_service_id" IS '绑定的辅助选址服务id';
COMMENT ON COLUMN "tb_smart_fzxz_model"."f_name" IS '模型名称';
COMMENT ON COLUMN "tb_smart_fzxz_model"."f_main_feature" IS '模型主要特色';
COMMENT ON COLUMN "tb_smart_fzxz_model"."f_site_require" IS '选址重点要求';
COMMENT ON COLUMN "tb_smart_fzxz_model"."f_ydlx" IS '用地类型，多个用地类型用英文逗号分隔';
COMMENT ON COLUMN "tb_smart_fzxz_model"."f_ydmj_min" IS '用地面积最小值';
COMMENT ON COLUMN "tb_smart_fzxz_model"."f_ydmj_max" IS '用地面积最大值';
COMMENT ON COLUMN "tb_smart_fzxz_model"."f_ydmj_unit" IS '用地面积单位，1：平方米，2：亩，3：公顷';
COMMENT ON COLUMN "tb_smart_fzxz_model"."f_site_layer_name" IS '选址图层名称';
COMMENT ON COLUMN "tb_smart_fzxz_model"."f_site_layer_alias" IS '选址图层别名';
COMMENT ON COLUMN "tb_smart_fzxz_model"."f_site_layer_year" IS '选址图层数据年份';
COMMENT ON COLUMN "tb_smart_fzxz_model"."f_resource_catalog_node_id" IS '选址图层绑定的资源目录节点';
COMMENT ON COLUMN "tb_smart_fzxz_model"."f_order" IS '排序';


--2.创建辅助选址限制图层表
CREATE TABLE "tb_smart_fzxz_model_limitlayer" (
  "f_id" varchar(40) NOT NULL,
  "f_model_id" varchar(40),
  "f_layer_id" varchar(40),
  "f_layer_name" varchar(100),
  "f_layer_alias" varchar(200),
  "f_limit_type" varchar(2),
  "f_resource_catalog_node_id" varchar(40),
  "f_default_sel" int2,
  "f_order" int4,
  PRIMARY KEY ("f_id")
);
CREATE INDEX "i_tb_smart_fzxz_model_limitlayer" ON "tb_smart_fzxz_model_limitlayer" (
  "f_model_id"
);
COMMENT ON COLUMN "tb_smart_fzxz_model_limitlayer"."f_model_id" IS '模型ID';
COMMENT ON COLUMN "tb_smart_fzxz_model_limitlayer"."f_layer_id" IS '图层id（引擎里的限制图层ID）';
COMMENT ON COLUMN "tb_smart_fzxz_model_limitlayer"."f_layer_name" IS '图层名称';
COMMENT ON COLUMN "tb_smart_fzxz_model_limitlayer"."f_layer_alias" IS '图层别名';
COMMENT ON COLUMN "tb_smart_fzxz_model_limitlayer"."f_limit_type" IS '限制类型，1：禁止压占，2：必须落入';
COMMENT ON COLUMN "tb_smart_fzxz_model_limitlayer"."f_resource_catalog_node_id" IS '限制图层绑定的资源目录节点';
COMMENT ON COLUMN "tb_smart_fzxz_model_limitlayer"."f_default_sel" IS '默认选址，0：不选择，1：选择';
COMMENT ON COLUMN "tb_smart_fzxz_model_limitlayer"."f_order" IS '排序';


--3.创建辅助选址因子表
CREATE TABLE "tb_smart_fzxz_model_factor" (
  "f_id" varchar(40) NOT NULL,
  "f_model_id" varchar(40),
  "f_factor_id" varchar(40),
  "f_factor_name" varchar(200),
  "f_factor_type" varchar(2),
  "f_factor_cacu_symbol" varchar(10),
  "f_factor_cacu_value" text,
  "f_factor_cacu_unit" varchar(2),
  "f_resource_catalog_node_id" varchar(40),
  "f_default_sel" int2,
  "f_order" int4,
  PRIMARY KEY ("f_id")
);
CREATE INDEX "i_tb_smart_fzxz_model_factor" ON "tb_smart_fzxz_model_factor" (
  "f_model_id"
);
COMMENT ON COLUMN "tb_smart_fzxz_model_factor"."f_model_id" IS '模型ID';
COMMENT ON COLUMN "tb_smart_fzxz_model_factor"."f_factor_id" IS '因子ID（引擎里的因子ID）';
COMMENT ON COLUMN "tb_smart_fzxz_model_factor"."f_factor_name" IS '因子名称';
COMMENT ON COLUMN "tb_smart_fzxz_model_factor"."f_factor_type" IS '因子类型，1：临近性因子，2：避开性因子，3：限制性因子';
COMMENT ON COLUMN "tb_smart_fzxz_model_factor"."f_factor_cacu_symbol" IS '因子计算符，1：= ，2：!=，3：>，4：<=';
COMMENT ON COLUMN "tb_smart_fzxz_model_factor"."f_factor_cacu_value" IS '因子计算值，多个值用英文逗号分隔';
COMMENT ON COLUMN "tb_smart_fzxz_model_factor"."f_factor_cacu_unit" IS '因子计算值单位，1：米，2：千米';
COMMENT ON COLUMN "tb_smart_fzxz_model_factor"."f_resource_catalog_node_id" IS '因子图层绑定的资源目录节点';
COMMENT ON COLUMN "tb_smart_fzxz_model_factor"."f_default_sel" IS '默认选址，0：不选择，1：选择';
COMMENT ON COLUMN "tb_smart_fzxz_model_factor"."f_order" IS '排序';


--4.创建辅助选址任务表
CREATE TABLE "tb_smart_fzxz_task" (
  "f_id" varchar(40) NOT NULL,
  "f_user_id" varchar(40),
  "f_model_pid" varchar(40),
  "f_model_id" varchar(40),
  "f_name" varchar(255),
  "f_create_time" timestamp,
  "f_status" int2,
  "f_cost" float8,
  "f_message" text,
  PRIMARY KEY ("f_id")
);
CREATE INDEX "i_tb_smart_fzxz_task" ON "tb_smart_fzxz_task" (
  "f_user_id",
  "f_model_pid",
  "f_model_id",
  "f_name",
  "f_status"
);
COMMENT ON COLUMN "tb_smart_fzxz_task"."f_user_id" IS '用户id';
COMMENT ON COLUMN "tb_smart_fzxz_task"."f_model_pid" IS '模型pid';
COMMENT ON COLUMN "tb_smart_fzxz_task"."f_model_id" IS '模型id';
COMMENT ON COLUMN "tb_smart_fzxz_task"."f_name" IS '任务名称';
COMMENT ON COLUMN "tb_smart_fzxz_task"."f_create_time" IS '创建时间';
COMMENT ON COLUMN "tb_smart_fzxz_task"."f_status" IS '任务状态，-1：存在失败  0：进行  1：完成';
COMMENT ON COLUMN "tb_smart_fzxz_task"."f_cost" IS '耗时：秒';
COMMENT ON COLUMN "tb_smart_fzxz_task"."f_message" IS '任务信息';