/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.znts.service.impl;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONArray;
import com.geoway.ns.base.enums.ShapeType;
import com.geoway.ns.base.util.GeometryUtils;
import com.geoway.ns.smart.znts.dto.AppCloudQueryParam;
import com.geoway.ns.smart.znts.dto.CloudQueryParam;
import com.geoway.ns.smart.znts.dto.WebCloudQueryParam;
import com.geoway.ns.smart.znts.entity.CloudQuery;
import com.geoway.ns.smart.znts.entity.CloudQueryItem;
import com.geoway.ns.smart.znts.entity.CloudQueryNode;
import com.geoway.ns.smart.znts.entity.CloudQueryPlanItem;
import com.geoway.ns.smart.znts.entity.CloudQueryRecord;
import com.geoway.ns.smart.znts.enums.CloudQueryState;
import com.geoway.ns.smart.znts.service.CloudQueryItemService;
import com.geoway.ns.smart.znts.service.CloudQueryNodeService;
import com.geoway.ns.smart.znts.service.CloudQueryPlanItemService;
import com.geoway.ns.smart.znts.service.CloudQueryRecordService;
import com.geoway.ns.smart.znts.service.CloudQueryService;
import com.geoway.ns.smart.znts.service.ICloudQueryConfigService;
import com.geoway.ns.smart.znts.service.NationalCloudQueryService;
import com.geoway.ns.smart.znts.util.CloudQueryHttpUtil;
import com.geoway.ns.sys.service.ITokenService;
import com.geoway.ns.sys.support.ServletUtils;
import com.google.gson.Gson;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.TransformException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class NationalCloudQueryServiceImpl
implements NationalCloudQueryService {
    private static final Logger log = LogManager.getLogger(NationalCloudQueryServiceImpl.class);
    @Resource
    private CloudQueryHttpUtil cloudQueryHttpUtil;
    @Resource
    private ITokenService tokenService;
    @Resource
    private ICloudQueryConfigService cloudQueryConfigService;
    @Resource
    private CloudQueryItemService cloudQueryItemService;
    @Resource
    private CloudQueryRecordService cloudQueryRecordService;
    @Resource
    private CloudQueryService cloudQueryService;
    @Resource
    private CloudQueryNodeService cloudQueryNodeService;
    @Resource
    private CloudQueryPlanItemService cloudQueryPlanItemService;
    @Value(value="${cloud.query.defaultUserid:''}")
    private String defaultUserid;

    @Override
    public String sendCloudQuery(WebCloudQueryParam param) throws Exception {
        String userId = this.tokenService.queryCurrentSysUserId();
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)userId), (String)"\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u767b\u5f55\u4fe1\u606f\uff01");
        List<CloudQueryItem> cloudQueryItems = this.cloudQueryItemService.getUserCloudQueryItems(userId, param.getWkt(), param.getGroup(), param.getLayers(), null);
        Map map = cloudQueryItems.stream().map(cloudQueryItem -> {
            String time;
            String tag = cloudQueryItem.getTag() == null ? "" : cloudQueryItem.getTag();
            String name = cloudQueryItem.getName() == null ? "" : cloudQueryItem.getName();
            String string = time = cloudQueryItem.getTime() == null ? "" : DateFormatUtils.format((Date)cloudQueryItem.getTime(), (String)"yyyyMMdd");
            if (StringUtils.isNotBlank((CharSequence)time)) {
                name = name + "_" + time;
            }
            return MapUtil.builder((Object)"tag", (Object)tag).put((Object)"name", (Object)name).build();
        }).collect(Collectors.groupingBy(item -> (String)item.get("tag"), Collectors.mapping(item -> (String)item.get("name"), Collectors.toList())));
        String requestId = UUID.randomUUID().toString();
        ArrayList queryIds = new ArrayList();
        map.forEach((tag, names) -> {
            String analyzeType = StringUtils.join((Iterable)names, (String)"\u3001");
            try {
                CloudQuery cloudQuery = this.sendCloudQuery(param.getWkt(), param.getWidth(), param.getHeight(), (String)tag, userId, analyzeType, requestId);
                queryIds.add(cloudQuery.getId());
            }
            catch (Exception exception) {
                log.error("[" + tag + "]\u4e91\u67e5\u8be2\u5931\u8d25\uff01", (Throwable)exception);
            }
        });
        String queryIdString = StringUtils.join(queryIds, (String)",");
        Map params = MapUtil.builder((Object)"requestId", (Object)requestId).put((Object)"queryIds", (Object)queryIdString).put((Object)"wkt", (Object)param.getWkt()).put((Object)"width", (Object)param.getWidth()).put((Object)"height", (Object)param.getHeight()).put((Object)"group", (Object)param.getGroup()).build();
        CloudQueryRecord cloudQueryRecord = CloudQueryRecord.builder().requestId(requestId).userId(userId).cloudId(queryIdString).param(com.alibaba.fastjson.JSONObject.toJSONString((Object)params)).status(0).type(1).updateTime(new Date()).build();
        this.cloudQueryRecordService.save(cloudQueryRecord);
        return requestId;
    }

    @Override
    public com.alibaba.fastjson.JSONObject sendAppCloudQuery(AppCloudQueryParam appCloudQueryParam) throws Exception {
        CloudQueryParam queryParam = (CloudQueryParam)new Gson().fromJson(appCloudQueryParam.getParam(), CloudQueryParam.class);
        String userId = this.tokenService.queryCurrentSysUserId();
        CloudQuery cloudQuery = this.sendCloudQuery(queryParam.getRange(), queryParam.getWidth(), queryParam.getHeight(), appCloudQueryParam.getCloudTag(), userId, queryParam.getAnalyzetype(), appCloudQueryParam.getRequestId());
        com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject();
        jsonObject.put("xzqdm", (Object)cloudQuery.getXzqdm());
        jsonObject.put("name", (Object)cloudQuery.getName());
        jsonObject.put("id", (Object)cloudQuery.getId());
        jsonObject.put("requestid", (Object)cloudQuery.getRequestId());
        return jsonObject;
    }

    @Override
    public String getResultDetailUrl(String requestId, String type) throws Exception {
        String userId = this.tokenService.queryCurrentSysUserId();
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)userId), (String)"\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u767b\u5f55\u4fe1\u606f\uff01");
        List<CloudQueryItem> cloudQueryItems = this.cloudQueryItemService.getUserCloudQueryItems(userId, null, null, null, null);
        if (StringUtils.equals((CharSequence)type, (CharSequence)"1")) {
            cloudQueryItems.forEach(cloudQueryItem -> {
                if (!StringUtils.equals((CharSequence)cloudQueryItem.getTag(), (CharSequence)"\u57fa\u7840\u67e5\u8be2")) {
                    cloudQueryItem.setTag("\u9ad8\u7ea7\u67e5\u8be2");
                }
            });
        } else {
            cloudQueryItems.forEach(cloudQueryItem -> cloudQueryItem.setTag("\u4e91\u67e5\u8be2"));
        }
        List<CloudQuery> cloudQueries = this.cloudQueryService.listByRequestId(requestId);
        if (CollectionUtils.isEmpty(cloudQueries)) {
            throw new RuntimeException("\u4e91\u67e5\u8be2\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01");
        }
        com.alibaba.fastjson.JSONObject detail = new com.alibaba.fastjson.JSONObject();
        for (CloudQuery cloudQuery : cloudQueries) {
            com.alibaba.fastjson.JSONObject jsonObject = this.cloudQueryHttpUtil.getCloudQueryResultDetail(cloudQuery.getId());
            try {
                detail.putAll((Map)jsonObject);
            }
            catch (Exception exception) {
                log.error("\u89e3\u6790\u4e91\u67e5\u8be2\u7ed3\u679c\u8be6\u60c5\u5931\u8d25\uff01", (Throwable)exception);
            }
        }
        com.alibaba.fastjson.JSONObject data = new com.alibaba.fastjson.JSONObject();
        data.put("area", (Object)cloudQueries.get(0).getArea());
        data.put("name", (Object)cloudQueries.get(0).getName());
        data.put("queryTime", (Object)cloudQueries.get(0).getQuerytime());
        detail.put("data", (Object)data);
        return this.cloudQueryHttpUtil.getCloudQueryResultUrl(requestId, com.alibaba.fastjson.JSONObject.toJSONString(cloudQueryItems), detail.toJSONString());
    }

    @Override
    public JSONObject getResultDetail(String requestId) throws Exception {
        String userId = this.tokenService.queryCurrentSysUserId();
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)userId), (String)"\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u767b\u5f55\u4fe1\u606f\uff01");
        List<CloudQuery> cloudQueries = this.cloudQueryService.listByRequestId(requestId);
        if (CollectionUtils.isEmpty(cloudQueries)) {
            throw new RuntimeException("\u4e91\u67e5\u8be2\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01");
        }
        com.alibaba.fastjson.JSONObject detail = new com.alibaba.fastjson.JSONObject();
        try {
            JSONObject jsonObject = new JSONObject();
            List<CloudQueryRecord> cloudQueryRecords = null;
            for (CloudQuery cloudQuery : cloudQueries) {
                CloudQueryRecord gjCloudQueryRecord;
                try {
                    com.alibaba.fastjson.JSONObject jsonObjectResult = this.cloudQueryHttpUtil.getCloudQueryResultDetail(cloudQuery.getId());
                    if (cloudQuery.getState() == 0 || cloudQuery.getState() == null) {
                        if (cloudQueryRecords == null) {
                            cloudQueryRecords = this.cloudQueryRecordService.selectGJCloudQueryByRequestId(requestId);
                        }
                        cloudQuery.setState(1);
                        cloudQuery.setResult(jsonObjectResult.toJSONString());
                        this.cloudQueryService.saveOrUpdate(cloudQuery);
                        if (cloudQueryRecords != null && (gjCloudQueryRecord = (CloudQueryRecord)cloudQueryRecords.stream().filter(s -> cloudQuery.getId().contains(s.getCloudId())).findFirst().orElse(null)) != null) {
                            gjCloudQueryRecord.setStatus(1);
                            gjCloudQueryRecord.setResult(jsonObjectResult.toJSONString());
                            this.cloudQueryRecordService.saveOrUpdate(gjCloudQueryRecord);
                        }
                    }
                    jsonObject.put((Object)cloudQuery.getTag(), (Object)jsonObjectResult);
                }
                catch (Exception ex) {
                    cloudQuery.setState(3);
                    this.cloudQueryService.saveOrUpdate(cloudQuery);
                    if (cloudQueryRecords == null) {
                        cloudQueryRecords = this.cloudQueryRecordService.selectGJCloudQueryByRequestId(requestId);
                    }
                    if (cloudQueryRecords == null || (gjCloudQueryRecord = (CloudQueryRecord)cloudQueryRecords.stream().filter(s -> cloudQuery.getId().contains(s.getCloudId())).findFirst().orElse(null)) == null) continue;
                    gjCloudQueryRecord.setStatus(3);
                    this.cloudQueryRecordService.saveOrUpdate(gjCloudQueryRecord);
                }
            }
            return jsonObject;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public List<CloudQueryNode> getCloudQueryItem(Integer displaySet) throws Exception {
        String userId = this.tokenService.queryCurrentSysUserId();
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)userId), (String)"\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u767b\u5f55\u4fe1\u606f\uff01");
        List<CloudQueryItem> cloudQueryItems = this.cloudQueryItemService.getUserCloudQueryItems(userId, null, null, null, displaySet == null ? 8 : displaySet);
        if (CollectionUtils.isEmpty(cloudQueryItems)) {
            throw new RuntimeException("\u4e91\u67e5\u8be2\u9879\u4e0d\u5b58\u5728\uff01");
        }
        Map<String, List<CloudQueryItem>> groups = cloudQueryItems.stream().collect(Collectors.groupingBy(CloudQueryItem::getNodeid));
        ArrayList<CloudQueryNode> results = new ArrayList<CloudQueryNode>();
        List nodes = this.cloudQueryNodeService.listByIds(new ArrayList<String>(groups.keySet()));
        groups.forEach((nodeId, items) -> nodes.stream().filter(node -> node.getId().equals(nodeId)).findFirst().ifPresent(node -> {
            node.setItems((List<CloudQueryItem>)items);
            results.add((CloudQueryNode)node);
        }));
        return results;
    }

    @Override
    public LinkedHashMap<String, List<CloudQueryItem>> getCloudMeta(Integer displaySet) throws Exception {
        String userId = this.tokenService.queryCurrentSysUserId();
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)userId), (String)"\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u767b\u5f55\u4fe1\u606f\uff01");
        return this.getCloudMeta(userId, displaySet);
    }

    @Override
    public LinkedHashMap<String, List<CloudQueryItem>> getCloudMeta(String userId, Integer displaySet) throws Exception {
        List<CloudQueryItem> cloudQueryItems = this.cloudQueryItemService.getUserCloudQueryItems(userId, null, null, null, ObjectUtils.isEmpty((Object)displaySet) ? 8 : displaySet);
        if (CollectionUtils.isEmpty(cloudQueryItems)) {
            return new LinkedHashMap<String, List<CloudQueryItem>>();
        }
        LinkedHashMap tableNameMap = cloudQueryItems.stream().collect(Collectors.groupingBy(CloudQueryItem::getTag, LinkedHashMap::new, Collectors.toList()));
        for (Map.Entry entry : tableNameMap.entrySet()) {
            entry.setValue(((List)entry.getValue()).stream().sorted(Comparator.comparing(CloudQueryItem::getName)).collect(Collectors.toList()));
        }
        return tableNameMap;
    }

    @Override
    public List<Map<String, Object>> getCloudList(String plandId) throws Exception {
        String userId = this.tokenService.queryCurrentSysUserId();
        String token = ServletUtils.getHeaderValues((String)"access_token");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)userId), (String)"\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u767b\u5f55\u4fe1\u606f\uff01");
        LinkedHashMap<String, List<CloudQueryItem>> cloudMeta = this.getCloudMeta(userId, null);
        List<Object> ids = new ArrayList();
        String string = plandId = StringUtils.isBlank((CharSequence)plandId) ? this.cloudQueryItemService.getPlanIdByToken() : plandId;
        if (StringUtils.isNotBlank((CharSequence)plandId)) {
            List<CloudQueryPlanItem> hideList = this.cloudQueryPlanItemService.queryByPlanId(plandId);
            ids = hideList.stream().map(m -> m.getItemId()).collect(Collectors.toList());
        }
        ArrayList metaConfig = new ArrayList();
        for (Map.Entry<String, List<CloudQueryItem>> entry : cloudMeta.entrySet()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            List<CloudQueryItem> values = null;
            if (!ids.isEmpty()) {
                List<Object> finalIds = ids;
                values = entry.getValue().stream().filter(f -> !finalIds.contains(f.getId())).collect(Collectors.toList());
            } else {
                values = entry.getValue();
            }
            if (values == null || values.isEmpty()) continue;
            map.put("groupType", entry.getKey());
            map.put("services", values);
            metaConfig.add(map);
        }
        return metaConfig.stream().sorted(Comparator.comparing(o -> o.get("groupType").toString())).collect(Collectors.toList());
    }

    private CloudQuery sendCloudQuery(String wkt, Integer width, Integer height, String tag, String userId, String analyzeType, String requestId) throws FactoryException, TransformException, ParseException {
        Map<String, Object> params = this.buildGeometryParams(wkt);
        MapUtil.builder(params).put((Object)"width", (Object)width).put((Object)"height", (Object)height).put((Object)"analyzetype", (Object)analyzeType).put((Object)"options", (Object)3).build();
        String paramJson = com.alibaba.fastjson.JSONObject.toJSONString(params);
        com.alibaba.fastjson.JSONObject responseData = this.cloudQueryHttpUtil.sendCloudQuery(userId, paramJson, requestId, null, tag);
        if (MapUtil.isEmpty((Map)responseData)) {
            throw new RuntimeException("\u4e91\u67e5\u8be2\u5931\u8d25\uff01");
        }
        CloudQuery cloudQuery = CloudQuery.builder().requestId(requestId).id(MapUtil.getStr((Map)responseData, (Object)"id")).wkt(wkt).nodeId(this.cloudQueryConfigService.getNodeId()).isCollect(0).isDeleted(0).tag(tag).mark(0).param(paramJson).userId(userId).querytime(new Date()).type(1).area(MapUtil.getDouble((Map)responseData, (Object)"area")).lon(MapUtil.getDouble(params, (Object)"lon")).lat(MapUtil.getDouble(params, (Object)"lat")).weight(100).state(CloudQueryState.REQUESTED.code).build();
        this.cloudQueryService.save(cloudQuery);
        return cloudQuery;
    }

    private Map<String, Object> buildGeometryParams(String wkt) throws ParseException, FactoryException, TransformException {
        Double area;
        String range;
        Geometry geometry = GeometryUtils.wktToGeometry((String)wkt, (Integer)GeometryUtils.GEOMETRY_SRID);
        ShapeType shapeType = GeometryUtils.getShapeTypeByWkt((String)wkt);
        if (shapeType == ShapeType.POINT) {
            range = wkt;
            area = this.cloudQueryService.calculateArea(GeometryUtils.geometryToWkt((Geometry)geometry));
            if (area != null) {
                area = area / 666.7;
            }
        } else if (shapeType == ShapeType.LINE_STRING || shapeType == ShapeType.MULTI_LINE_STRING) {
            geometry = geometry.buffer(GeometryUtils.DEFAULT_BUFFER.doubleValue());
            range = GeometryUtils.geometryToWkt((Geometry)geometry);
            area = geometry.getArea() / 666.7;
        } else {
            range = wkt;
            Geometry newGeometry = GeometryUtils.transform((Geometry)geometry);
            area = newGeometry.getArea() / 666.7;
        }
        return MapUtil.builder((Object)"range", (Object)range).put((Object)"mj", (Object)area).put((Object)"lon", (Object)geometry.getCentroid().getX()).put((Object)"lat", (Object)geometry.getCentroid().getY()).build();
    }

    @Override
    @Transactional
    public Map<String, Integer> getRecordStateByRequestIds(List<String> listRequestIds) throws Exception {
        if (listRequestIds.isEmpty()) {
            return null;
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (final String requestId : listRequestIds) {
            List<CloudQuery> cloudQueries = this.cloudQueryService.listByRequestId(requestId);
            CloudQuery unFinshed = cloudQueries.stream().filter(s -> s.getState() == null || s.getState() == 0).findFirst().orElse(null);
            if (unFinshed != null) {
                JSONArray arr = this.cloudQueryHttpUtil.getRecordStateByRequestIds((List<String>)new ArrayList<String>(){
                    {
                        this.add(requestId);
                    }
                });
                for (int i = 0; i < arr.size(); ++i) {
                    com.alibaba.fastjson.JSONObject job = arr.getJSONObject(i);
                    String requestid = job.getString("requestId");
                    String id = job.getString("id");
                    int state = job.getIntValue("state");
                    if (map.containsKey(id)) {
                        Integer integer = (Integer)map.get(id);
                        if (integer < 0) {
                            map.put(id, -1);
                        } else if (state == 1 || state == 2) {
                            map.put(id, 1);
                        } else {
                            map.put(id, -1);
                        }
                    } else if (state == 1 || state == 2) {
                        map.put(id, 1);
                    } else {
                        map.put(id, -1);
                    }
                    CloudQuery cloudQuery = (CloudQuery)this.cloudQueryService.getById((Serializable)((Object)id));
                    cloudQuery.setReplyTime(new Date());
                    cloudQuery.setState(state);
                    this.cloudQueryService.saveOrUpdate(cloudQuery);
                    CloudQueryRecord cloudQueryRecord = (CloudQueryRecord)this.cloudQueryRecordService.getById((Serializable)((Object)id));
                    cloudQueryRecord.setStatus(state);
                    cloudQueryRecord.setUpdateTime(new Date());
                    this.cloudQueryRecordService.saveOrUpdate(cloudQueryRecord);
                }
                continue;
            }
            for (CloudQuery cloudQuery : cloudQueries) {
                if (map.containsKey(cloudQuery.getId())) {
                    Integer integer = (Integer)map.get(cloudQuery.getId());
                    if (integer < 0) {
                        map.put(cloudQuery.getId(), -1);
                        continue;
                    }
                    if (cloudQuery.getState() == 1 || cloudQuery.getState() == 2) {
                        map.put(cloudQuery.getId(), 1);
                        continue;
                    }
                    map.put(cloudQuery.getId(), -1);
                    continue;
                }
                if (cloudQuery.getState() == 1 || cloudQuery.getState() == 2) {
                    map.put(cloudQuery.getId(), 1);
                    continue;
                }
                map.put(cloudQuery.getId(), -1);
            }
        }
        return map;
    }
}

