/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.zntsnew.util;

import com.geoway.adf.dms.datasource.dao.DmDistrictDao;
import com.geoway.adf.dms.datasource.dto.district.DistrictItemDTO;
import com.geoway.adf.dms.datasource.entity.DmDistrict;
import com.geoway.adf.dms.datasource.service.DistrictService;
import com.geoway.ns.base.util.GeometryUtils;
import com.geoway.ns.geoserver3.dto.InverseGeocodingVO;
import com.geoway.ns.geoserver3.service.IGeoToolService;
import com.geoway.ns.smart.zntsnew.dto.CentroidInfo;
import com.vividsolutions.jts.geom.Geometry;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskGeoCentroidTools {
    @Autowired
    private DmDistrictDao dmDistrictDao;
    @Autowired
    private DistrictService districtService;
    @Autowired
    private IGeoToolService geoToolService;

    public CentroidInfo getInfo(List<String> wkts) throws Exception {
        CentroidInfo centroidInfo = new CentroidInfo();
        try {
            Geometry maxGeotry = null;
            for (String wkt : wkts) {
                Geometry geometry = GeometryUtils.wktToGeometry((String)wkt, (Integer)GeometryUtils.GEOMETRY_SRID);
                if (maxGeotry == null) {
                    maxGeotry = geometry;
                    continue;
                }
                maxGeotry.intersection(geometry);
            }
            centroidInfo.setLon(maxGeotry.getCentroid().getX());
            centroidInfo.setLat(maxGeotry.getCentroid().getY());
            String point = "point(" + centroidInfo.getLon() + " " + centroidInfo.getLat() + ")";
            List geocodingVOS = this.geoToolService.inverseGeoCoding(null, point);
            if (geocodingVOS.isEmpty()) {
                List list = this.dmDistrictDao.queryDefault();
                Long districtId = ((DmDistrict)list.get(0)).getId();
                List districtItemDTOS = this.districtService.queryDistrictItem(districtId, Short.valueOf((short)3), point);
                if (districtItemDTOS.size() > 0) {
                    centroidInfo.setXzqmc(((DistrictItemDTO)districtItemDTOS.get(0)).getName());
                }
            } else {
                InverseGeocodingVO vo = (InverseGeocodingVO)geocodingVOS.get(0);
                String address = vo.getDistrict() + vo.getTownship() + (vo.getName() == null ? "" : vo.getName());
                centroidInfo.setXzqmc(address);
            }
            centroidInfo.setPoint(point);
            centroidInfo.setWkt(maxGeotry.toText());
            centroidInfo.setArea(this.geoToolService.queryProjectArea(wkts));
        }
        catch (Throwable e) {
            throw new RuntimeException("\u4e2d\u5fc3\u70b9\u83b7\u53d6\u5931\u8d25\uff1a" + e.getMessage());
        }
        return centroidInfo;
    }
}

