-- ai智能分析相关内容

-- tb_agi_analysis_chat definition

-- Drop table

-- DROP TABLE tb_agi_analysis_chat;

CREATE TABLE tb_agi_analysis_chat (
	f_user_id varchar(128) NULL,
	f_workspace varchar(64) NULL,
	f_chat_slug varchar(64) NULL,
	f_create_time timestamp NULL,
	f_name text NULL,
	f_id varchar(64) NOT NULL,
	f_collect int2 NULL,
	f_type varchar(16) NULL,
	CONSTRAINT tb_agi_analysis_chat_pk PRIMARY KEY (f_id)
);
CREATE INDEX tb_agi_analysis_chat_f_user_id_idx ON tb_agi_analysis_chat USING btree (f_user_id);
COMMENT ON TABLE tb_agi_analysis_chat IS '智能分析对话表';

-- Column comments

COMMENT ON COLUMN tb_agi_analysis_chat.f_user_id IS '用户id';
COMMENT ON COLUMN tb_agi_analysis_chat.f_workspace IS '工作区关键字';
COMMENT ON COLUMN tb_agi_analysis_chat.f_chat_slug IS '对话窗口关键字';
COMMENT ON COLUMN tb_agi_analysis_chat.f_create_time IS '创建时间';
COMMENT ON COLUMN tb_agi_analysis_chat.f_name IS '对话窗名称';
COMMENT ON COLUMN tb_agi_analysis_chat.f_collect IS '收藏  1.是  0.否';
COMMENT ON COLUMN tb_agi_analysis_chat.f_type IS 'chat   、 znfx 、 znjs 、znwd';


-- tb_agi_analysis_history definition

-- Drop table

-- DROP TABLE tb_agi_analysis_history;

CREATE TABLE tb_agi_analysis_history (
	f_id varchar(64) NOT NULL,
	f_pid varchar(64) NULL,
	f_create_time timestamp NULL,
	f_type int2 NULL,
	f_content text NULL,
	f_key varchar(64) NULL,
	f_thinks text NULL,
	f_status int2 NULL,
	f_msg text NULL,
	f_error text NULL,
	f_cost int4 NULL,
	f_relation varchar(64) NULL,
	CONSTRAINT tb_agi_analysis_history_pk PRIMARY KEY (f_id)
);
CREATE INDEX tb_agi_analysis_history_f_pid_idx ON tb_agi_analysis_history USING btree (f_pid);
COMMENT ON TABLE tb_agi_analysis_history IS '智能分析历史表';

-- Column comments

COMMENT ON COLUMN tb_agi_analysis_history.f_pid IS '会话id';
COMMENT ON COLUMN tb_agi_analysis_history.f_create_time IS '创建时间';
COMMENT ON COLUMN tb_agi_analysis_history.f_type IS '1.用户   2. ai';
COMMENT ON COLUMN tb_agi_analysis_history.f_content IS '消息内容';
COMMENT ON COLUMN tb_agi_analysis_history.f_key IS '功能关键字';
COMMENT ON COLUMN tb_agi_analysis_history.f_thinks IS '思考内容';
COMMENT ON COLUMN tb_agi_analysis_history.f_status IS '状态 0.进行中  1.完成  -1.失败';
COMMENT ON COLUMN tb_agi_analysis_history.f_error IS '异常信息';
COMMENT ON COLUMN tb_agi_analysis_history.f_cost IS '耗时';
COMMENT ON COLUMN tb_agi_analysis_history.f_relation IS 'ai消息id';


-- tb_agi_analysis_result definition

-- Drop table

-- DROP TABLE tb_agi_analysis_result;

CREATE TABLE tb_agi_analysis_result (
	f_id varchar(64) NOT NULL,
	f_result text NULL,
	CONSTRAINT tb_agi_analysis_result_pk PRIMARY KEY (f_id)
);
COMMENT ON TABLE tb_agi_analysis_result IS '消息结果';


INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
VALUES(nextval('tbsys_sysparam_f_id_seq'), '第三方AI应用', 'ai-tools', NULL, '', NULL, '', 1);

INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
select nextval('tbsys_sysparam_f_id_seq'), NULL, 'anythingLLM-api', decode('687474703A2F2F3137322E31362E36372E3133333A333030312F6170692F7631','hex'), '', f_id, '', 0  from tbsys_sysparam where f_key = 'ai-tools';
INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
select nextval('tbsys_sysparam_f_id_seq'), NULL, 'anythingLLM-authorization', decode('4A5A42504143342D305A4B34454A362D5052484B464D4A2D30385833325A5A','hex'), '', f_id, '', 0  from tbsys_sysparam where f_key = 'ai-tools';
INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
select nextval('tbsys_sysparam_f_id_seq'), NULL, 'deepseek-api', decode('68747470733A2F2F6170692E646565707365656B2E636F6D','hex'), '', f_id, '', 0  from tbsys_sysparam where f_key = 'ai-tools';
INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
select nextval('tbsys_sysparam_f_id_seq'), NULL, 'deepseek-authorization', decode('736B2D3132363539376438306638613437303461643239383939653930616638643930','hex'), '', f_id, '', 0  from tbsys_sysparam where f_key = 'ai-tools';
INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
select nextval('tbsys_sysparam_f_id_seq'), NULL, 'metaso-api', decode('68747470733A2F2F6D657461736F2E636E','hex'), '', f_id, '', 0   from tbsys_sysparam where f_key = 'ai-tools';
INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
select nextval('tbsys_sysparam_f_id_seq'), NULL, 'metaso-authorization', decode('6D6B2D3641334132324138313644424146424630313237414135453031304536454438','hex'), '', f_id, '', 0   from tbsys_sysparam where f_key = 'ai-tools';
INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
select nextval('tbsys_sysparam_f_id_seq'), NULL, 'minimax-api', decode('68747470733A2F2F6170692E6D696E696D61782E636861742F76312F','hex'), '', f_id, '', 0  from tbsys_sysparam where f_key = 'ai-tools';
INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
select nextval('tbsys_sysparam_f_id_seq'), NULL, 'minimax-authorization', decode('65794A68624763694F694A53557A49314E694973496E523563434936496B705856434A392E65794A48636D393163453568625755694F694C6D7462666F6E72726E6C4B6A6D694C64664D7A59324D6A67794E5451774D6A4D774F4463334D5467314969776956584E6C636B3568625755694F694C6D7462666F6E72726E6C4B6A6D694C64664D7A59324D6A67794E5451774D6A4D774F4463334D5467314969776951574E6A623356756443493649694973496C4E31596D706C5933524A52434936496A45354D446B324E444D774F54637A4E5449354E7A41304E5449694C434A51614739755A534936496A45344D7A63784F4455784F54557A4969776952334A766458424A52434936496A45354D446B324E444D774F54637A4D7A45354F5467354D7A49694C434A515957646C546D46745A53493649694973496B3168615777694F6949694C434A44636D5668644756556157316C496A6F694D6A41794E5330774E4330774F5341784E546F314E546F304D794973496C52766132567556486C775A5349364D53776961584E7A496A6F6962576C756157316865434A392E63503959657334416236445F4B587042346A43386249736E766878513070397750394C4E6E6A4151454A6F49765832576149565A63587968584147553151383134565F42657832306C313138724E34456276693138737071794266796352652D46796F556A744C78746344573258315166777049577A4D7735504F322D75646D764E5175576955506F30476E50376A5A426F543752347143362D784572304A43775143326B4D6F415A746B4E593366386371395453566451337161466E58415771533434742D4A4B5336657130444F394369526A635257634838314774645A616A3032544274473949765153585F45666A3033657757713743715A345F7A6E654F4B4634795A543032524E543756685A6E6859494E336334716D693769686563754559457A4C2D554C4B515232464F625F34765665655934565476434168397649306F4C62566F436774376E614C7534784170377741','hex'), '', f_id, '', 0   from tbsys_sysparam where f_key = 'ai-tools';
INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
select nextval('tbsys_sysparam_f_id_seq'), NULL, 'minimax-groupId', decode('31393039363433303937333331393938393332','hex'), '', f_id, '', 0   from tbsys_sysparam where f_key = 'ai-tools';



INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(100158, '智能对话-模型类型', 12, 0, 'ai模型关系', 'ai-chat-type');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(100159, '智能问答-应用场景', 12, 0, '问答场景', 'ai-znwd-type');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10065, '智能分析-应用场景', 12, 0, '分析场景', 'ai-znfx-type');


INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11209, 'cloud-query', '智能图审', '请分析西夏区工业园区管委会5公顷范围内时序影像、历年土地现状，是否压占耕地、矿产，是否符合空间规划，以及历史照片，并生成报告。', -1, 0, 10065, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11210, 'selection-location', '优化选址', '要在中卫市中宁县鸣沙镇建设公共管理与公共服务设施用地，要求地块面积在500至10000平方米，不能压占生态保护红线、耕地，位于城镇开发边界，并且附近1000米内不能出现学校', -1, 1, 10065, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11212, 'i-query-2', '合规审查', '', -1, 2, 10065, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11213, 'basic-iquery', '灾害预警', '', -1, 3, 10065, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(111171, 'znjs', 'znjs', '', -1, 2, 100158, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(111173, 'znwd', 'znwd', '', -1, 3, 100158, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(111174, 'deepseek-v3', 'chat', '{"slug":"deepseek-r1"}', -1, 4, 100158, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(111170, 'main', 'znfx', '', -1, 1, 100158, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11203, 'xtbs', '系统部署', '国基平台后端在Linux服务器下如何部署？', 111181, 0, 100159, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11204, 'gnsy', '功能使用', '如何配置一个专业版本的智能图审工具？', 111181, 1, 100159, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11205, 'wtjd', '问题解答', '系统已接入地形服务，为什么三维球不显示？', 111181, 2, 100159, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11206, 'jdyd', '建设用地', '建设项目需使用林地，需办理哪些手续？', 111180, 0, 100159, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11207, 'wfyd', '违法用地', '农村已建房屋10年，如何补办用地手续？', 111180, 1, 100159, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11208, 'lsyd', '临时用地', '临时办公用房是否可占用耕地？', 111180, 2, 100159, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(111181, '8598122102829129728', '系统使用', 'ai-word', -1, 1, 100159, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(111180, '8598193573985165312', '政策解答', 'ai-policy', -1, 0, 100159, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11214, 'jbnt', '基本农田', '永久基本农田，什么情形允许占用和调整补划？', 111180, 3, 100159, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11215, 'zbph', '占补平衡', '国家是否支持跨省域占补充耕地，具体如何操作？', 111180, 4, 100159, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11216, 'sthx', '生态红线', '生态保护红线划定后，哪些情形允许人为活动？', 111180, 5, 100159, 1);
