-- ----------------------------
--2024年7月18日，wujing，新增云查询相关内容表
-- ----------------------------
drop table if exists tb_cloud_query_record_new;
CREATE TABLE tb_cloud_query_record_new (
	f_id varchar(64) NOT NULL,
	f_rid varchar(64) NULL,
	f_start_time timestamp NULL,
	f_end_time timestamp NULL,
	f_type int2 NULL,
	f_status int2 NULL,
	f_task_id varchar(255) NULL,
	f_total int4 NULL,
	f_success int4 NULL DEFAULT 0,
	f_failed int4 NULL DEFAULT 0,
	f_cost float8 NULL,
	f_cid text NULL,
	CONSTRAINT tb_cloud_query_record_new_pk PRIMARY KEY (f_id)
);
COMMENT ON TABLE tb_cloud_query_record_new IS '云查询请求记录表';

-- Column comments

COMMENT ON COLUMN tb_cloud_query_record_new.f_id IS '查询id';
COMMENT ON COLUMN tb_cloud_query_record_new.f_rid IS '分析请求唯一标识（分析请求id）';
COMMENT ON COLUMN tb_cloud_query_record_new.f_start_time IS '开始时间';
COMMENT ON COLUMN tb_cloud_query_record_new.f_end_time IS '结束时间';
COMMENT ON COLUMN tb_cloud_query_record_new.f_type IS '查询记录类型（1国家 2省级）';
COMMENT ON COLUMN tb_cloud_query_record_new.f_status IS '分析状态  0.进行中 1.已完成';
COMMENT ON COLUMN tb_cloud_query_record_new.f_task_id IS '任务id';
COMMENT ON COLUMN tb_cloud_query_record_new.f_total IS '分析总数';
COMMENT ON COLUMN tb_cloud_query_record_new.f_success IS '成功总数';
COMMENT ON COLUMN tb_cloud_query_record_new.f_failed IS '失败总数';
COMMENT ON COLUMN tb_cloud_query_record_new.f_cost IS '耗时';
COMMENT ON COLUMN tb_cloud_query_record_new.f_cid IS '国家级：通过该id查询结果     省级：通过该id进行过滤';

CREATE TABLE if not exists  tb_cloud_query_task (
	f_id varchar(255) NOT NULL,
	f_user_id varchar(255) NULL,
	f_create_time timestamp NULL,
	f_name varchar(255) NULL,
	f_address varchar(255) NULL,
	f_collect int2 NULL,
	f_area numeric NULL,
	f_sort int8 NULL,
	f_status int2 NULL,
	f_lon numeric(10, 7) NULL,
	f_lat numeric(10, 7) NULL,
	f_param text NULL,
	CONSTRAINT tb_cloud_query_task_pk PRIMARY KEY (f_id)
);
COMMENT ON TABLE tb_cloud_query_task IS '云查询任务表';

-- Column comments

COMMENT ON COLUMN tb_cloud_query_task.f_user_id IS '用户id';
COMMENT ON COLUMN tb_cloud_query_task.f_create_time IS '创建时间';
COMMENT ON COLUMN tb_cloud_query_task.f_name IS '分析名称';
COMMENT ON COLUMN tb_cloud_query_task.f_address IS '分析位置';
COMMENT ON COLUMN tb_cloud_query_task.f_collect IS '收藏（0.未收藏 1.收藏）';
COMMENT ON COLUMN tb_cloud_query_task.f_area IS '分析面积';
COMMENT ON COLUMN tb_cloud_query_task.f_sort IS '排序值';
COMMENT ON COLUMN tb_cloud_query_task.f_status IS '分析状态  -1 存在失败  0  进行  1  完成';
COMMENT ON COLUMN tb_cloud_query_task.f_lon IS '中心坐标点';
COMMENT ON COLUMN tb_cloud_query_task.f_lat IS '中心坐标点';
COMMENT ON COLUMN tb_cloud_query_task.f_param IS '请求参数';