/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.znts.util;

import cn.afterturn.easypoi.cache.WordCache;
import cn.afterturn.easypoi.entity.ImageEntity;
import cn.afterturn.easypoi.util.PoiElUtil;
import cn.afterturn.easypoi.util.PoiPublicUtil;
import cn.afterturn.easypoi.word.entity.MyXWPFDocument;
import cn.afterturn.easypoi.word.entity.params.ExcelListEntity;
import cn.afterturn.easypoi.word.parse.ParseWord07;
import cn.afterturn.easypoi.word.parse.excel.ExcelMapParse;
import cn.hutool.core.bean.BeanUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordParagraphHolder {
    private final Logger logger = LoggerFactory.getLogger(WordParagraphHolder.class);
    private XWPFDocument sourceDocument;
    private String targetFileName;
    private Map<String, Object> data;

    public WordParagraphHolder(XWPFDocument sourceDocument, String targetFileName, Map<String, Object> data) {
        this.sourceDocument = sourceDocument;
        this.targetFileName = targetFileName;
        this.data = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() throws Exception {
        MyXWPFDocument second = null;
        FileOutputStream fos2 = null;
        try {
            Map<String, Object> data = this.data;
            this.parseAllParagraphic(this.sourceDocument.getParagraphs(), data);
            this.parseAllTable(this.sourceDocument, data);
            File targetFile = new File(this.targetFileName);
            FileOutputStream fos = FileUtils.openOutputStream((File)targetFile);
            this.sourceDocument.write((OutputStream)fos);
            fos.close();
            this.sourceDocument.close();
            second = WordCache.getXWPFDocument((String)targetFile.getPath());
            this.evalAllParagraphic(second.getParagraphs(), data);
            this.evalAllTable((XWPFDocument)second, data);
            new ParseWord07().parseWord((XWPFDocument)second, data);
            fos2 = FileUtils.openOutputStream((File)targetFile);
            second.write((OutputStream)fos2);
        }
        catch (Exception e) {
            this.logger.error("\u751f\u6210word\u6bb5\u843d\u5931\u8d25:", (Throwable)e);
            String string = "";
            return string;
        }
        finally {
            if (fos2 != null) {
                fos2.close();
            }
            second.close();
        }
        return this.targetFileName;
    }

    private void evalAllTable(XWPFDocument doc, Map<String, Object> map) throws Exception {
        Iterator itTable = doc.getTablesIterator();
        while (itTable.hasNext()) {
            XWPFTable table = (XWPFTable)itTable.next();
            if (table.getText().indexOf("((") == -1 || table.getText().indexOf("fe:") == -1) continue;
            for (int i = 0; i < table.getNumberOfRows(); ++i) {
                XWPFTableRow row = table.getRow(i);
                List cells = row.getTableCells();
                for (XWPFTableCell cell : cells) {
                    this.evalAllParagraphic(cell.getParagraphs(), map);
                }
            }
        }
    }

    private void evalAllParagraphic(List<XWPFParagraph> paragraphs, Map<String, Object> map) throws Exception {
        int size = paragraphs.size();
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
        for (int i = 0; i < size; ++i) {
            XWPFParagraph paragraph = paragraphs.get(i);
            this.logger.info("\u6bb5\u843d\u5185\u5bb9\uff1a{}", (Object)paragraph.getText());
            if (paragraph.getText().indexOf("((") == -1 || paragraph.getText().indexOf("fe:") == -1) continue;
            Object obj = this.checkThisParagraphNeedIterator(paragraph, map);
            String listKey = this.getParagraphListKey(paragraph);
            Integer index = indexMap.getOrDefault(listKey, 0);
            if (!Objects.nonNull(obj) || !(obj instanceof List) || index >= ((List)obj).size()) continue;
            Object o = ((List)obj).get(index);
            this.parseParagraph(paragraph, o);
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
            indexMap.put(listKey, index);
        }
    }

    private void parseAllParagraphic(List<XWPFParagraph> paragraphs, Map<String, Object> map) throws Exception {
        Object obj;
        int size = paragraphs.size();
        ArrayList<XWPFParagraph> paragraphList = new ArrayList<XWPFParagraph>();
        for (int i = 0; i < size; ++i) {
            XWPFParagraph paragraph = paragraphs.get(i);
            if (paragraph.getText().indexOf("((") == -1 || !Objects.nonNull(obj = this.checkThisParagraphNeedIterator(paragraph, map)) || !(obj instanceof List)) continue;
            paragraphList.add(paragraph);
        }
        for (XWPFParagraph paragraph : paragraphList) {
            System.out.println(paragraph.getText());
            obj = this.checkThisParagraphNeedIterator(paragraph, map);
            if (paragraph.getText().contains("!fe:")) {
                this.addXWPFRun(paragraph, (List)obj);
                continue;
            }
            this.addParagraph(paragraph, (List)obj);
            XWPFDocument document = paragraph.getDocument();
            document.removeBodyElement(document.getPosOfParagraph(paragraph));
        }
    }

    private void parseAllTable(XWPFDocument doc, Map<String, Object> map) throws Exception {
        Iterator itTable = doc.getTablesIterator();
        while (itTable.hasNext()) {
            XWPFTable table = (XWPFTable)itTable.next();
            if (table.getText().indexOf("((") == -1) continue;
            this.parseThisTable(table, map);
        }
    }

    private void parseThisTable(XWPFTable table, Map<String, Object> map) throws Exception {
        for (int i = 0; i < table.getNumberOfRows(); ++i) {
            XWPFTableRow row = table.getRow(i);
            List cells = row.getTableCells();
            this.parseThisRow(cells, map);
        }
    }

    private void parseThisRow(List<XWPFTableCell> cells, Map<String, Object> map) throws Exception {
        for (XWPFTableCell cell : cells) {
            this.parseAllParagraphic(cell.getParagraphs(), map);
        }
    }

    public void createParagraph(XWPFParagraph source, XWPFDocument doc) {
        if (source.getText().contains("$fe:")) {
            XmlCursor cursor = source.getCTP().newCursor();
            XWPFParagraph newParagraph = doc.insertNewParagraph(cursor);
            newParagraph.getCTP().set(source.getCTP().copy());
        }
    }

    private Object checkThisParagraphNeedIterator(XWPFParagraph paragraph, Map<String, Object> map) throws Exception {
        String text = paragraph.getText().trim();
        if (text != null && text.contains("fe:") && text.startsWith("((")) {
            String[] keys = (text = text.replace("!fe:", "").replace("$fe:", "").replace("fe:", "").replace("((", "").replace("))", "")).replaceAll("\\s{1,}", " ").trim().split(" ");
            Object result = PoiPublicUtil.getParamsValue((String)keys[0], map);
            return Objects.nonNull(result) ? result : new ArrayList(0);
        }
        return null;
    }

    private String getParagraphListKey(XWPFParagraph paragraph) throws Exception {
        String text = paragraph.getText().trim();
        if (text != null && text.contains("fe:") && text.startsWith("((")) {
            text = text.replace("!fe:", "").replace("$fe:", "").replace("fe:", "").replace("((", "");
            String[] keys = text.replaceAll("\\s{1,}", " ").trim().split(" ");
            return keys[0];
        }
        return null;
    }

    public void parseParagraph(XWPFParagraph paragraph, Object obj) throws Exception {
        String listname = paragraph.getText().trim();
        boolean contains = listname.contains("fe:");
        if (!contains) {
            return;
        }
        Map objectMap = BeanUtil.beanToMap((Object)obj, (String[])new String[0]);
        this.parseThisParagraph(paragraph, objectMap);
    }

    public void addXWPFRun(XWPFParagraph paragraph, List<Object> list) throws Exception {
        int i;
        String orgTxt = paragraph.getText();
        if (!orgTxt.contains("!fe:")) {
            return;
        }
        List xwpfRuns = paragraph.getRuns();
        for (i = xwpfRuns.size() - 1; i >= 0; --i) {
            paragraph.removeRun(i);
        }
        for (i = 0; i < list.size(); ++i) {
            Object item = list.get(i);
            boolean isLast = i == list.size() - 1;
            XWPFRun run = paragraph.createRun();
            String txt = orgTxt;
            try {
                txt = this.parseThisRunTxt(txt, (Map)item);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (isLast && (txt.endsWith(",") || txt.endsWith(";") || txt.endsWith("\uff1b") || txt.endsWith("\uff0c"))) {
                txt = txt.substring(0, txt.length() - 1);
            }
            run.setText(txt);
        }
    }

    public void addParagraph(XWPFParagraph paragraph, List<Object> list) throws Exception {
        XWPFParagraph currentParagraph = paragraph;
        System.out.println("start for each data list :" + list.size());
        for (int i = 0; i < list.size(); ++i) {
            this.createParagraph(currentParagraph, currentParagraph.getDocument());
        }
    }

    private String parseThisRunTxt(String xwpfRunText, Map<String, Object> map) throws Exception {
        String target = "";
        String[] texts = xwpfRunText.split(" ");
        for (int i = 0; i < texts.length; ++i) {
            String text = texts[i];
            if (StringUtils.isEmpty((CharSequence)text)) continue;
            if (text.indexOf("]") != -1 && text.indexOf("[") != -1) {
                target = target + WordParagraphHolder.getRealValue(text, map);
            }
            if (text.indexOf("((") != -1 || text.indexOf("))") != -1 || text.indexOf("fe:") != -1 || text.indexOf("]") != -1 || text.indexOf("[") != -1) continue;
            target = target + text;
        }
        return target;
    }

    private void parseThisParagraph(XWPFParagraph paragraph, Map<String, Object> map) throws Exception {
        XWPFRun currentRun = null;
        String currentText = "";
        Boolean isfinde = false;
        ArrayList<Integer> runIndex = new ArrayList<Integer>();
        XWPFRun preRun = null;
        for (int i = 0; i < paragraph.getRuns().size(); ++i) {
            XWPFRun run = (XWPFRun)paragraph.getRuns().get(i);
            String text = run.getText(0);
            if (!StringUtils.isEmpty((CharSequence)text)) {
                if (isfinde.booleanValue()) {
                    if ((currentText = currentText + text).indexOf("[") == -1) {
                        isfinde = false;
                        runIndex.clear();
                    } else {
                        runIndex.add(i);
                    }
                    if (currentText.indexOf("]") != -1) {
                        this.changeValues(paragraph, currentRun, currentText, runIndex, map);
                        currentText = "";
                        isfinde = false;
                    }
                } else if (text.indexOf("[") >= 0) {
                    currentText = text;
                    isfinde = true;
                    currentRun = run;
                } else {
                    currentText = "";
                }
                if (currentText.indexOf("]") != -1) {
                    this.changeValues(paragraph, currentRun, currentText, runIndex, map);
                    isfinde = false;
                }
            }
            if (StringUtils.isEmpty((CharSequence)text)) continue;
            if (text.indexOf("((") != -1) {
                preRun = run;
            } else if (text.indexOf("$fe") != -1) {
                run.setText("", 0);
                preRun.setText("", 0);
            } else if (text.indexOf("!fe") != -1) {
                run.setText("", 0);
                preRun.setText("", 0);
            } else if (text.indexOf("!fe") != -1) {
                run.setText("", 0);
                preRun.setText("", 0);
            } else if (text.indexOf("fe") != -1) {
                run.setText("", 0);
                preRun.setText("", 0);
            } else if (text.indexOf("$") != -1) {
                run.setText("", 0);
                preRun.setText("", 0);
            }
            if (text.indexOf("))") == -1 || text.length() < 1) continue;
            String replace = text.replace("))", "");
            run.setText(replace, 0);
        }
    }

    private void changeValues(XWPFParagraph paragraph, XWPFRun currentRun, String currentText, List<Integer> runIndex, Map<String, Object> map) throws Exception {
        Object obj = WordParagraphHolder.getRealValue(currentText, map);
        if (obj instanceof ImageEntity) {
            currentRun.setText("", 0);
            ExcelMapParse.addAnImage((ImageEntity)((ImageEntity)obj), (XWPFRun)currentRun);
        } else {
            currentText = obj.toString();
            PoiPublicUtil.setWordText((XWPFRun)currentRun, (String)currentText);
        }
        for (int k = 0; k < runIndex.size(); ++k) {
            ((XWPFRun)paragraph.getRuns().get(runIndex.get(k))).setText("", 0);
        }
        runIndex.clear();
    }

    public static Object getRealValue(String currentText, Map<String, Object> map) throws Exception {
        String params = "";
        while (currentText.indexOf("[") != -1) {
            params = currentText.substring(currentText.indexOf("[") + 1, currentText.indexOf("]"));
            Object obj = PoiElUtil.eval((String)params.trim(), map);
            if (obj instanceof ImageEntity || obj instanceof List || obj instanceof ExcelListEntity) {
                return obj;
            }
            if (obj != null) {
                currentText = currentText.replace("[" + params + "]", obj.toString());
                continue;
            }
            currentText = currentText.replace("[" + params + "]", "");
        }
        return currentText;
    }
}

