/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.asr.service.impl;

import cn.hutool.core.io.FileUtil;
import com.geoway.ns.smart.asr.service.AsrVoskService;
import com.geoway.ns.smart.asr.util.VoskAsrUtil;
import java.io.File;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AsrVoskServiceImpl
implements AsrVoskService {
    @Autowired
    private VoskAsrUtil voskAsrUtil;
    @Value(value="${asr.enable:false}")
    private boolean enable;

    @Override
    public String analysis(MultipartFile audioFile) throws Exception {
        if (!this.enable) {
            throw new Exception("\u8bed\u97f3\u8bc6\u522b\u529f\u80fd\u672a\u542f\u7528!");
        }
        String dir = System.getProperty("user.dir");
        String tempDirPath = dir + File.separator + UUID.randomUUID().toString();
        File tempDirFile = new File(tempDirPath);
        tempDirFile.mkdir();
        String tempFilePath = tempDirPath + File.separator + audioFile.getOriginalFilename();
        try {
            audioFile.transferTo(new File(tempFilePath));
            String string = this.voskAsrUtil.getWord(tempFilePath);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("\u8bed\u97f3\u8bc6\u522b\u5931\u8d25:" + e.getMessage());
        }
        finally {
            FileUtil.del((String)tempFilePath);
            FileUtil.del((File)tempDirFile);
        }
    }
}

