-- ----------------------------
--2025年9月2日，新增微观查询相关表
-- ----------------------------
-- tb_onemap4_codequery_catalog definition

-- Drop table

-- DROP TABLE tb_onemap4_codequery_catalog;

CREATE TABLE tb_onemap4_codequery_catalog (
	f_id varchar(50) NOT NULL,
	f_scheme_id varchar(50) NOT NULL, -- 微观查询方案id
	f_pid varchar(50) NOT NULL, -- 父节点id
	f_name varchar(100) NOT NULL, -- 名称
	f_type int4 NOT NULL, -- 类型：1目录，2数据/分析项
	f_order int4 NOT NULL, -- 排序
	f_customserviceclass text NULL, -- 算法
	f_service_id varchar(50) NULL, -- 服务id和服务url互斥
	f_service_name varchar(200) NULL, -- 服务名称与服务id同时有值
	f_custom_config text NULL, -- 自定义配置项
	f_versiontablemapping text NULL, -- 数据版本映射关系
	f_servicetype varchar(50) NULL, -- 第三方服务类型：geoserver分析引擎，arcgis
	f_url text NULL, -- 分析服务地址
	f_otherparams text NULL, -- 第三方分析服务其他参数
	f_group_id varchar(50) NOT NULL, -- 微观查询分组表id
	f_is_jzcx int2 DEFAULT 0 NULL, -- 是否是举证图层：0否，1是
	CONSTRAINT tb_onemap4_codequery_catalog_pkey PRIMARY KEY (f_id)
);
COMMENT ON TABLE tb_onemap4_codequery_catalog IS '一码管地（微观查询）目录表';

-- Column comments

COMMENT ON COLUMN tb_onemap4_codequery_catalog.f_scheme_id IS '微观查询方案id';
COMMENT ON COLUMN tb_onemap4_codequery_catalog.f_pid IS '父节点id';
COMMENT ON COLUMN tb_onemap4_codequery_catalog.f_name IS '名称';
COMMENT ON COLUMN tb_onemap4_codequery_catalog.f_type IS '类型：1目录，2数据/分析项';
COMMENT ON COLUMN tb_onemap4_codequery_catalog.f_order IS '排序';
COMMENT ON COLUMN tb_onemap4_codequery_catalog.f_customserviceclass IS '算法';
COMMENT ON COLUMN tb_onemap4_codequery_catalog.f_service_id IS '服务id和服务url互斥';
COMMENT ON COLUMN tb_onemap4_codequery_catalog.f_service_name IS '服务名称与服务id同时有值';
COMMENT ON COLUMN tb_onemap4_codequery_catalog.f_custom_config IS '自定义配置项';
COMMENT ON COLUMN tb_onemap4_codequery_catalog.f_versiontablemapping IS '数据版本映射关系';
COMMENT ON COLUMN tb_onemap4_codequery_catalog.f_servicetype IS '第三方服务类型：geoserver分析引擎，arcgis';
COMMENT ON COLUMN tb_onemap4_codequery_catalog.f_url IS '分析服务地址';
COMMENT ON COLUMN tb_onemap4_codequery_catalog.f_otherparams IS '第三方分析服务其他参数';
COMMENT ON COLUMN tb_onemap4_codequery_catalog.f_group_id IS '微观查询分组表id';
COMMENT ON COLUMN tb_onemap4_codequery_catalog.f_is_jzcx IS '是否是举证图层：0否，1是';


-- tb_onemap4_codequery_group definition

-- Drop table

-- DROP TABLE tb_onemap4_codequery_group;

CREATE TABLE tb_onemap4_codequery_group (
	f_id varchar(50) NOT NULL,
	f_scheme_id varchar(50) NOT NULL, -- 微观查询方案id
	f_name varchar(100) NOT NULL, -- 分组名称
	f_order int4 NOT NULL, -- 排序
	f_desc varchar(200) NULL, -- 描述
	f_custom_config text NULL, -- 自定义配置项
	CONSTRAINT tb_onemap4_codequery_group_pkey PRIMARY KEY (f_id)
);
COMMENT ON TABLE tb_onemap4_codequery_group IS '一码管地（微观查询）分组表';

-- Column comments

COMMENT ON COLUMN tb_onemap4_codequery_group.f_scheme_id IS '微观查询方案id';
COMMENT ON COLUMN tb_onemap4_codequery_group.f_name IS '分组名称';
COMMENT ON COLUMN tb_onemap4_codequery_group.f_order IS '排序';
COMMENT ON COLUMN tb_onemap4_codequery_group.f_desc IS '描述';
COMMENT ON COLUMN tb_onemap4_codequery_group.f_custom_config IS '自定义配置项';


-- tb_onemap4_codequery_field definition

-- Drop table

-- DROP TABLE tb_onemap4_codequery_field;

CREATE TABLE tb_onemap4_codequery_field (
	f_id varchar(50) NOT NULL,
	f_catalog_id varchar(50) NOT NULL, -- catalog表id
	f_name varchar(100) NOT NULL, -- 字段名称
	f_alias varchar(100) NULL, -- 字段别名
	f_type varchar(100) NULL, -- 字段类型
	f_translate_dict varchar(100) NULL, -- 关联字典
	f_order varchar(100) NULL, -- 排序
	CONSTRAINT tb_onemap4_codequery_field_pkey PRIMARY KEY (f_id)
);
COMMENT ON TABLE tb_onemap4_codequery_field IS '一码管地（微观查询）字段表';

-- Column comments

COMMENT ON COLUMN tb_onemap4_codequery_field.f_catalog_id IS 'catalog表id';
COMMENT ON COLUMN tb_onemap4_codequery_field.f_name IS '字段名称';
COMMENT ON COLUMN tb_onemap4_codequery_field.f_alias IS '字段别名';
COMMENT ON COLUMN tb_onemap4_codequery_field.f_type IS '字段类型';
COMMENT ON COLUMN tb_onemap4_codequery_field.f_translate_dict IS '关联字典';
COMMENT ON COLUMN tb_onemap4_codequery_field.f_order IS '排序';


-- tb_onemap4_codequery_graph definition

-- Drop table

-- DROP TABLE tb_onemap4_codequery_graph;

CREATE TABLE tb_onemap4_codequery_graph (
	f_id varchar(50) NOT NULL,
	f_catalog_id varchar(50) NOT NULL, -- catalog表id
	f_graph_template varchar(100) NULL, -- 模板
	f_group_field varchar(100) NULL, -- 分组字段
	f_stat_field varchar(100) NULL, -- 统计字段
	f_color_scheme varchar(100) NULL, -- 颜色方案
	CONSTRAINT tb_onemap4_codequery_graph_pkey PRIMARY KEY (f_id)
);
COMMENT ON TABLE tb_onemap4_codequery_graph IS '一码管地（微观查询）显示配置表';

-- Column comments

COMMENT ON COLUMN tb_onemap4_codequery_graph.f_catalog_id IS 'catalog表id';
COMMENT ON COLUMN tb_onemap4_codequery_graph.f_graph_template IS '模板';
COMMENT ON COLUMN tb_onemap4_codequery_graph.f_group_field IS '分组字段';
COMMENT ON COLUMN tb_onemap4_codequery_graph.f_stat_field IS '统计字段';
COMMENT ON COLUMN tb_onemap4_codequery_graph.f_color_scheme IS '颜色方案';


-- tb_onemap4_codequery_scheme definition

-- Drop table

-- DROP TABLE tb_onemap4_codequery_scheme;

CREATE TABLE tb_onemap4_codequery_scheme (
	f_id varchar(50) NOT NULL,
	f_name varchar(100) NOT NULL, -- 名称
	f_alias varchar(200) NOT NULL, -- 别名
	f_desc text NULL, -- 描述
	f_order int4 NOT NULL, -- 显示顺序
	f_isdefault int2 NOT NULL, -- 默认：0否1是
	f_group varchar(128) NULL, -- 分组
	CONSTRAINT tb_onemap4_codequery_scheme_pkey PRIMARY KEY (f_id)
);
COMMENT ON TABLE tb_onemap4_codequery_scheme IS '一码管地（微观查询）方案表';

-- Column comments

COMMENT ON COLUMN tb_onemap4_codequery_scheme.f_name IS '名称';
COMMENT ON COLUMN tb_onemap4_codequery_scheme.f_alias IS '别名';
COMMENT ON COLUMN tb_onemap4_codequery_scheme.f_desc IS '描述';
COMMENT ON COLUMN tb_onemap4_codequery_scheme.f_order IS '显示顺序';
COMMENT ON COLUMN tb_onemap4_codequery_scheme.f_isdefault IS '默认：0否1是';
COMMENT ON COLUMN tb_onemap4_codequery_scheme.f_group IS '分组';


-- tb_onemap4_codequery_scheme_resnode definition

-- Drop table

-- DROP TABLE tb_onemap4_codequery_scheme_resnode;

CREATE TABLE tb_onemap4_codequery_scheme_resnode (
	f_id varchar NOT NULL, -- 主键
	f_res_node_id varchar NULL, -- 资源目录的资源节点
	f_res_name varchar NULL, -- 资源名称
	f_params varchar NULL, -- 扩展参数
	f_plan_id varchar NULL, -- 方案id
	CONSTRAINT pk_tb_onemap4_codequery_scheme_resnode PRIMARY KEY (f_id)
);

-- Column comments

COMMENT ON COLUMN tb_onemap4_codequery_scheme_resnode.f_id IS '主键';
COMMENT ON COLUMN tb_onemap4_codequery_scheme_resnode.f_res_node_id IS '资源目录的资源节点';
COMMENT ON COLUMN tb_onemap4_codequery_scheme_resnode.f_res_name IS '资源名称';
COMMENT ON COLUMN tb_onemap4_codequery_scheme_resnode.f_params IS '扩展参数';
COMMENT ON COLUMN tb_onemap4_codequery_scheme_resnode.f_plan_id IS '方案id';

-- tb_onemap4_codequery_task definition

-- Drop table

-- DROP TABLE tb_onemap4_codequery_task;

CREATE TABLE tb_onemap4_codequery_task (
	f_id varchar(255) NOT NULL,
	f_user_id varchar(255) NULL, -- 用户id
	f_create_time timestamp NULL, -- 创建时间
	f_name varchar(255) NULL, -- 分析名称
	f_address varchar(255) NULL, -- 分析位置
	f_collect int2 NULL, -- 收藏（0.未收藏 1.收藏）
	f_area numeric NULL, -- 分析面积
	f_sort int8 NULL, -- 排序值
	f_status int2 NULL, -- 分析状态  -1 存在失败  0  进行  1  完成
	f_lon numeric(10, 7) NULL, -- 中心坐标点
	f_lat numeric(10, 7) NULL, -- 中心坐标点
	f_param text NULL, -- 请求参数
	f_tag text NULL, -- 标签，用于业务扩展自定义标记
	f_message text NULL, -- 异常信息
	f_result text NULL, -- 微观查询结果
	CONSTRAINT tb_onemap4_codequery_task_pk PRIMARY KEY (f_id)
);
COMMENT ON TABLE tb_onemap4_codequery_task IS '一码管地（微观查询）任务表';

-- Column comments

COMMENT ON COLUMN tb_onemap4_codequery_task.f_user_id IS '用户id';
COMMENT ON COLUMN tb_onemap4_codequery_task.f_create_time IS '创建时间';
COMMENT ON COLUMN tb_onemap4_codequery_task.f_name IS '分析名称';
COMMENT ON COLUMN tb_onemap4_codequery_task.f_address IS '分析位置';
COMMENT ON COLUMN tb_onemap4_codequery_task.f_collect IS '收藏（0.未收藏 1.收藏）';
COMMENT ON COLUMN tb_onemap4_codequery_task.f_area IS '分析面积';
COMMENT ON COLUMN tb_onemap4_codequery_task.f_sort IS '排序值';
COMMENT ON COLUMN tb_onemap4_codequery_task.f_status IS '分析状态  -1 存在失败  0  进行  1  完成';
COMMENT ON COLUMN tb_onemap4_codequery_task.f_lon IS '中心坐标点';
COMMENT ON COLUMN tb_onemap4_codequery_task.f_lat IS '中心坐标点';
COMMENT ON COLUMN tb_onemap4_codequery_task.f_param IS '请求参数';
COMMENT ON COLUMN tb_onemap4_codequery_task.f_tag IS '标签，用于业务扩展自定义标记';
COMMENT ON COLUMN tb_onemap4_codequery_task.f_message IS '异常信息';
COMMENT ON COLUMN tb_onemap4_codequery_task.f_result IS '微观查询结果';