/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.codequery.scheduler;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.geoway.adf.dms.catalog.service.impl.ResCatalogNodeServiceImpl;
import com.geoway.adf.dms.datasource.dto.renderindex.DatasetRenderDTO;
import com.geoway.ns.geoserver3.dto.TbAnalysisTask;
import com.geoway.ns.geoserver3.service.IGeoserver3TaskService;
import com.geoway.ns.smart.codequery.dto.CodequeryGraphAndFields;
import com.geoway.ns.smart.codequery.dto.CodequeryResultDetail;
import com.geoway.ns.smart.codequery.dto.VersionTableMapping;
import com.geoway.ns.smart.codequery.entity.CodequeryCatalog;
import com.geoway.ns.smart.codequery.entity.CodequeryTask;
import com.geoway.ns.smart.codequery.service.CodequeryCatalogService;
import com.geoway.ns.smart.codequery.service.CodequeryTaskService;
import com.geoway.ns.sys.utils.TenantUserUtil;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class CodequeryScheduler {
    @Value(value="${codequery.enable:false}")
    private Boolean enable;
    @Value(value="${codequery.timeout:30}")
    private int timeout;
    @Autowired
    private CodequeryTaskService codequeryTaskService;
    @Autowired
    private CodequeryCatalogService codequeryCatalogService;
    @Autowired
    private IGeoserver3TaskService geoserver3TaskService;
    @Autowired
    private TenantUserUtil tenantUserUtil;
    @Autowired
    private ResCatalogNodeServiceImpl resCatalogService;

    @Scheduled(cron="${codequery.cron:0/3 * * * * ?}")
    public void pollingTask() {
        this.pollingTask(false);
    }

    public void pollingTask(Boolean testEnable) {
        if (this.enable.booleanValue() || testEnable.booleanValue()) {
            this.tenantUserUtil.userManage();
            List tasks = this.codequeryTaskService.list((Wrapper)Wrappers.lambdaQuery(CodequeryTask.class).eq(CodequeryTask::getStatus, (Object)0));
            if (!tasks.isEmpty()) {
                for (CodequeryTask task : tasks) {
                    try {
                        this.syncData(task);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        task.setStatus(-1);
                        task.setMessage(e.getMessage());
                    }
                }
                this.codequeryTaskService.updateBatchById(tasks);
            }
        }
    }

    private void syncData(CodequeryTask task) {
        long createTime = new Date().getTime();
        Gson gson = new Gson();
        List requestTasks = (List)gson.fromJson(task.getResult(), new TypeToken<List<CodequeryResultDetail>>(){}.getType());
        boolean hasChangeStatus = false;
        for (CodequeryResultDetail requestTask : requestTasks) {
            boolean _hasChangeStatus;
            Integer status = requestTask.getStatus();
            if (status != 0 || !(_hasChangeStatus = this.queryStatus(requestTask).booleanValue())) continue;
            hasChangeStatus = _hasChangeStatus;
        }
        CodequeryResultDetail running = requestTasks.stream().filter(f -> f.getStatus() == 0).findAny().orElse(null);
        CodequeryResultDetail failed = requestTasks.stream().filter(f -> f.getStatus() == -1).findAny().orElse(null);
        if (running == null && failed == null) {
            task.setStatus(1);
            task.setResult(JSONObject.toJSONString((Object)requestTasks));
        } else if (running == null && failed != null) {
            task.setStatus(-1);
            task.setResult(JSONObject.toJSONString((Object)requestTasks));
        }
        long nowTime = new Date().getTime();
        if (nowTime - createTime > (long)(60 * this.timeout * 1000)) {
            task.setStatus(-1);
            task.setMessage("\u7b49\u5f85\u7ed3\u679c\u8d85\u65f6\uff01");
            hasChangeStatus = true;
        }
        if (hasChangeStatus) {
            this.codequeryTaskService.saveOrUpdate(task);
        }
    }

    private Boolean queryStatus(CodequeryResultDetail requestTask) {
        String catalogId = requestTask.getCatalogId();
        String UniqueTaskID = requestTask.getUniqueTaskId();
        String catalogName = requestTask.getCatalogName();
        Integer status = requestTask.getStatus();
        TbAnalysisTask task = this.geoserver3TaskService.findTaskById(UniqueTaskID);
        if (task.getStatus() == 500) {
            requestTask.setStatus(-1);
            requestTask.setMessage(task.getMsg());
            return true;
        }
        if (task.getStatus() == 200) {
            requestTask.setStatus(1);
            requestTask.setMessage(task.getMsg());
            CodequeryGraphAndFields ztfxGraphAndFields = this.codequeryCatalogService.queryDisplayConfig(catalogId);
            requestTask.setGraph(ztfxGraphAndFields.getGraph());
            requestTask.setFields(ztfxGraphAndFields.getFields());
            CodequeryCatalog codequeryCatalog = this.codequeryCatalogService.queryDetail(catalogId, false);
            JSONObject resultData = this.geoserver3TaskService.findResult(UniqueTaskID);
            CodequeryResultDetail.YearResult yearResult = new CodequeryResultDetail.YearResult();
            for (VersionTableMapping curVersion : codequeryCatalog.getVersionTableMappings()) {
                try {
                    DatasetRenderDTO renderDTO = this.resCatalogService.getNodeRender(curVersion.getNodeId());
                    yearResult.setRender(renderDTO);
                }
                catch (Exception ex) {
                    System.out.println(curVersion.getNodeId() + "\u8bf7\u6c42\u6e32\u67d3\u4fe1\u606f\u5f02\u5e38:" + JSONObject.toJSONString((Object)codequeryCatalog));
                    ex.printStackTrace();
                }
                yearResult.setResNodeId(curVersion.getNodeId());
                yearResult.setResults(resultData.getJSONArray("Results"));
                requestTask.getResults().add(yearResult);
            }
            return true;
        }
        return false;
    }

    private double getCost(Date start, Date end) {
        double e = (double)end.getTime() / 1000.0;
        double s = (double)start.getTime() / 1000.0;
        double res = e - s;
        return BigDecimal.valueOf(res).setScale(3, 1).doubleValue();
    }
}

