/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.znts.service.impl;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.datasource.dao.DmDistrictDao;
import com.geoway.adf.dms.datasource.dto.district.DistrictItemDTO;
import com.geoway.adf.dms.datasource.entity.DmDistrict;
import com.geoway.adf.dms.datasource.service.DistrictService;
import com.geoway.ns.base.enums.ShapeType;
import com.geoway.ns.base.util.GeometryUtils;
import com.geoway.ns.smart.znts.dto.AppCloudQueryParam;
import com.geoway.ns.smart.znts.dto.CloudQueryParam;
import com.geoway.ns.smart.znts.dto.GroupCloudQueryParam;
import com.geoway.ns.smart.znts.dto.WebCombineCloudQueryParam;
import com.geoway.ns.smart.znts.entity.CloudQuery;
import com.geoway.ns.smart.znts.entity.CloudQueryItem;
import com.geoway.ns.smart.znts.entity.CloudQueryItemSj;
import com.geoway.ns.smart.znts.entity.CloudQueryNode;
import com.geoway.ns.smart.znts.entity.CloudQueryRecord;
import com.geoway.ns.smart.znts.enums.BizEnum;
import com.geoway.ns.smart.znts.enums.CloudQueryState;
import com.geoway.ns.smart.znts.service.CloudQueryItemService;
import com.geoway.ns.smart.znts.service.CloudQueryItemSjService;
import com.geoway.ns.smart.znts.service.CloudQueryNodeService;
import com.geoway.ns.smart.znts.service.CloudQueryRecordService;
import com.geoway.ns.smart.znts.service.CloudQueryService;
import com.geoway.ns.smart.znts.service.CombineCloudQueryService;
import com.geoway.ns.smart.znts.service.ICloudQueryConfigService;
import com.geoway.ns.smart.znts.service.NationalCloudQueryService;
import com.geoway.ns.smart.znts.service.ProvincialCloudQueryService;
import com.geoway.ns.smart.znts.util.CloudQueryHttpUtil;
import com.geoway.ns.sys.service.ITokenService;
import com.google.gson.Gson;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.TransformException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class CombineCloudQueryServiceImpl
implements CombineCloudQueryService {
    private static final Logger log = LogManager.getLogger(CombineCloudQueryServiceImpl.class);
    @Resource
    private CloudQueryHttpUtil cloudQueryHttpUtil;
    @Resource
    private ITokenService tokenService;
    @Resource
    private ICloudQueryConfigService cloudQueryConfigService;
    @Resource
    private CloudQueryItemService cloudQueryItemService;
    @Resource
    private CloudQueryRecordService cloudQueryRecordService;
    @Resource
    private CloudQueryService cloudQueryService;
    @Resource
    private CloudQueryNodeService cloudQueryNodeService;
    @Resource
    private CloudQueryItemSjService cloudQueryItemSjService;
    @Resource
    private DistrictService districtService;
    @Resource
    private DmDistrictDao dmDistrictDao;
    @Resource
    private NationalCloudQueryService nationalCloudQueryService;
    @Resource
    private ProvincialCloudQueryService provincialCloudQueryService;

    @Override
    public String sendCloudQuery(WebCombineCloudQueryParam param) throws Exception {
        String userId = this.tokenService.queryCurrentSysUserId();
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)userId), (String)"\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u767b\u5f55\u4fe1\u606f\uff01");
        String requestId = UUID.randomUUID().toString();
        String poiName = "";
        String address = "";
        String wkt = param.getWkt();
        Map<String, Object> wktMap = this.buildGeometryParams(wkt);
        if (StringUtils.isBlank((CharSequence)poiName)) {
            try {
                Double lon = (Double)wktMap.get("lon");
                Double lat = (Double)wktMap.get("lat");
                Short level = 3;
                String geometry = "point(" + lon + " " + lat + ")";
                List list = this.dmDistrictDao.queryDefault();
                Long districtId = ((DmDistrict)list.get(0)).getId();
                List districtItemDTOS = this.districtService.queryDistrictItem(districtId, level, geometry);
                if (districtItemDTOS.size() > 0) {
                    poiName = ((DistrictItemDTO)districtItemDTOS.get(0)).getName();
                    address = ((DistrictItemDTO)districtItemDTOS.get(0)).getName();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (ObjectUtils.isNotEmpty(param.getCountry())) {
            int size = param.getCountry().size();
            for (int i = 0; i < size; ++i) {
                GroupCloudQueryParam groupCloudQueryParam = param.getCountry().get(i);
                String group = groupCloudQueryParam.getGroup();
                String layers = groupCloudQueryParam.getLayers();
                if (StringUtils.isBlank((CharSequence)group) || StringUtils.isBlank((CharSequence)layers) || group.indexOf("undefined") != -1 || layers.indexOf("undefined") != -1) continue;
                List<CloudQueryItem> cloudQueryItems = this.cloudQueryItemService.getUserCloudQueryItems(userId, wkt, group, layers, null);
                Map map = cloudQueryItems.stream().map(cloudQueryItem -> {
                    String time;
                    String tag = cloudQueryItem.getTag() == null ? "" : cloudQueryItem.getTag();
                    String name = cloudQueryItem.getName() == null ? "" : cloudQueryItem.getName();
                    String string = time = cloudQueryItem.getTime() == null ? "" : DateFormatUtils.format((Date)cloudQueryItem.getTime(), (String)"yyyyMMdd");
                    if (StringUtils.isNotBlank((CharSequence)time)) {
                        name = name + "_" + time;
                    }
                    return MapUtil.builder((Object)"tag", (Object)tag).put((Object)"name", (Object)name).build();
                }).collect(Collectors.groupingBy(item -> (String)item.get("tag"), Collectors.mapping(item -> (String)item.get("name"), Collectors.toList())));
                ArrayList queryIds = new ArrayList();
                map.forEach((tag, names) -> {
                    String analyzeType = StringUtils.join((Iterable)names, (String)"\u3001");
                    try {
                        CloudQuery cloudQuery = this.sendCloudQuery(wktMap, wkt, param.getWidth(), param.getHeight(), (String)tag, userId, analyzeType, requestId);
                        queryIds.add(cloudQuery.getId());
                    }
                    catch (Exception exception) {
                        log.error("[" + tag + "]\u4e91\u67e5\u8be2\u5931\u8d25\uff01", (Throwable)exception);
                    }
                });
                String queryIdString = StringUtils.join(queryIds, (String)",");
                Map params = MapUtil.builder((Object)"requestId", (Object)requestId).put((Object)"queryIds", (Object)queryIdString).put((Object)"wkt", (Object)wkt).put((Object)"width", (Object)param.getWidth()).put((Object)"height", (Object)param.getHeight()).put((Object)"group", (Object)group).put((Object)"layers", (Object)layers).build();
                CloudQueryRecord cloudQueryRecord = CloudQueryRecord.builder().requestId(requestId).userId(userId).cloudId(queryIdString).param(JSONObject.toJSONString((Object)params)).status(0).type(1).updateTime(new Date()).wkt(wkt).lon((Double)wktMap.get("lon")).lat((Double)wktMap.get("lat")).area((Double)wktMap.get("mj")).tag(group).queryTime(new Date()).name(poiName).address(address).build();
                this.cloudQueryRecordService.saveRecord(cloudQueryRecord);
            }
        }
        ArrayList serviceRuleList = new ArrayList();
        if (ObjectUtils.isNotEmpty(param.getProvince())) {
            int size = param.getProvince().size();
            for (int i = 0; i < size; ++i) {
                List services;
                GroupCloudQueryParam groupCloudQueryParam = param.getProvince().get(i);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("AnalysisID", (Object)UUID.randomUUID().toString());
                jsonObject.put("ApplicationGUID", (Object)"APP");
                jsonObject.put("SFFHTX", (Object)false);
                jsonObject.put("YearMonth", (Object)"");
                jsonObject.put("areaType", (Object)"ProjectArea");
                jsonObject.put("bufferDistance", (Object)500);
                jsonObject.put("drawBlocks", (Object)true);
                jsonObject.put("drawWidth", (Object)5);
                jsonObject.put("inCoorFormat", (Object)"WKT");
                jsonObject.put("outCoorFormat", (Object)"WKT");
                jsonObject.put("getImage", (Object)true);
                jsonObject.put("color", (Object)"#f73131");
                JSONObject subJsonObject = new JSONObject();
                subJsonObject.put("DK_ID", (Object)UUID.randomUUID().toString());
                subJsonObject.put("WKID", (Object)"4490");
                subJsonObject.put("WKT", (Object)wkt);
                JSONArray jsonArray = new JSONArray();
                jsonArray.add((Object)subJsonObject);
                jsonObject.put("Blocks", (Object)jsonArray);
                String group = groupCloudQueryParam.getGroup();
                String layers = groupCloudQueryParam.getLayers();
                if (StringUtils.isBlank((CharSequence)group) || StringUtils.isBlank((CharSequence)layers) || group.indexOf("undefined") != -1 || layers.indexOf("undefined") != -1) continue;
                List<CloudQueryItemSj> cloudQueryItems = this.cloudQueryItemSjService.getUserCloudQueryItems(userId, wkt, group, layers);
                ArrayList serviceList = new ArrayList();
                if (!CollectionUtils.isEmpty(cloudQueryItems) && !CollectionUtils.isEmpty(services = cloudQueryItems.stream().map(item -> {
                    HashMap<String, String> service = new HashMap<String, String>();
                    service.put("serviceId", item.getServiceid());
                    service.put("serviceName", item.getServicename());
                    service.put("groupType", item.getGrouptype());
                    return service;
                }).collect(Collectors.toList()))) {
                    serviceList.addAll(services);
                    serviceRuleList.addAll(services);
                }
                jsonObject.put("serviceList", serviceList);
                String uniqueTaskId = this.cloudQueryHttpUtil.sendProvincialCloudQuery(jsonObject);
                if (StringUtils.isBlank((CharSequence)uniqueTaskId)) {
                    throw new RuntimeException("\u8c03\u7528\u4e91\u67e5\u8be2\u670d\u52a1\u5931\u8d25\uff01");
                }
                CloudQueryRecord cloudQueryRecord = CloudQueryRecord.builder().cloudId(uniqueTaskId).requestId(requestId).userId(userId).param(jsonObject.toJSONString()).status(0).updateTime(new Date()).type(2).wkt(wkt).lon((Double)wktMap.get("lon")).lat((Double)wktMap.get("lat")).area((Double)wktMap.get("mj")).tag(group).name(poiName).address(address).queryTime(new Date()).build();
                if (param.isRule() && i == size - 1) {
                    jsonObject.put("serviceList", serviceRuleList);
                    String ruleUniqueTaskId = this.cloudQueryHttpUtil.sendProvincialCloudRule(jsonObject);
                    cloudQueryRecord.setCloudRuleId(ruleUniqueTaskId);
                }
                this.cloudQueryRecordService.saveRecord(cloudQueryRecord);
            }
        }
        return requestId;
    }

    @Override
    public JSONObject sendAppCloudQuery(AppCloudQueryParam appCloudQueryParam) throws Exception {
        CloudQueryParam queryParam = (CloudQueryParam)new Gson().fromJson(appCloudQueryParam.getParam(), CloudQueryParam.class);
        String userId = this.tokenService.queryCurrentSysUserId();
        Map<String, Object> wktMap = this.buildGeometryParams(queryParam.getRange());
        CloudQuery cloudQuery = this.sendCloudQuery(wktMap, queryParam.getRange(), queryParam.getWidth(), queryParam.getHeight(), appCloudQueryParam.getCloudTag(), userId, queryParam.getAnalyzetype(), appCloudQueryParam.getRequestId());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("xzqdm", (Object)cloudQuery.getXzqdm());
        jsonObject.put("name", (Object)cloudQuery.getName());
        jsonObject.put("id", (Object)cloudQuery.getId());
        jsonObject.put("requestid", (Object)cloudQuery.getRequestId());
        return jsonObject;
    }

    @Override
    public String getResultDetailUrl(String requestId, String type) throws Exception {
        String userId = this.tokenService.queryCurrentSysUserId();
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)userId), (String)"\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u767b\u5f55\u4fe1\u606f\uff01");
        List<CloudQueryItem> cloudQueryItems = this.cloudQueryItemService.getUserCloudQueryItems(userId, null, null, null, null);
        if (StringUtils.equals((CharSequence)type, (CharSequence)"1")) {
            cloudQueryItems.forEach(cloudQueryItem -> {
                if (!StringUtils.equals((CharSequence)cloudQueryItem.getTag(), (CharSequence)"\u57fa\u7840\u67e5\u8be2")) {
                    cloudQueryItem.setTag("\u9ad8\u7ea7\u67e5\u8be2");
                }
            });
        } else {
            cloudQueryItems.forEach(cloudQueryItem -> cloudQueryItem.setTag("\u4e91\u67e5\u8be2"));
        }
        List<CloudQuery> cloudQueries = this.cloudQueryService.listByRequestId(requestId);
        if (CollectionUtils.isEmpty(cloudQueries)) {
            throw new RuntimeException("\u4e91\u67e5\u8be2\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01");
        }
        JSONObject detail = new JSONObject();
        for (CloudQuery cloudQuery : cloudQueries) {
            JSONObject jsonObject = this.cloudQueryHttpUtil.getCloudQueryResultDetail(cloudQuery.getId());
            try {
                detail.putAll((Map)jsonObject);
            }
            catch (Exception exception) {
                log.error("\u89e3\u6790\u4e91\u67e5\u8be2\u7ed3\u679c\u8be6\u60c5\u5931\u8d25\uff01", (Throwable)exception);
            }
        }
        JSONObject data = new JSONObject();
        data.put("area", (Object)cloudQueries.get(0).getArea());
        data.put("name", (Object)cloudQueries.get(0).getName());
        data.put("queryTime", (Object)cloudQueries.get(0).getQuerytime());
        detail.put("data", (Object)data);
        return this.cloudQueryHttpUtil.getCloudQueryResultUrl(requestId, JSONObject.toJSONString(cloudQueryItems), detail.toJSONString());
    }

    @Override
    public List<CloudQueryNode> getCloudQueryItem(Integer displaySet) throws Exception {
        String userId = this.tokenService.queryCurrentSysUserId();
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)userId), (String)"\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u767b\u5f55\u4fe1\u606f\uff01");
        List<CloudQueryItem> cloudQueryItems = this.cloudQueryItemService.getUserCloudQueryItems(userId, null, null, null, displaySet == null ? 8 : displaySet);
        if (CollectionUtils.isEmpty(cloudQueryItems)) {
            throw new RuntimeException("\u4e91\u67e5\u8be2\u9879\u4e0d\u5b58\u5728\uff01");
        }
        Map<String, List<CloudQueryItem>> groups = cloudQueryItems.stream().collect(Collectors.groupingBy(CloudQueryItem::getNodeid));
        ArrayList<CloudQueryNode> results = new ArrayList<CloudQueryNode>();
        List nodes = this.cloudQueryNodeService.listByIds(new ArrayList<String>(groups.keySet()));
        groups.forEach((nodeId, items) -> nodes.stream().filter(node -> node.getId().equals(nodeId)).findFirst().ifPresent(node -> {
            node.setItems((List<CloudQueryItem>)items);
            results.add((CloudQueryNode)node);
        }));
        return results;
    }

    private CloudQuery sendCloudQuery(Map<String, Object> params, String wkt, Integer width, Integer height, String tag, String userId, String analyzeType, String requestId) throws FactoryException, TransformException, ParseException {
        MapUtil.builder(params).put((Object)"width", (Object)width).put((Object)"height", (Object)height).put((Object)"analyzetype", (Object)analyzeType).put((Object)"options", (Object)3).build();
        String paramJson = JSONObject.toJSONString(params);
        JSONObject responseData = this.cloudQueryHttpUtil.sendCloudQuery(userId, paramJson, requestId, null, tag);
        if (MapUtil.isEmpty((Map)responseData)) {
            throw new RuntimeException("\u4e91\u67e5\u8be2\u5931\u8d25\uff01");
        }
        CloudQuery cloudQuery = CloudQuery.builder().requestId(requestId).id(MapUtil.getStr((Map)responseData, (Object)"id")).wkt(wkt).nodeId(this.cloudQueryConfigService.getNodeId()).isCollect(0).isDeleted(0).tag(tag).mark(0).param(paramJson).userId(userId).querytime(new Date()).type(1).area(MapUtil.getDouble((Map)responseData, (Object)"area")).lon(MapUtil.getDouble(params, (Object)"lon")).lat(MapUtil.getDouble(params, (Object)"lat")).weight(100).state(CloudQueryState.REQUESTED.code).build();
        this.cloudQueryService.save(cloudQuery);
        return cloudQuery;
    }

    private Map<String, Object> buildGeometryParams(String wkt) throws ParseException, FactoryException, TransformException {
        Double area;
        String range;
        Geometry geometry = GeometryUtils.wktToGeometry((String)wkt, (Integer)GeometryUtils.GEOMETRY_SRID);
        ShapeType shapeType = GeometryUtils.getShapeTypeByWkt((String)wkt);
        if (shapeType == ShapeType.POINT) {
            range = wkt;
            area = this.cloudQueryService.calculateArea(GeometryUtils.geometryToWkt((Geometry)geometry));
            if (area != null) {
                area = area / 666.7;
            }
        } else if (shapeType == ShapeType.LINE_STRING || shapeType == ShapeType.MULTI_LINE_STRING) {
            geometry = geometry.buffer(GeometryUtils.DEFAULT_BUFFER.doubleValue());
            range = GeometryUtils.geometryToWkt((Geometry)geometry);
            area = geometry.getArea() / 666.7;
        } else {
            range = wkt;
            Geometry newGeometry = GeometryUtils.transform((Geometry)geometry);
            area = newGeometry.getArea() / 666.7;
        }
        return MapUtil.builder((Object)"range", (Object)range).put((Object)"mj", (Object)area).put((Object)"lon", (Object)geometry.getCentroid().getX()).put((Object)"lat", (Object)geometry.getCentroid().getY()).build();
    }

    @Override
    @Transactional
    public Map<String, Integer> getRecordStateByRequestIds(final String requestId) throws Exception {
        Integer success = 0;
        Integer total = 0;
        List<CloudQueryRecord> cloudQueries = this.cloudQueryRecordService.selectALLCloudQueryByRequestId(requestId);
        total = cloudQueries.size();
        for (CloudQueryRecord unFinshed : cloudQueries) {
            if (unFinshed == null) continue;
            if (unFinshed.getStatus() == null || unFinshed.getStatus() == 0) {
                Map<String, Integer> result = null;
                if (unFinshed.getType() == BizEnum.SJ.value) {
                    result = this.provincialCloudQueryService.getRecordStateByRequestIds((List<String>)new ArrayList<String>(){
                        {
                            this.add(requestId);
                        }
                    });
                } else if (unFinshed.getType() == BizEnum.GJ.value) {
                    result = this.nationalCloudQueryService.getRecordStateByRequestIds((List<String>)new ArrayList<String>(){
                        {
                            this.add(requestId);
                        }
                    });
                }
                if (result == null) continue;
                for (Integer state : result.values()) {
                    if (state != 1) continue;
                    Integer n = success;
                    Integer n2 = success = Integer.valueOf(success + 1);
                }
                continue;
            }
            Integer n = success;
            success = success + 1;
            Integer n3 = success;
        }
        final Integer successCount = success;
        final Integer totalCount = total;
        return new HashMap<String, Integer>(){
            {
                this.put("totalCount", totalCount);
                this.put("successCount", successCount);
            }
        };
    }
}

