/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.fzxz.scheduler;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.geoway.ns.geoserver3.dto.TbAnalysisTask;
import com.geoway.ns.geoserver3.service.IGeoserver3TaskService;
import com.geoway.ns.smart.fzxz.entity.FzxzTask;
import com.geoway.ns.smart.fzxz.service.FzxzTaskService;
import com.geoway.ns.sys.utils.TenantUserUtil;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class FzxzTaskScheduler {
    @Value(value="${smart.fzxz.syncTask:false}")
    private Boolean syncTask;
    @Value(value="${smart.fzxz.taskTimeout:30}")
    private double taskTimeout;
    @Autowired
    private IGeoserver3TaskService geoserver3TaskService;
    @Autowired
    private FzxzTaskService fzxzTaskService;
    @Autowired
    private TenantUserUtil tenantUserUtil;

    @Scheduled(cron="${cloud.query.cron:0/3 * * * * ?}")
    public void pollingTask() {
        if (!this.syncTask.booleanValue()) {
            return;
        }
        this.tenantUserUtil.userManage();
        this.syncTaskStatus();
    }

    public void syncTaskStatus() {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery(FzxzTask.class).eq(FzxzTask::getStatus, (Object)0);
        List lstTasks = this.fzxzTaskService.list((Wrapper)queryWrapper);
        if (lstTasks == null || lstTasks.isEmpty()) {
            return;
        }
        List lstGeoserver3TaskIds = lstTasks.stream().map(FzxzTask::getId).collect(Collectors.toList());
        List lstTbAnalysisTasks = this.geoserver3TaskService.findTaskByIds(lstGeoserver3TaskIds);
        for (FzxzTask fzxzTask : lstTasks) {
            Optional<TbAnalysisTask> optionalTbAnalysisTask = lstTbAnalysisTasks.stream().filter(p -> Objects.equals(fzxzTask.getId(), p.getId())).findFirst();
            if (optionalTbAnalysisTask == null || !optionalTbAnalysisTask.isPresent()) {
                fzxzTask.setStatus(-1);
                fzxzTask.setMessage("\u672a\u67e5\u8be2\u5230\u5f15\u64ce\u4e2d\u5bf9\u5e94\u4efb\u52a1");
                continue;
            }
            TbAnalysisTask tbAnalysisTask = optionalTbAnalysisTask.get();
            if (tbAnalysisTask.getStatus() == 200) {
                fzxzTask.setStatus(1);
                fzxzTask.setMessage(tbAnalysisTask.getMsg());
                fzxzTask.setCost(this.getCost(fzxzTask.getCreateTime(), new Date()));
                continue;
            }
            if (tbAnalysisTask.getStatus() == 500) {
                fzxzTask.setStatus(-1);
                fzxzTask.setMessage(tbAnalysisTask.getMsg());
                fzxzTask.setCost(this.getCost(fzxzTask.getCreateTime(), new Date()));
                continue;
            }
            double cost = this.getCost(fzxzTask.getCreateTime(), new Date());
            fzxzTask.setCost(cost);
            if (!(cost > this.taskTimeout * 60.0)) continue;
            fzxzTask.setStatus(-1);
            fzxzTask.setMessage("\u7b49\u5f85\u7ed3\u679c\u8d85\u65f6\uff01");
        }
        this.fzxzTaskService.saveOrUpdateBatch(lstTasks);
    }

    private double getCost(Date start, Date end) {
        if (start == null || end == null) {
            return 0.0;
        }
        double e = (double)end.getTime() / 1000.0;
        double s = (double)start.getTime() / 1000.0;
        double res = e - s;
        return BigDecimal.valueOf(res).setScale(2, 1).doubleValue();
    }
}

