/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.ydsphlpd.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.geoway.ns.smart.ydsphlpd.dto.TbYdsphTaskFilterDTO;
import com.geoway.ns.smart.ydsphlpd.entity.TbYdsphlpdTask;
import com.geoway.ns.smart.ydsphlpd.service.TbYdsphlpdTaskService;
import com.geoway.ns.sys.dto.RestResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u7528\u5730\u5ba1\u6279\u5408\u7406\u5224\u5b9a\u76f8\u5173\u63a5\u53e3"})
@RestController
@CrossOrigin
@RequestMapping(value={"/smart/ydsphlpd"})
public class YdsphlpdController {
    @Autowired
    private TbYdsphlpdTaskService tbYdsphlpdTaskService;

    @ApiOperation(value="1.\u521b\u5efa\u4efb\u52a1")
    @RequestMapping(value={"/task/create"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public TbYdsphlpdTask createTask(@RequestPart(value="txt") MultipartFile txt, @RequestPart(value="shp") MultipartFile shp) throws Exception {
        return this.tbYdsphlpdTaskService.createTask(txt, shp);
    }

    @ApiOperation(value="2.\u4efb\u52a1\u5206\u9875\u67e5\u8be2")
    @RequestMapping(value={"/task/page"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public RestResult<IPage<TbYdsphlpdTask>> queryUpdateContent(@RequestBody TbYdsphTaskFilterDTO filter) throws Exception {
        return RestResult.success(this.tbYdsphlpdTaskService.pageTask(filter));
    }

    @ApiOperation(value="3.\u67e5\u8be2\u4efb\u52a1\u8be6\u60c5")
    @RequestMapping(value={"/task/detail"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public RestResult<TbYdsphlpdTask> taskDetail(@RequestParam String taskId) throws Exception {
        return RestResult.success((Object)this.tbYdsphlpdTaskService.taskDetail(taskId));
    }

    @ApiOperation(value="4.\u542f\u52a8\u4efb\u52a1\uff08\u652f\u6301\u5355\u4e2a\u548c\u6279\u91cf\uff09")
    @RequestMapping(value={"/task/start"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public RestResult<String> startTask(String taskIds) throws Exception {
        List<String> lstTaskIds = Arrays.stream(taskIds.split(",")).collect(Collectors.toList());
        this.tbYdsphlpdTaskService.startTask(lstTaskIds);
        return RestResult.success((Object)"\u542f\u52a8\u6210\u529f");
    }

    @ApiOperation(value="5.\u5220\u9664\u4efb\u52a1\uff08\u652f\u6301\u5355\u4e2a\u548c\u6279\u91cf\uff09")
    @RequestMapping(value={"/task/delete"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public RestResult<String> deleteTask(String taskIds) throws Exception {
        List<String> lstTaskIds = Arrays.stream(taskIds.split(",")).collect(Collectors.toList());
        this.tbYdsphlpdTaskService.deleteTask(lstTaskIds);
        return RestResult.success((Object)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="6.\u4e0b\u8f7d\u9879\u76ee\u8303\u56f4\uff1atxt\u8f6c\u77e2\u91cf\u540e\uff08\u652f\u6301\u5355\u4e2a\u548c\u6279\u91cf\uff09")
    @RequestMapping(value={"/task/txt2Shp"}, method={RequestMethod.POST})
    @ResponseBody
    public void txt2Shp(HttpServletRequest request, HttpServletResponse response, String taskIds) throws Exception {
        List<String> lstTaskIds = Arrays.stream(taskIds.split(",")).collect(Collectors.toList());
        this.tbYdsphlpdTaskService.txt2Shp(response, lstTaskIds);
    }
}

