/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.znts.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.ns.base.enums.ShapeType;
import com.geoway.ns.base.util.GeometryUtils;
import com.geoway.ns.smart.znts.entity.CloudQuery;
import com.geoway.ns.smart.znts.mapper.CloudQueryMapper;
import com.geoway.ns.smart.znts.service.CloudQueryService;
import com.geoway.ns.smart.znts.util.CloudQueryHttpUtil;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import java.util.List;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.TransformException;
import org.springframework.stereotype.Service;

@Service
public class CloudQueryServiceImpl
extends ServiceImpl<CloudQueryMapper, CloudQuery>
implements CloudQueryService {
    private static final Logger log = LogManager.getLogger(CloudQueryServiceImpl.class);
    @Resource
    private CloudQueryHttpUtil cloudQueryHttpUtil;

    @Override
    public Double calculateArea(String wkt) {
        Geometry geometry;
        ShapeType shapeType = GeometryUtils.getShapeTypeByWkt((String)wkt);
        if (shapeType == ShapeType.POINT) {
            return ((CloudQueryMapper)this.baseMapper).calculateArea(wkt);
        }
        try {
            geometry = GeometryUtils.wktToGeometry((String)wkt, (Integer)GeometryUtils.GEOMETRY_SRID);
        }
        catch (ParseException exception) {
            log.error("\u89e3\u6790wkt\u5931\u8d25\uff01", (Throwable)exception);
            return 0.0;
        }
        if (shapeType == ShapeType.LINE_STRING || shapeType == ShapeType.MULTI_LINE_STRING) {
            geometry = geometry.buffer(GeometryUtils.DEFAULT_BUFFER.doubleValue());
            return geometry.getArea();
        }
        try {
            Geometry newGeometry = GeometryUtils.transform((Geometry)geometry);
            return newGeometry.getArea();
        }
        catch (FactoryException | TransformException exception) {
            log.error("\u5750\u6807\u7cfb\u8f6c\u6362\u5931\u8d25\uff01", exception);
            return 0.0;
        }
    }

    @Override
    public List<CloudQuery> listByRequestId(String requestId) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CloudQuery::getRequestId, (Object)requestId)).orderByAsc(CloudQuery::getQuerytime)).list();
    }

    @Override
    public JSONArray getCloudQueryDbUrl(String cloudids) {
        String[] ids;
        JSONArray jsonArray = new JSONArray();
        for (String cloudid : ids = cloudids.split(",")) {
            JSONObject jsonObject = new JSONObject();
            String dbUrl = this.cloudQueryHttpUtil.getCloudQueryDbUrl(cloudid);
            jsonObject.put("id", (Object)cloudid);
            jsonObject.put("dburl", (Object)dbUrl);
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray;
    }
}

