/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.znts.service.impl;

import cn.afterturn.easypoi.cache.WordCache;
import cn.afterturn.easypoi.cache.manager.FileLoaderImpl;
import cn.afterturn.easypoi.entity.ImageEntity;
import cn.afterturn.easypoi.word.WordExportUtil;
import cn.afterturn.easypoi.word.entity.MyXWPFDocument;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.ns.smart.znts.dto.CloudQueryDTO;
import com.geoway.ns.smart.znts.entity.CloudQueryItemSj;
import com.geoway.ns.smart.znts.service.IExportCloudDOCService;
import com.geoway.ns.smart.znts.util.WordParagraphHolder;
import com.geoway.ns.sys.dto.FileServerResponse;
import com.geoway.ns.sys.service.FileServerService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFPictureData;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBody;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ExportCloudDOCServiceImpl
implements IExportCloudDOCService {
    @Value(value="${project.workDir:''}")
    protected String tempDir;
    @Resource
    private FileServerService fileServerService;

    @Override
    public String getCloudComplianceReports(CloudQueryDTO baseInfo, List<CloudQueryItemSj> sjMetas, JSONObject cloudqueryResult) throws Exception {
        File parentDir;
        SimpleDateFormat format = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        String fileName = baseInfo.getUnionnames() + "\u4e91\u5206\u6790\u62a5\u544a-" + format.format(new Date()) + ".docx";
        String path = "cloudCompliance/" + fileName;
        String result = "";
        if (!StringUtils.isEmpty((CharSequence)result)) {
            return result;
        }
        Map<String, Object> data = this.getFormatReportsData(baseInfo, sjMetas, cloudqueryResult);
        String url = "templates/cloudCompliance.docx";
        String tmpPath = this.tempDir + File.separator + "temp" + File.separator + "cloudCompliance" + File.separator + fileName;
        File file = new File(tmpPath);
        if (!file.exists() && !(parentDir = new File(file.getParent())).exists()) {
            parentDir.mkdirs();
        }
        MyXWPFDocument first = WordCache.getXWPFDocument((String)url);
        WordParagraphHolder test = new WordParagraphHolder((XWPFDocument)first, tmpPath, data);
        test.execute();
        if (this.fileServerService.findDefault() != null) {
            FileServerResponse result2 = this.fileServerService.sendFileToServer(file, "", false);
            return result2.getPath();
        }
        return path;
    }

    @Override
    public String getCloudComplianceReportsMerge(CloudQueryDTO baseInfo, List<CloudQueryItemSj> sjMetas, JSONObject cloudqueryResult) throws Exception {
        File parentDir;
        SimpleDateFormat format = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        String path = "cloudCompliance/" + baseInfo.getUnionnames() + "\u4e91\u5206\u6790\u62a5\u544a-" + format.format(new Date()) + ".docx";
        String result = "";
        if (!StringUtils.isEmpty((CharSequence)result)) {
            return result;
        }
        Map<String, Object> data = this.getFormatReportsData(baseInfo, sjMetas, cloudqueryResult);
        ArrayList<XWPFDocument> wordList = new ArrayList<XWPFDocument>();
        String url = "templates/cloudComplianceMerge.docx";
        XWPFDocument xwpfDocument = WordExportUtil.exportWord07((String)url, data);
        wordList.add(xwpfDocument);
        String mergeDir = "templates/cloudComplianceMerge";
        URL fileis = FileLoaderImpl.class.getClassLoader().getResource(mergeDir);
        File dirs = new File(fileis.getFile());
        for (File file : dirs.listFiles()) {
            XWPFDocument xwpfDocumentMerge = WordExportUtil.exportWord07((String)fileis.getPath(), data);
            wordList.add(xwpfDocumentMerge);
        }
        XWPFDocument xwpfDocumentAll = this.mergeWord(wordList);
        String tmpPath = this.tempDir + File.separator + "temp" + File.separator + "cloudComplianceMerge" + File.separator + baseInfo.getUnionnames() + "\u4e91\u5206\u6790\u62a5\u544a-" + format.format(new Date()) + ".docx";
        File file = new File(tmpPath);
        if (!file.exists() && !(parentDir = new File(file.getParent())).exists()) {
            parentDir.mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(tmpPath);
        xwpfDocumentAll.write((OutputStream)fos);
        fos.close();
        xwpfDocumentAll.close();
        FileServerResponse result2 = this.fileServerService.sendFileToServer(file, "", false);
        return result2.getPath();
    }

    private static int docxImageType(File image) throws IOException {
        String ext;
        switch (ext = image.getName().split("\\.")[1]) {
            case "png": {
                return 6;
            }
            case "jpeg": 
            case "jpg": {
                return 5;
            }
        }
        throw new IllegalArgumentException("Unsupported image type: " + ext);
    }

    public Map<String, Object> getFormatReportsData(CloudQueryDTO baseInfo, List<CloudQueryItemSj> sjMetas, JSONObject cloudquerySJResult) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Class<?> clazz = baseInfo.getClass();
        Field[] fields = clazz.getDeclaredFields();
        for (Field field : fields) {
            field.setAccessible(true);
            result.put(field.getName(), field.get(baseInfo));
        }
        for (String key : cloudquerySJResult.keySet()) {
            JSONObject serviceGroupInfo = cloudquerySJResult.getJSONObject(key);
            for (String srvGroupKey : serviceGroupInfo.keySet()) {
                JSONObject serviceInfo = serviceGroupInfo.getJSONObject(srvGroupKey);
                for (String srvKey : serviceInfo.keySet()) {
                    if (serviceInfo.get((Object)srvKey) instanceof String) {
                        result.put(srvGroupKey + "_" + srvKey, serviceInfo.getString(srvKey));
                        continue;
                    }
                    if (serviceInfo.get((Object)srvKey) instanceof JSONObject && srvKey.equalsIgnoreCase("imgString")) {
                        JSONObject imgString = serviceInfo.getJSONObject(srvKey);
                        String imageData = imgString.getString("imgData");
                        if (StringUtils.isEmpty((CharSequence)imageData)) continue;
                        if (imageData.contains("data:image/png;base64,")) {
                            imageData = imageData.replace("data:image/png;base64,", "");
                        }
                        if (imageData.contains("data:image/jpg;base64,")) {
                            imageData = imageData.replace("data:image/jpg;base64,", "");
                        }
                        byte[] imageBytes = Base64.getDecoder().decode(imageData);
                        ImageEntity image = new ImageEntity(imageBytes, 250, 250);
                        result.put(srvGroupKey + "_" + srvKey, image);
                        continue;
                    }
                    if (!(serviceInfo.get((Object)srvKey) instanceof JSONArray) || !srvKey.equalsIgnoreCase("Results")) continue;
                    JSONArray results = serviceInfo.getJSONArray(srvKey);
                    result.put(srvGroupKey + "_" + srvKey, results);
                    String ServiceId = serviceInfo.getString("ServiceId");
                    CloudQueryItemSj filterGroupMetas = sjMetas.stream().filter(t -> t.getServiceid().equalsIgnoreCase(ServiceId)).findFirst().orElse(null);
                    List<JSONObject> statisticResults = this.statisticByChartInfo(filterGroupMetas, results);
                    result.put(srvGroupKey + "_statis" + srvKey, statisticResults);
                }
            }
        }
        result.put("&NULL&", null);
        result.put("username", "\u6c5f\u6bc5");
        result.put("datenow", new Date());
        return result;
    }

    private List<JSONObject> statisticByChartInfo(CloudQueryItemSj filterGroupMetas, JSONArray dataLists) {
        if (dataLists == null || filterGroupMetas == null || dataLists.size() == 0) {
            return null;
        }
        String chatDataConf = filterGroupMetas.getChartdata();
        if (StringUtils.isNotEmpty((CharSequence)chatDataConf)) {
            JSONObject chatDataJSON = JSONObject.parseObject((String)chatDataConf);
            if (chatDataJSON == null) {
                return null;
            }
            final JSONObject StatTableConfig = chatDataJSON.getJSONObject("StatTableConfig");
            if (StatTableConfig == null) {
                return null;
            }
            JSONArray mergeColumns = null;
            mergeColumns = StatTableConfig.get((Object)"mergeColumn") instanceof JSONArray ? StatTableConfig.getJSONArray("mergeColumn") : new JSONArray(){
                {
                    this.add(StatTableConfig.getString("mergeColumn"));
                }
            };
            JSONArray statFields = null;
            statFields = StatTableConfig.get((Object)"statField") instanceof JSONArray ? StatTableConfig.getJSONArray("statField") : new JSONArray(){
                {
                    this.add(StatTableConfig.getString("statField"));
                }
            };
            if (mergeColumns == null || mergeColumns.size() == 0 || statFields == null || statFields.size() == 0) {
                return null;
            }
            HashMap<String, JSONObject> results = new HashMap<String, JSONObject>();
            for (int i = 0; i < dataLists.size(); ++i) {
                Double statCloumnValue;
                String statCloumn;
                int j;
                JSONObject statisItem = new JSONObject();
                JSONObject item = dataLists.getJSONObject(i);
                String mergeKey = "";
                for (j = 0; j < mergeColumns.size(); ++j) {
                    String mergeCloumn = mergeColumns.getString(j);
                    String mergeCloumnValue = item.getString(mergeCloumn);
                    statisItem.put(mergeCloumn, (Object)mergeCloumnValue);
                    mergeKey = mergeKey + "_" + mergeCloumnValue;
                }
                if (results.containsKey(mergeKey)) {
                    for (j = 0; j < statFields.size(); ++j) {
                        statCloumn = statFields.getString(j);
                        statCloumnValue = item.getDouble(statCloumn);
                        statisItem = (JSONObject)results.get(mergeKey);
                        Double newStatnValue = statisItem.getDouble(statCloumn) + statCloumnValue;
                        statisItem.put(statCloumn, (Object)newStatnValue);
                    }
                    continue;
                }
                for (j = 0; j < statFields.size(); ++j) {
                    statCloumn = statFields.getString(j);
                    statCloumnValue = item.getDouble(statCloumn);
                    statisItem.put(statCloumn, (Object)statCloumnValue);
                }
                results.put(mergeKey, statisItem);
            }
            return new ArrayList<JSONObject>(results.values());
        }
        return null;
    }

    private XWPFDocument mergeWord(List<XWPFDocument> wordList) throws Exception {
        if (CollectionUtils.isEmpty(wordList)) {
            throw new RuntimeException("\u5f85\u5408\u5e76\u7684word\u6587\u6863list\u4e3a\u7a7a");
        }
        XWPFDocument doc = wordList.get(0);
        int size = wordList.size();
        if (size > 1) {
            doc.createParagraph().setPageBreak(true);
            for (int i = 1; i < size; ++i) {
                XWPFDocument nextPageDoc = wordList.get(i);
                if (i != size - 1) {
                    nextPageDoc.createParagraph().setPageBreak(true);
                }
                this.appendBody(doc, nextPageDoc);
            }
        }
        return doc;
    }

    private void appendBody(XWPFDocument src, XWPFDocument append) throws Exception {
        CTBody src1Body = src.getDocument().getBody();
        CTBody src2Body = append.getDocument().getBody();
        List allPictures = append.getAllPictures();
        HashMap<String, String> map = new HashMap<String, String>();
        for (XWPFPictureData picture : allPictures) {
            String before = append.getRelationId((POIXMLDocumentPart)picture);
            String after = src.addPictureData(picture.getData(), 6);
            map.put(before, after);
        }
        this.appendBody(src1Body, src2Body, map);
    }

    private void appendBody(CTBody src, CTBody append, Map<String, String> map) throws Exception {
        XmlOptions optionsOuter = new XmlOptions();
        optionsOuter.setSaveOuter();
        String appendString = append.xmlText(optionsOuter);
        String srcString = src.xmlText();
        String prefix = srcString.substring(0, srcString.indexOf(">") + 1);
        String mainPart = srcString.substring(srcString.indexOf(">") + 1, srcString.lastIndexOf("<"));
        String sufix = srcString.substring(srcString.lastIndexOf("<"));
        String addPart = appendString.substring(appendString.indexOf(">") + 1, appendString.lastIndexOf("<"));
        if (map != null && !map.isEmpty()) {
            for (Map.Entry<String, String> set : map.entrySet()) {
                addPart = addPart.replace(set.getKey(), set.getValue());
            }
        }
        CTBody makeBody = CTBody.Factory.parse((String)(prefix + mainPart + addPart + sufix));
        src.set((XmlObject)makeBody);
    }

    @Override
    public void down(HttpServletResponse response, String fullpath, CloudQueryDTO baseInfo, String outFileName) {
        File targetFile = null;
        String dirPath = this.tempDir + File.separator + "temp" + File.separator + "cloudCompliance" + File.separator;
        File file = new File(dirPath);
        if (!file.exists()) {
            return;
        }
        if (baseInfo != null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
            String dateNow = format.format(new Date());
            final String fileNamePart = baseInfo.getUnionnames() + "\u4e91\u5206\u6790\u62a5\u544a-";
            FilenameFilter filenameFilter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(fileNamePart);
                }
            };
            File[] files = file.listFiles(filenameFilter);
            if (files != null && files.length > 0) {
                if (files.length == 0) {
                    targetFile = files[0];
                } else {
                    for (int i = 0; i < files.length; ++i) {
                        if (!files[i].exists() || !files[i].getName().contains(dateNow)) continue;
                        targetFile = files[i];
                    }
                }
            }
        } else if (StringUtils.isNotEmpty((CharSequence)fullpath)) {
            targetFile = new File(dirPath + fullpath);
        }
        if (targetFile == null || !targetFile.exists()) {
            return;
        }
        try {
            FileInputStream input = new FileInputStream(targetFile);
            byte[] fileStream = IOUtils.toByteArray((InputStream)input);
            ((InputStream)input).close();
            response.setContentType("application/octet-stream");
            response.setCharacterEncoding("utf-8");
            String attName = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{outFileName}) ? outFileName : targetFile.getName();
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(attName, "UTF-8"));
            ServletOutputStream myout = response.getOutputStream();
            myout.write(fileStream);
            myout.flush();
            myout.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

