/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.config;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.handlers.AbstractJsonTypeHandler;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;

@MappedTypes(value={List.class})
@MappedJdbcTypes(value={JdbcType.VARCHAR})
public abstract class JsonListTypeHandler<T>
extends AbstractJsonTypeHandler<List<T>> {
    private static ObjectMapper OBJECT_MAPPER;

    protected List<T> parse(String json) {
        try {
            if (StrUtil.isBlank((CharSequence)json)) {
                return new ArrayList();
            }
            return (List)JsonListTypeHandler.getObjectMapper().readValue(json, this.specificType());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String toJson(List<T> obj) {
        try {
            return JsonListTypeHandler.getObjectMapper().writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ObjectMapper getObjectMapper() {
        if (null == OBJECT_MAPPER) {
            OBJECT_MAPPER = new ObjectMapper();
        }
        return OBJECT_MAPPER;
    }

    protected abstract TypeReference<List<T>> specificType();
}

