/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.geoway.ns.sys.domain.FileServer;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.dto.FileDownloadMeta;
import com.geoway.ns.sys.dto.FilePart;
import com.geoway.ns.sys.dto.FileStoreMeta;
import com.geoway.ns.sys.dto.FileUploadResponse;
import com.geoway.ns.sys.dto.FileUploadTask;
import com.geoway.ns.sys.dto.UploadingFileInfo;
import com.geoway.ns.sys.service.HuWeiObsFileService;
import com.geoway.ns.sys.service.RedisLockService;
import com.geoway.ns.sys.utils.ObjectKeyUtil;
import com.google.gson.Gson;
import com.obs.services.ObsClient;
import com.obs.services.exception.ObsException;
import com.obs.services.model.AbortMultipartUploadRequest;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.CompleteMultipartUploadRequest;
import com.obs.services.model.CompleteMultipartUploadResult;
import com.obs.services.model.HeaderResponse;
import com.obs.services.model.InitiateMultipartUploadRequest;
import com.obs.services.model.InitiateMultipartUploadResult;
import com.obs.services.model.ListMultipartUploadsRequest;
import com.obs.services.model.ListPartsRequest;
import com.obs.services.model.ListPartsResult;
import com.obs.services.model.Multipart;
import com.obs.services.model.MultipartUpload;
import com.obs.services.model.MultipartUploadListing;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.ObsBucket;
import com.obs.services.model.ObsObject;
import com.obs.services.model.PartEtag;
import com.obs.services.model.StorageClassEnum;
import com.obs.services.model.TemporarySignatureRequest;
import com.obs.services.model.TemporarySignatureResponse;
import com.obs.services.model.UploadPartRequest;
import com.obs.services.model.UploadPartResult;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class HuweiObsFileServiceImpl
implements HuWeiObsFileService {
    private static final Logger log = LoggerFactory.getLogger(HuweiObsFileServiceImpl.class);
    @Value(value="${project.workDir:cache}")
    protected String workDir;
    @Autowired
    private RedisTemplate redisTemplate;
    private ObsClient _obsClient;
    private int _currentServerId = 0;
    @Autowired
    RedisLockService redisLockService;

    @Override
    public ObsClient getOssClient(FileServer fileServer) throws Exception {
        if (fileServer == null) {
            return null;
        }
        String preKey = "fileServer-";
        boolean hasExist = this.redisTemplate.hasKey((Object)(preKey + fileServer.getId()));
        this._obsClient = new ObsClient(fileServer.getAppkey(), fileServer.getAppsecret(), fileServer.getEndpoint());
        return this._obsClient;
    }

    @Override
    public FileStoreMeta sendFile(FileServer fileServer, MultipartFile file, String objectName) throws Exception {
        ObsClient obsClient;
        boolean isExists;
        FileStoreMeta fileStoreMeta = new FileStoreMeta();
        String fileName = file.getOriginalFilename();
        String fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
        String bucket = fileServer.getBucket();
        if (StrUtil.isBlank((CharSequence)objectName)) {
            objectName = ObjectKeyUtil.formatObjectName(fileName);
        }
        if (!(isExists = (obsClient = this.getOssClient(fileServer)).headBucket(bucket))) {
            this.createBucket(obsClient, bucket, null);
        }
        obsClient.putObject(bucket, objectName, file.getInputStream());
        String url = fileServer.getEndpoint() + "/" + bucket + "/" + objectName;
        ObjectMetadata objMeta = obsClient.getObjectMetadata(bucket, objectName);
        fileStoreMeta.setAbsolutePath(url);
        fileStoreMeta.setRelPath(objectName);
        fileStoreMeta.setName(fileName);
        fileStoreMeta.setFileType(fileType);
        fileStoreMeta.setFileSize(objMeta.getContentLength());
        obsClient.close();
        return fileStoreMeta;
    }

    @Override
    public FileStoreMeta sendFile(FileServer fileServer, String fileName, String objectName) throws Exception {
        ObsClient obsClient;
        boolean isExists;
        FileStoreMeta fileStoreMeta = new FileStoreMeta();
        File file = new File(fileName);
        String shortName = file.getName();
        String fileType = shortName.substring(shortName.lastIndexOf(".") + 1);
        String bucket = fileServer.getBucket();
        if (StrUtil.isBlank((CharSequence)objectName)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String foldName = simpleDateFormat.format(new Date());
            objectName = foldName + "/" + System.currentTimeMillis() + "/" + shortName;
        }
        if (!(isExists = (obsClient = this.getOssClient(fileServer)).headBucket(bucket))) {
            this.createBucket(obsClient, bucket, null);
        }
        obsClient.putObject(bucket, objectName, file);
        obsClient.close();
        String url = fileServer.getEndpoint() + "/" + bucket + "/" + objectName;
        fileStoreMeta.setAbsolutePath(url);
        fileStoreMeta.setRelPath(objectName);
        fileStoreMeta.setName(shortName);
        fileStoreMeta.setFileType(fileType);
        fileStoreMeta.setFileSize(file.length());
        return fileStoreMeta;
    }

    @Override
    public FileStoreMeta buildThumbnailFile(FileServer fileServer, String objectName) throws Exception {
        String[] videoTypes;
        boolean videoFlag;
        String[] officeTypes;
        boolean officeFlag;
        boolean pdfFlag;
        FileStoreMeta fileStoreMeta = new FileStoreMeta();
        String fileType = objectName.substring(objectName.lastIndexOf(".") + 1).toLowerCase();
        String minObjectName = objectName.replace("." + fileType, "-min." + fileType);
        String fileName = minObjectName.substring(minObjectName.lastIndexOf("/") + 1);
        String thuamailFilePath = this.workDir + "/" + minObjectName;
        File thuamailFile = new File(thuamailFilePath);
        File pFile = thuamailFile.getParentFile();
        if (!pFile.exists()) {
            pFile.mkdirs();
        }
        String bucket = fileServer.getBucket();
        ObsClient obsClient = this.getOssClient(fileServer);
        ObsObject obsObject = obsClient.getObject(bucket, objectName);
        InputStream inputStream = obsObject.getObjectContent();
        inputStream.mark(0);
        String[] photoTypes = new String[]{"png", "jpg", "jpeg", "bmp"};
        boolean photoflag = Arrays.stream(photoTypes).anyMatch(type -> type.equalsIgnoreCase(fileType));
        if (photoflag) {
            int height;
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            int width = bufferedImage.getWidth();
            int max = width > (height = bufferedImage.getHeight()) ? width : height;
            int w = 0;
            int h = 0;
            if (max <= 100) {
                w = width;
                h = height;
            } else {
                double scale = 100.0 / (double)max;
                w = (int)((double)width * scale);
                h = (int)((double)height * scale);
            }
            inputStream.reset();
            Thumbnails.of((InputStream[])new InputStream[]{inputStream}).size(w, h).toFile(thuamailFile);
            obsObject.getObjectContent().close();
            obsClient.putObject(bucket, minObjectName, thuamailFile);
            inputStream.close();
            String url = fileServer.getEndpoint() + "/" + bucket + "/" + minObjectName;
            fileStoreMeta.setAbsolutePath(url);
            fileStoreMeta.setRelPath(objectName);
            fileStoreMeta.setName(thuamailFile.getName());
            fileStoreMeta.setFileSize(thuamailFile.length());
            fileStoreMeta.setFileType(fileType);
        }
        if (pdfFlag = "pdf".equalsIgnoreCase(fileType)) {
            // empty if block
        }
        if (officeFlag = Arrays.stream(officeTypes = new String[]{"doc", "docx", "xls", "xlsx", "ppt", "pptx"}).anyMatch(type -> type.equalsIgnoreCase(fileType))) {
            // empty if block
        }
        if (videoFlag = Arrays.stream(videoTypes = new String[]{"mp4", "avi"}).anyMatch(type -> type.equalsIgnoreCase(fileType))) {
            // empty if block
        }
        return fileStoreMeta;
    }

    @Override
    public void deleteFile(FileServer fileServer, String bucket, String path) throws Exception {
        ObsClient obsClient = this.getOssClient(fileServer);
        obsClient.deleteObject(bucket, path);
    }

    @Override
    public String buildPreviewURL(FileServer fileServer, String objectName, Integer expires) throws Exception {
        ObsClient obsClient = this.getOssClient(fileServer);
        TemporarySignatureRequest request = new TemporarySignatureRequest();
        request.setBucketName(fileServer.getBucket());
        request.setObjectKey(objectName);
        request.setRequestDate(new Date());
        request.setExpires((long)expires.intValue());
        TemporarySignatureResponse signature = obsClient.createTemporarySignature(request);
        String url = signature.getSignedUrl();
        return url;
    }

    @Override
    public byte[] createThumbnail(FileServer fileServer, String objectName) throws Exception {
        String bucket = fileServer.getBucket();
        ObsClient obsClient = this.getOssClient(fileServer);
        ObsObject obsObject = obsClient.getObject(bucket, objectName);
        InputStream inputStream = obsObject.getObjectContent();
        inputStream.mark(0);
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        int max = width > height ? width : height;
        int w = 0;
        int h = 0;
        if (max <= 100) {
            w = width;
            h = height;
        } else {
            double scale = 100.0 / (double)max;
            w = (int)((double)width * scale);
            h = (int)((double)height * scale);
        }
        inputStream.reset();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Thumbnails.of((InputStream[])new InputStream[]{inputStream}).size(w, h).toOutputStream((OutputStream)out);
        inputStream.close();
        byte[] thumnailBytes = out.toByteArray();
        out.close();
        return thumnailBytes;
    }

    @Override
    public FileDownloadMeta downLoadFile(FileServer fileServer, String objectName) throws Exception {
        FileDownloadMeta fileDownloadMeta = new FileDownloadMeta();
        ObsClient obsClient = this.getOssClient(fileServer);
        ObjectMetadata objectMetadata = obsClient.getObjectMetadata(fileServer.getBucket(), objectName);
        fileDownloadMeta.setFileSize(objectMetadata.getContentLength());
        ObsObject obsObject = obsClient.getObject(fileServer.getBucket(), objectName);
        fileDownloadMeta.setInputStream(obsObject.getObjectContent());
        return fileDownloadMeta;
    }

    @Override
    public FileStoreMeta sendFile(FileServer fileServer, InputStream stream, String objectName, String contentType) throws Exception {
        FileStoreMeta fileStoreMeta = new FileStoreMeta();
        String bucket = fileServer.getBucket();
        String tempFileName = objectName;
        String fileType = null;
        ObsClient obsClient = this.getOssClient(fileServer);
        boolean isExists = obsClient.headBucket(bucket);
        if (!isExists) {
            this.createBucket(obsClient, bucket, null);
        }
        if (StrUtil.isBlank((CharSequence)objectName)) {
            fileType = ObjectKeyUtil.getFileSuffixByContentType(contentType);
            tempFileName = UUID.randomUUID().toString() + ObjectKeyUtil.getFileSuffixByContentType(contentType);
            objectName = ObjectKeyUtil.formatObjectName(tempFileName);
        }
        obsClient.putObject(bucket, objectName, stream);
        obsClient.close();
        String url = fileServer.getEndpoint() + "/" + bucket + "/" + objectName;
        fileStoreMeta.setAbsolutePath(url);
        fileStoreMeta.setRelPath(objectName);
        fileStoreMeta.setName(tempFileName);
        fileStoreMeta.setFileType(fileType);
        return fileStoreMeta;
    }

    @Override
    public UploadingFileInfo upLoadFileByChunk(FileServer fileServer, String code, String originalFileName, MultipartFile chunk, UploadingFileInfo uploadInfo, Boolean isParallel) throws Exception {
        UploadPartRequest request;
        if (uploadInfo == null) {
            uploadInfo = new UploadingFileInfo();
        }
        String bucketName = fileServer.getBucket();
        ObsClient obsClient = this.getOssClient(fileServer);
        String objectKey = uploadInfo.getObjectKey();
        if (StringUtils.isEmpty((CharSequence)objectKey)) {
            if (StringUtils.isEmpty((CharSequence)code) || StringUtils.isEmpty((CharSequence)originalFileName)) {
                throw new Exception("code\uff0coriginalFileName\u4e24\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (code.length() == 12) {
                objectKey = code.substring(0, 6) + "/" + code.substring(0, 9) + "/" + code;
            } else if (code.length() == 9) {
                objectKey = code.substring(0, 6) + "/" + code;
            } else if (code.length() == 6) {
                objectKey = code;
            }
            objectKey = objectKey + "/" + originalFileName;
            objectKey = "test/" + objectKey;
            uploadInfo.setObjectKey(objectKey);
        }
        String uploadId = uploadInfo.getUploadId();
        String md5 = uploadInfo.getMd5();
        if (StringUtils.isEmpty((CharSequence)uploadId)) {
            uploadId = this.getUploadIdFromDB(md5, originalFileName);
        }
        Integer chunkIndex = uploadInfo.getChunkIndex();
        if (StringUtils.isEmpty((CharSequence)uploadId) && this.redisLockService.lock("UploadingFilesMD5" + md5, chunkIndex + "", true, false)) {
            uploadId = this.getUploadIdFromDB(md5, originalFileName);
            if (StringUtils.isEmpty((CharSequence)uploadId)) {
                request = new InitiateMultipartUploadRequest(bucketName, objectKey);
                request.setAcl(AccessControlList.REST_CANNED_PUBLIC_READ);
                InitiateMultipartUploadResult result = obsClient.initiateMultipartUpload((InitiateMultipartUploadRequest)request);
                uploadId = result.getUploadId();
                uploadInfo.setUploadId(uploadId);
                this.redisTemplate.opsForHash().put((Object)"UploadingFilesMD5", (Object)(md5 + "=" + originalFileName), (Object)JSON.toJSONString((Object)uploadInfo));
            }
            uploadInfo.setUploadId(uploadId);
            this.redisLockService.unlock("UploadingFilesMD5" + md5, chunkIndex + "");
        }
        request = new UploadPartRequest(bucketName, objectKey);
        request.setUploadId(uploadId);
        request.setPartNumber(chunkIndex + 1);
        File tempFile = new File(chunk.getOriginalFilename());
        FileUtils.copyInputStreamToFile((InputStream)chunk.getInputStream(), (File)tempFile);
        request.setFile(tempFile);
        Long chunkSize = uploadInfo.getChunkSize();
        Integer chunkCount = uploadInfo.getChunkCount();
        Long fileSize = uploadInfo.getFileSize();
        long offset = (long)chunkIndex.intValue() * chunkSize;
        long currPartSize = chunkIndex + 1 == chunkCount ? fileSize - offset : chunkSize;
        request.setPartSize(Long.valueOf(currPartSize));
        UploadPartResult result = obsClient.uploadPart(request);
        if (result.getStatusCode() < 200 || result.getStatusCode() >= 300) {
            throw new Exception("\u4e0a\u4f20\u5931\u8d25\uff1a" + JSON.toJSONString((Object)result));
        }
        if (this.redisLockService.lock("UploadingFilesMD5" + md5, chunkIndex + "", true, false)) {
            String uploadInfoOldStr = (String)this.redisTemplate.opsForHash().get((Object)"UploadingFilesMD5", (Object)(md5 + "=" + originalFileName));
            List<Object> partEtags = null;
            List<Integer> chunkIndexs = null;
            if (StringUtils.isNotEmpty((CharSequence)uploadInfoOldStr)) {
                Gson gson = new Gson();
                UploadingFileInfo uploadInfoOld = (UploadingFileInfo)gson.fromJson(uploadInfoOldStr, UploadingFileInfo.class);
                partEtags = uploadInfoOld.getPartEtags();
                chunkIndexs = uploadInfoOld.getChunkIndexs();
            }
            if (partEtags == null) {
                partEtags = Collections.synchronizedList(new ArrayList());
            }
            partEtags.add(new PartEtag(result.getEtag(), Integer.valueOf(result.getPartNumber())));
            uploadInfo.setPartEtags(partEtags);
            if (isParallel.booleanValue()) {
                if (chunkIndexs == null) {
                    chunkIndexs = Collections.synchronizedList(new ArrayList());
                }
                chunkIndexs.add(chunkIndex);
                uploadInfo.setChunkIndexs(chunkIndexs);
            }
            this.redisTemplate.opsForHash().put((Object)"UploadingFilesMD5", (Object)(md5 + "=" + originalFileName), (Object)JSON.toJSONString((Object)uploadInfo));
            this.redisLockService.unlock("UploadingFilesMD5" + md5, chunkIndex + "");
        }
        return uploadInfo;
    }

    @Override
    public FileUploadResponse upLoadFileCompleteWithMerge(FileServer fileServer, UploadingFileInfo uploadInfo) throws Exception {
        String bucketName = fileServer.getBucket();
        ObsClient obsClient = this.getOssClient(fileServer);
        String objectKey = uploadInfo.getObjectKey();
        String uploadId = uploadInfo.getUploadId();
        List<Object> partEtagObjects = uploadInfo.getPartEtags();
        List partEtags = partEtagObjects.stream().map(obj -> (PartEtag)obj).collect(Collectors.toList());
        Gson gson = new Gson();
        partEtags = partEtags.stream().sorted(Comparator.comparing(PartEtag::getPartNumber)).collect(Collectors.toList());
        System.out.println(gson.toJson(partEtags));
        CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(bucketName, objectKey, uploadId, partEtags);
        CompleteMultipartUploadResult completeMultipartUploadResult = obsClient.completeMultipartUpload(completeMultipartUploadRequest);
        if (completeMultipartUploadResult.getStatusCode() < 200 || completeMultipartUploadResult.getStatusCode() >= 300) {
            throw new Exception("\u4e0a\u4f20\u5931\u8d25\uff1a" + JSON.toJSONString((Object)completeMultipartUploadResult));
        }
        return FileUploadResponse.builder().absolutePath(completeMultipartUploadResult.getObjectUrl()).relativePath(completeMultipartUploadResult.getBucketName() + "@" + completeMultipartUploadResult.getObjectKey()).objectUrl(completeMultipartUploadResult.getObjectUrl()).build();
    }

    @Override
    public List<FilePart> listUpLoadFileParts(FileServer fileServer, UploadingFileInfo uploadInfo) throws Exception {
        String bucketName = fileServer.getBucket();
        ObsClient obsClient = this.getOssClient(fileServer);
        String objectKey = uploadInfo.getObjectKey();
        String uploadId = uploadInfo.getUploadId();
        ListPartsRequest request = new ListPartsRequest(bucketName, objectKey);
        request.setUploadId(uploadId);
        ListPartsResult result = obsClient.listParts(request);
        if (result.getStatusCode() < 200 || result.getStatusCode() >= 300) {
            throw new Exception("\u4e0a\u4f20\u5931\u8d25\uff1a" + JSON.toJSONString((Object)result));
        }
        ArrayList<FilePart> fileParts = new ArrayList<FilePart>();
        for (Multipart part : result.getMultipartList()) {
            FilePart filePart = new FilePart();
            BeanUtils.copyProperties((Object)part, (Object)filePart);
            fileParts.add(filePart);
        }
        System.out.println("listParts successfully");
        return fileParts;
    }

    @Override
    public List<FileUploadTask> listUpLoadFileTasks(FileServer fileServer) throws Exception {
        ListMultipartUploadsRequest request;
        String bucketName = fileServer.getBucket();
        ObsClient obsClient = this.getOssClient(fileServer);
        MultipartUploadListing result = obsClient.listMultipartUploads(request = new ListMultipartUploadsRequest(bucketName));
        if (result.getStatusCode() < 200 || result.getStatusCode() >= 300) {
            throw new Exception("\u4e0a\u4f20\u5931\u8d25\uff1a" + JSON.toJSONString((Object)result));
        }
        ArrayList<FileUploadTask> fileParts = new ArrayList<FileUploadTask>();
        for (MultipartUpload upload : result.getMultipartTaskList()) {
            FileUploadTask fileUploadTask = new FileUploadTask();
            BeanUtils.copyProperties((Object)upload, (Object)fileUploadTask);
            fileParts.add(fileUploadTask);
        }
        return fileParts;
    }

    @Override
    public BaseResponse abortMultipartUpload(FileServer fileServer, UploadingFileInfo uploadInfo) {
        try {
            String bucketName = fileServer.getBucket();
            ObsClient obsClient = this.getOssClient(fileServer);
            String objectKey = uploadInfo.getObjectKey();
            String uploadId = uploadInfo.getUploadId();
            AbortMultipartUploadRequest request = new AbortMultipartUploadRequest(bucketName, objectKey, uploadId);
            HeaderResponse headerResponse = obsClient.abortMultipartUpload(request);
            System.out.println("AbortMultipartUpload successfully");
            if (headerResponse.getStatusCode() >= 200 && headerResponse.getStatusCode() < 300) {
                return BaseResponse.success("\u53d6\u6d88\u5206\u6bb5\u4e0a\u4f20\u4efb\u52a1\u6210\u529f");
            }
            return BaseResponse.buildFailuaResponse("\u53d6\u6d88\u5206\u6bb5\u4e0a\u4f20\u4efb\u52a1\u5931\u8d25", headerResponse.getStatusCode());
        }
        catch (ObsException e) {
            System.out.println("AbortMultipartUpload failed");
            System.out.println("HTTP Code:" + e.getResponseCode());
            System.out.println("Error Code:" + e.getErrorCode());
            System.out.println("Error Message:" + e.getErrorMessage());
            System.out.println("Request ID:" + e.getErrorRequestId());
            System.out.println("Host ID:" + e.getErrorHostId());
            e.printStackTrace();
            return BaseResponse.buildFailuaResponse("\u53d6\u6d88\u5206\u6bb5\u4e0a\u4f20\u4efb\u52a1\u5931\u8d25:" + e.getErrorMessage());
        }
        catch (Exception e) {
            System.out.println("AbortMultipartUpload failed");
            e.printStackTrace();
            return BaseResponse.buildFailuaResponse("\u53d6\u6d88\u5206\u6bb5\u4e0a\u4f20\u4efb\u52a1\u5931\u8d25:" + e.getMessage());
        }
    }

    @Override
    public BaseResponse abortMultipartUpload(FileServer fileServer, String objectKey, String uploadId) {
        try {
            String bucketName = fileServer.getBucket();
            ObsClient obsClient = this.getOssClient(fileServer);
            AbortMultipartUploadRequest request = new AbortMultipartUploadRequest(bucketName, objectKey, uploadId);
            HeaderResponse headerResponse = obsClient.abortMultipartUpload(request);
            System.out.println("AbortMultipartUpload successfully");
            if (headerResponse.getStatusCode() >= 200 && headerResponse.getStatusCode() < 300) {
                return BaseResponse.success("\u53d6\u6d88\u5206\u6bb5\u4e0a\u4f20\u4efb\u52a1\u6210\u529f");
            }
            return BaseResponse.buildFailuaResponse("\u53d6\u6d88\u5206\u6bb5\u4e0a\u4f20\u4efb\u52a1\u5931\u8d25", headerResponse.getStatusCode());
        }
        catch (ObsException e) {
            System.out.println("AbortMultipartUpload failed");
            System.out.println("HTTP Code:" + e.getResponseCode());
            System.out.println("Error Code:" + e.getErrorCode());
            System.out.println("Error Message:" + e.getErrorMessage());
            System.out.println("Request ID:" + e.getErrorRequestId());
            System.out.println("Host ID:" + e.getErrorHostId());
            e.printStackTrace();
            return BaseResponse.buildFailuaResponse("\u53d6\u6d88\u5206\u6bb5\u4e0a\u4f20\u4efb\u52a1\u5931\u8d25:" + e.getErrorMessage());
        }
        catch (Exception e) {
            System.out.println("AbortMultipartUpload failed");
            e.printStackTrace();
            return BaseResponse.buildFailuaResponse("\u53d6\u6d88\u5206\u6bb5\u4e0a\u4f20\u4efb\u52a1\u5931\u8d25:" + e.getMessage());
        }
    }

    @Override
    public FileStoreMeta sendObject2OssByMultiPart(FileServer fileServer, final File file, String objectName) throws Exception {
        ObsClient obsClient;
        boolean isExists;
        FileStoreMeta fileStoreMeta = new FileStoreMeta();
        String shortName = file.getName();
        String fileType = shortName.substring(shortName.lastIndexOf(".") + 1);
        final String bucket = fileServer.getBucket();
        if (StrUtil.isBlank((CharSequence)objectName)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String foldName = simpleDateFormat.format(new Date());
            objectName = foldName + "/" + System.currentTimeMillis() + "/" + shortName;
        }
        if (!(isExists = (obsClient = this.getOssClient(fileServer)).headBucket(bucket))) {
            this.createBucket(obsClient, bucket, null);
        }
        InitiateMultipartUploadRequest request = new InitiateMultipartUploadRequest(bucket, objectName);
        request.setAcl(AccessControlList.REST_CANNED_PUBLIC_READ);
        final InitiateMultipartUploadResult result = obsClient.initiateMultipartUpload(request);
        String url = "";
        try {
            long partSize = 0x3200000L;
            long fileSize = file.length();
            long partCount = fileSize % partSize == 0L ? fileSize / partSize : fileSize / partSize + 1L;
            final List partEtags = Collections.synchronizedList(new ArrayList());
            ExecutorService executorService = Executors.newFixedThreadPool(20);
            final String finalobjectName = objectName;
            int i = 0;
            while ((long)i < partCount) {
                final long offset = (long)i * partSize;
                final long currPartSize = (long)(i + 1) == partCount ? fileSize - offset : partSize;
                final int partNumber = i + 1;
                executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        UploadPartRequest uploadPartRequest = new UploadPartRequest();
                        uploadPartRequest.setBucketName(bucket);
                        uploadPartRequest.setObjectKey(finalobjectName);
                        uploadPartRequest.setUploadId(result.getUploadId());
                        uploadPartRequest.setFile(file);
                        uploadPartRequest.setPartSize(Long.valueOf(currPartSize));
                        uploadPartRequest.setOffset(offset);
                        uploadPartRequest.setPartNumber(partNumber);
                        try {
                            UploadPartResult uploadPartResult = obsClient.uploadPart(uploadPartRequest);
                            partEtags.add(new PartEtag(uploadPartResult.getEtag(), Integer.valueOf(uploadPartResult.getPartNumber())));
                        }
                        catch (ObsException e) {
                            e.printStackTrace();
                        }
                    }
                });
                ++i;
            }
            executorService.shutdown();
            while (!executorService.isTerminated()) {
                try {
                    executorService.awaitTermination(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(bucket, objectName, result.getUploadId(), partEtags);
            obsClient.completeMultipartUpload(completeMultipartUploadRequest);
            obsClient.close();
            url = fileServer.getEndpoint() + "/" + bucket + "/" + objectName;
            fileStoreMeta.setAbsolutePath(url);
            fileStoreMeta.setRelPath(objectName);
            fileStoreMeta.setName(shortName);
            fileStoreMeta.setFileType(fileType);
            fileStoreMeta.setFileSize(file.length());
            fileStoreMeta.setUploadId(result.getUploadId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileStoreMeta;
    }

    private void createBucket(ObsClient obsClient, String bucketName, String location) {
        ObsBucket obsBucket = new ObsBucket();
        obsBucket.setBucketName(bucketName);
        obsBucket.setAcl(AccessControlList.REST_CANNED_PUBLIC_READ);
        obsBucket.setBucketStorageClass(StorageClassEnum.STANDARD);
        if (StrUtil.isNotBlank((CharSequence)location)) {
            obsBucket.setLocation(location);
        }
        obsClient.createBucket(obsBucket);
        String json = "{\"Statement\":[{\"Sid\":\"\u4e3a\u6388\u6743\u7528\u6237\u521b\u5efaOBS\u4f7f\u7528\u7684\u6876\u7b56\u7565\",\"Principal\":{\"ID\" : \"*\"},\"Effect\":\"Allow\",\"Action\":[\"GetObject\",\"GetObjectVersion\"],\"Resource\": [\"" + bucketName + "/*\"]}]}";
        obsClient.setBucketPolicy(bucketName, json);
    }

    private String getUploadIdFromDB(String md5, String originalFileName) {
        String uploadInfoOldStr = (String)this.redisTemplate.opsForHash().get((Object)"UploadingFilesMD5", (Object)(md5 + "=" + originalFileName));
        if (StringUtils.isNotEmpty((CharSequence)uploadInfoOldStr)) {
            Gson gson = new Gson();
            UploadingFileInfo uploadInfoOld = (UploadingFileInfo)gson.fromJson(uploadInfoOldStr, UploadingFileInfo.class);
            return uploadInfoOld.getUploadId();
        }
        return null;
    }
}

