/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.geoway.ns.sys.controller.BaseController;
import com.geoway.ns.sys.domain.SysPower;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.dto.DataResponse;
import com.geoway.ns.sys.dto.RowsResponse;
import com.geoway.ns.sys.dto.SimpleRole;
import com.geoway.ns.sys.dto.SysUserDTO;
import com.geoway.ns.sys.enums.SysPowerEnum;
import com.geoway.ns.sys.service.SysPowerService;
import com.geoway.ns.sys.utils.MyRequestUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6743\u9650\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/powerSys"})
public class SysPowerController
extends BaseController<SysPower, SysPowerService> {
    @Autowired
    private SysPowerService sysPowerService;

    public SysPowerController(SysPowerService service) {
        super(service, new SysPower());
    }

    @RequestMapping(value={"/selectAll"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="1-\u67e5\u8be2\u6240\u6709")
    public DataResponse<List<SysPower>> selectAll(@RequestParam(value="type") String type, @RequestParam(value="relationtype") String relationtype, @RequestParam(value="relationid") String relationid, @RequestParam(value="name", required=false) @Nullable String name) {
        return DataResponse.success(this.sysPowerService.search(name, type, relationtype, relationid));
    }

    @RequestMapping(value={"/listPage"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="2-\u5206\u9875\u67e5\u8be2")
    public BaseResponse listPage(@RequestParam(value="pageIndex", defaultValue="1", required=false) Integer pageIndex, @RequestParam(value="size", defaultValue="10", required=false) Integer size, @RequestParam(value="type") String type, @RequestParam(value="relationtype") String relationtype, @RequestParam(value="relationid") String relationid, @RequestParam(value="name", required=false) @Nullable String name) {
        RowsResponse response = new RowsResponse();
        try {
            IPage<SysPower> resultPage = this.sysPowerService.queryPageByFilter(pageIndex, size, type, name, relationtype, relationid);
            response.setRows(resultPage.getRecords());
            response.setTotal(resultPage.getTotal());
        }
        catch (Exception ex) {
            response.markFailure();
            response.setMessage(ex.getMessage());
        }
        return response;
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="4-\u4fdd\u5b58\uff08\u65b0\u589e\u548c\u4fee\u6539\u90fd\u7528\u8be5\u63a5\u53e3\uff09")
    public BaseResponse add(SysPower sysPower) {
        return DataResponse.success(this.sysPowerService.addOrUpdate(sysPower));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="5-\u901a\u8fc7ID\u5220\u9664")
    public BaseResponse delete(@RequestParam(value="id") Long id) {
        boolean res = this.sysPowerService.deleteById(id);
        return res ? BaseResponse.success() : BaseResponse.error("\u5220\u9664\u5931\u8d25");
    }

    @RequestMapping(value={"/deleteMulti"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="6-\u6279\u91cf\u5220\u9664")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u5217\u8868\uff0c\u591a\u4e2aid\u7528\u82f1\u6587\u9017\u53f7\u9694\u5f00", required=true, dataTypeClass=String.class)})
    public BaseResponse deleteMulti(@RequestParam(value="ids") String ids) {
        boolean res = this.sysPowerService.deleteMulti(ids);
        return res ? BaseResponse.success() : BaseResponse.error("\u5220\u9664\u5931\u8d25");
    }

    @RequestMapping(value={"/selectByToken"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="7-\u67e5\u8be2\u7528\u6237\u5df2\u6388\u6743\u5217\u8868")
    public BaseResponse selectByToken(HttpServletRequest request, @RequestParam(value="type") String type) throws Exception {
        String token = MyRequestUtil.queryAccessTokenInHeader(request);
        SysUserDTO sysUser = this.tokenService.querySysUserByToken(token);
        if (sysUser == null) {
            return DataResponse.error("\u7cfb\u7edf\u672a\u767b\u5165");
        }
        return DataResponse.success(this.sysPowerService.selectByToken(type, sysUser.getRoles().stream().map(SimpleRole::getId).map(String::valueOf).collect(Collectors.toList()), sysUser.getId()));
    }

    @ApiOperation(value="8-\u9274\u6743")
    @GetMapping(value={"/verify"})
    public BaseResponse verify(HttpServletRequest request, @RequestParam String mandateId) throws Exception {
        String token = MyRequestUtil.queryAccessTokenInHeader(request);
        SysUserDTO sysUser = this.tokenService.querySysUserByToken(token);
        if (sysUser == null) {
            return DataResponse.error("\u7cfb\u7edf\u672a\u767b\u5165");
        }
        String relationIds = sysUser.getRoles().stream().map(SimpleRole::getId).map(String::valueOf).collect(Collectors.joining(",")) + "," + sysUser.getId();
        ((SysPowerService)this.service).verify(mandateId, relationIds);
        return DataResponse.success("\u5177\u5907\u6743\u9650\uff01");
    }

    @RequestMapping(value={"/listPageByUnauthorized"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="9-\u83b7\u53d6\u672a\u6388\u6743\u5217\u8868")
    public BaseResponse listPageByUnauthorized(@RequestParam(value="pageIndex", defaultValue="1", required=false) Integer pageIndex, @RequestParam(value="size", defaultValue="10", required=false) Integer size, @RequestParam(value="type") String type, @RequestParam(value="relationtype") String relationtype, @RequestParam(value="relationid") String relationid, @RequestParam(value="name", required=false) @Nullable String name) {
        RowsResponse<Map<String, Object>> response = new RowsResponse<Map<String, Object>>();
        SysPowerEnum sysPowerEnum = SysPowerEnum.valueOf(type);
        switch (sysPowerEnum) {
            case GZT: {
                List<Map<String, Object>> gztList = this.sysPowerService.unauthorizedByGZT(relationtype, relationid, name);
                response.setRows(gztList.subList((pageIndex - 1) * size, pageIndex * size > gztList.size() ? gztList.size() : pageIndex * size));
                response.setTotal(Long.valueOf(gztList.size()));
                return response;
            }
            case CJZX: {
                List<Map<String, Object>> cjzxList = this.sysPowerService.unauthorizedByCJZX(relationtype, relationid, name);
                response.setRows(cjzxList.subList((pageIndex - 1) * size, pageIndex * size > cjzxList.size() ? cjzxList.size() : pageIndex * size));
                response.setTotal(Long.valueOf(cjzxList.size()));
                return response;
            }
        }
        return DataResponse.error(type + " \u7c7b\u578b\uff0c\u4e0d\u5b58\u5728\uff01");
    }
}

