/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.utils;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import com.geoway.ns.sys.dto.FileStructureDTO;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class FileUploadUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUploadUtil.class);
    @Value(value="${project.uploadDir:cache}")
    protected String uploadDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadInputStream2Browser(HttpServletResponse response, InputStream inputStream, String fileName, long fileSize) throws Exception {
        ServletOutputStream servletOutputStream = null;
        try {
            response.reset();
            response.addHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            response.addHeader("Content-Length", "" + fileSize);
            servletOutputStream = response.getOutputStream();
            response.setContentType("application/octet-stream");
            byte[] buffer = new byte[65536];
            int len = 0;
            while ((len = inputStream.read(buffer)) != -1) {
                servletOutputStream.write(buffer, 0, len);
            }
            servletOutputStream.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (servletOutputStream != null) {
                servletOutputStream.close();
            }
        }
    }

    public File multipartFile2File(MultipartFile multipartFile) throws IOException {
        String fileName = multipartFile.getOriginalFilename();
        String suffix = fileName.substring(fileName.lastIndexOf("."));
        File file = Paths.get(this.uploadDir, IdUtil.simpleUUID() + suffix).toFile().getAbsoluteFile();
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        multipartFile.transferTo(file);
        return file;
    }

    public void readFile(String filePath, List<FileStructureDTO> fileStructureDTOS, String pid, Integer deep) {
        File[] files;
        File file = new File(filePath);
        if (file.exists() && ObjectUtil.isNotNull((Object)(files = file.listFiles()))) {
            List fileList = CollectionUtil.reverse(Arrays.asList(files));
            for (File f : fileList) {
                FileStructureDTO fileStructureDTO = FileStructureDTO.builder().fileName(f.getName()).id(IdUtil.simpleUUID()).pid(pid).createTime(System.currentTimeMillis()).deep(deep).build();
                if (f.isDirectory()) {
                    fileStructureDTO.setFileType(0);
                    fileStructureDTOS.add(fileStructureDTO);
                    Integer n = deep;
                    Integer n2 = deep = Integer.valueOf(deep + 1);
                    this.readFile(f.getAbsolutePath(), fileStructureDTOS, fileStructureDTO.getId(), deep);
                    continue;
                }
                fileStructureDTO.setFileType(1);
                fileStructureDTOS.add(fileStructureDTO);
            }
        }
    }

    public String getUploadDir() {
        return this.uploadDir;
    }

    public void setUploadDir(String uploadDir) {
        this.uploadDir = uploadDir;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileUploadUtil)) {
            return false;
        }
        FileUploadUtil other = (FileUploadUtil)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$uploadDir = this.getUploadDir();
        String other$uploadDir = other.getUploadDir();
        return !(this$uploadDir == null ? other$uploadDir != null : !this$uploadDir.equals(other$uploadDir));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileUploadUtil;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $uploadDir = this.getUploadDir();
        result = result * 59 + ($uploadDir == null ? 43 : $uploadDir.hashCode());
        return result;
    }

    public String toString() {
        return "FileUploadUtil(uploadDir=" + this.getUploadDir() + ")";
    }
}

