/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.exception;

import java.util.Arrays;

public class BaseException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private String module;
    private String code;
    private Object[] args;
    private String defaultMessage;

    public BaseException(String module, String code, Object[] args, String defaultMessage) {
        this.module = module;
        this.code = code;
        this.args = args;
        this.defaultMessage = defaultMessage;
    }

    public BaseException(String module, String code, Object[] args) {
        this(module, code, args, null);
    }

    public BaseException(String module, String defaultMessage) {
        this(module, null, null, defaultMessage);
    }

    public BaseException(String code, Object[] args) {
        this(null, code, args, null);
    }

    public BaseException(String defaultMessage) {
        this(null, null, null, defaultMessage);
    }

    @Override
    public String getMessage() {
        String message = null;
        if (message == null) {
            message = this.defaultMessage;
        }
        return message;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseException)) {
            return false;
        }
        BaseException other = (BaseException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$module = this.getModule();
        String other$module = other.getModule();
        if (this$module == null ? other$module != null : !this$module.equals(other$module)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getArgs(), other.getArgs())) {
            return false;
        }
        String this$defaultMessage = this.getDefaultMessage();
        String other$defaultMessage = other.getDefaultMessage();
        return !(this$defaultMessage == null ? other$defaultMessage != null : !this$defaultMessage.equals(other$defaultMessage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseException;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $module = this.getModule();
        result = result * 59 + ($module == null ? 43 : $module.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getArgs());
        String $defaultMessage = this.getDefaultMessage();
        result = result * 59 + ($defaultMessage == null ? 43 : $defaultMessage.hashCode());
        return result;
    }

    public String getModule() {
        return this.module;
    }

    public String getCode() {
        return this.code;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setArgs(Object[] args) {
        this.args = args;
    }

    public void setDefaultMessage(String defaultMessage) {
        this.defaultMessage = defaultMessage;
    }

    @Override
    public String toString() {
        return "BaseException(module=" + this.getModule() + ", code=" + this.getCode() + ", args=" + Arrays.deepToString(this.getArgs()) + ", defaultMessage=" + this.getDefaultMessage() + ")";
    }
}

