/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.interceptor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.geoway.adf.gis.basic.LicChecker;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.service.IUISConfigService;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.util.Oauth2Utils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class ApiPermissionInterceptorAdapter
extends HandlerInterceptorAdapter {
    Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    IUISConfigService uisConfigService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        try {
            LicChecker.check((int)LicChecker.EnumModule.modCore.value);
            LicChecker.check((int)LicChecker.EnumModule.modMIS.value);
            LicChecker.check((int)LicChecker.EnumModule.modGIS.value);
            LicChecker.check((int)65034);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\u7cfb\u7edf\u672a\u6388\u6743,\u670d\u52a1\u4e0d\u53ef\u7528");
            this.markInValidResponse(response);
            return false;
        }
        boolean ssoEnable = this.uisConfigService.isUISEnable();
        if (!ssoEnable) {
            System.out.println("\u672a\u542f\u7528\u5355\u70b9\u767b\u5f55\uff0c\u65e0\u9700\u6821\u9a8caccess_token****************************************");
            return super.preHandle(request, response, handler);
        }
        return super.preHandle(request, response, handler);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }

    public void afterConcurrentHandlingStarted(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
    }

    private void markLoginResponse(HttpServletResponse response) throws IOException {
        response.setStatus(HttpStatus.OK.value());
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Cache-Control", "no-cache, must-revalidate");
        BaseResponse baseResopnse = new BaseResponse();
        baseResopnse.markNoLogin();
        baseResopnse.setMessage("\u65e0\u6548token\u6216token\u5df2\u8fc7\u671f");
        String jsonResult = JSON.toJSONString((Object)baseResopnse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteNullStringAsEmpty});
        response.getWriter().write(jsonResult);
    }

    private void markInValidResponse(HttpServletResponse response) throws IOException {
        response.setStatus(HttpStatus.OK.value());
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Cache-Control", "no-cache, must-revalidate");
        BaseResponse baseResopnse = new BaseResponse();
        baseResopnse.markFailure();
        baseResopnse.setMessage("\u7cfb\u7edf\u672a\u6388\u6743\uff0c\u670d\u52a1\u4e0d\u53ef\u7528");
        String jsonResult = JSON.toJSONString((Object)baseResopnse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteNullStringAsEmpty});
        response.getWriter().write(jsonResult);
    }

    private Result<RpcAccessToken> queryAccessToken(String accessToken, HttpServletRequest request) {
        String serverUrl = this.uisConfigService.getUISURL();
        Result result = Oauth2Utils.queryAccessToken((String)serverUrl, (String)accessToken);
        if (result != null && result.isSuccess()) {
            this.setUserCacheByRpcToken((RpcAccessToken)result.getData());
        }
        return result;
    }

    private boolean refreshToken(String refreshToken) {
        String appId;
        String serverUrl = this.uisConfigService.getUISURL();
        Result result = Oauth2Utils.refreshToken((String)serverUrl, (String)(appId = this.uisConfigService.getAppkey()), (String)refreshToken);
        if (!result.isSuccess()) {
            this.logger.error("refreshToken has error, message:{}", (Object)result.getMessage());
            return false;
        }
        this.setUserCacheByRpcToken((RpcAccessToken)result.getData());
        return true;
    }

    private void setUserCacheByRpcToken(RpcAccessToken rpcAccessToken) {
        String token = rpcAccessToken.getAccessToken();
        String userId = rpcAccessToken.getUser().getId();
        String userName = rpcAccessToken.getUser().getUserName();
        this.setUserCache(token, userId, userName);
    }

    private void setUserCache(String token, String userId, String userName) {
        String key = "token:" + token;
        int ssoTimeout = this.uisConfigService.getTimeout();
        long currentTime = System.currentTimeMillis();
        long expireTime = currentTime + (long)(ssoTimeout * 60 * 60 * 1000);
        if (!StringUtils.isEmpty((Object)userId)) {
            String expireInfo = userId + ";" + userName + ";;" + expireTime;
            this.redisTemplate.opsForValue().set((Object)token, (Object)userId, (long)ssoTimeout, TimeUnit.SECONDS);
            this.redisTemplate.opsForValue().set((Object)key, (Object)expireInfo, (long)ssoTimeout, TimeUnit.SECONDS);
        }
    }

    private String queryAccessTokenInHeader(HttpServletRequest request) {
        String token = request.getHeader("access_token");
        if (StringUtils.isEmpty((Object)token)) {
            token = request.getHeader("access-token");
        }
        return token;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public RedisTemplate<String, String> getRedisTemplate() {
        return this.redisTemplate;
    }

    public IUISConfigService getUisConfigService() {
        return this.uisConfigService;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setRedisTemplate(RedisTemplate<String, String> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public void setUisConfigService(IUISConfigService uisConfigService) {
        this.uisConfigService = uisConfigService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiPermissionInterceptorAdapter)) {
            return false;
        }
        ApiPermissionInterceptorAdapter other = (ApiPermissionInterceptorAdapter)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Logger this$logger = this.getLogger();
        Logger other$logger = other.getLogger();
        if (this$logger == null ? other$logger != null : !this$logger.equals(other$logger)) {
            return false;
        }
        RedisTemplate<String, String> this$redisTemplate = this.getRedisTemplate();
        RedisTemplate<String, String> other$redisTemplate = other.getRedisTemplate();
        if (this$redisTemplate == null ? other$redisTemplate != null : !this$redisTemplate.equals(other$redisTemplate)) {
            return false;
        }
        IUISConfigService this$uisConfigService = this.getUisConfigService();
        IUISConfigService other$uisConfigService = other.getUisConfigService();
        return !(this$uisConfigService == null ? other$uisConfigService != null : !this$uisConfigService.equals(other$uisConfigService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApiPermissionInterceptorAdapter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Logger $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        RedisTemplate<String, String> $redisTemplate = this.getRedisTemplate();
        result = result * 59 + ($redisTemplate == null ? 43 : $redisTemplate.hashCode());
        IUISConfigService $uisConfigService = this.getUisConfigService();
        result = result * 59 + ($uisConfigService == null ? 43 : $uisConfigService.hashCode());
        return result;
    }

    public String toString() {
        return "ApiPermissionInterceptorAdapter(logger=" + this.getLogger() + ", redisTemplate=" + this.getRedisTemplate() + ", uisConfigService=" + this.getUisConfigService() + ")";
    }
}

