/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.ns.sys.dto.EsEntity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.GetMappingsRequest;
import org.elasticsearch.client.indices.GetMappingsResponse;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class EsUtils {
    private static final Logger log = LoggerFactory.getLogger(EsUtils.class);
    @Value(value="${es.host:''}")
    public String host;
    @Value(value="${es.port:''}")
    public String port;
    @Value(value="${es.scheme:''}")
    public String scheme;
    @Value(value="${es.index:''}")
    public String index;
    @Value(value="${logRecord:false}")
    public Boolean enabled;
    @Value(value="${es.enable:false}")
    public Boolean esEnabled;
    @Value(value="${es.username:''}")
    public String USERNAME;
    @Value(value="${es.password:''}")
    public String PASSWORD;
    public static final String CREATE_INDEX = "{\n    \"properties\": {\n      \"id\":{\n        \"type\":\"integer\"\n      },\n      \"userId\":{\n        \"type\":\"integer\"\n      },\n      \"name\":{\n        \"type\":\"text\",\n        \"analyzer\": \"ik_max_word\",\n        \"search_analyzer\": \"ik_smart\"\n      },\n      \"url\":{\n        \"type\":\"text\",\n        \"index\": true,\n        \"analyzer\": \"ik_max_word\",\n        \"search_analyzer\": \"ik_smart\"\n      }\n    }\n  }";
    public static RestHighLevelClient client = null;

    @PostConstruct
    public void initClient() {
        try {
            if (this.enabled.booleanValue() && this.esEnabled.booleanValue()) {
                if (client != null) {
                    client.close();
                }
                String[] ports = this.port.split(",");
                HttpHost[] httpHosts = new HttpHost[ports.length];
                for (int i = 0; i < ports.length; ++i) {
                    httpHosts[i] = new HttpHost(this.host, Integer.parseInt(ports[i]), this.scheme);
                }
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.USERNAME, this.PASSWORD));
                client = new RestHighLevelClient(RestClient.builder((HttpHost[])httpHosts).setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback((CredentialsProvider)credentialsProvider){
                    final /* synthetic */ CredentialsProvider val$credentialsProvider;
                    {
                        this.val$credentialsProvider = credentialsProvider;
                    }

                    public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                        httpClientBuilder.disableAuthCaching();
                        return httpClientBuilder.setDefaultCredentialsProvider(this.val$credentialsProvider);
                    }
                }).setRequestConfigCallback(new RestClientBuilder.RequestConfigCallback(){

                    public RequestConfig.Builder customizeRequestConfig(RequestConfig.Builder builder) {
                        return builder.setConnectTimeout(1800000).setSocketTimeout(1800000);
                    }
                }));
                log.info("{}:ElasticSearch\u7ec4\u4ef6\u52a0\u8f7d\u6210\u529f\uff01\u5f53\u524d\u9ed8\u8ba4\u7d22\u5f15\u4e3a\u3010" + this.index + "\u3011", (Object)new Date());
                this.initIndex();
            } else {
                log.info("{}:ElasticSearch\u7ec4\u4ef6\u672a\u542f\u7528\uff01", (Object)new Date());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void insertOrUpdateOne(String index, EsEntity entity) {
        IndexRequest request = new IndexRequest(index);
        request.id(entity.getId());
        request.source(JSON.toJSONString(entity.getData()), XContentType.JSON);
        try {
            client.index(request, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void insertBatch(String index, List<EsEntity> list) {
        BulkRequest request = new BulkRequest();
        String paramsFieldType = this.getFieldMappingType(index, "params");
        list.forEach(item -> {
            IndexRequest indexRequest = new IndexRequest(index);
            String data = (String)item.getData();
            Map map = (Map)JSON.parseObject((String)data, Map.class);
            if (map.containsKey("params")) {
                Object paramsValue = map.get("params");
                if ("text".equals(paramsFieldType) && (paramsValue instanceof Map || paramsValue instanceof List)) {
                    map.put("params", JSON.toJSONString(paramsValue));
                }
            }
            indexRequest.id();
            indexRequest.source(map);
            request.add(indexRequest);
        });
        try {
            BulkResponse bulkItemResponses = client.bulk(request, RequestOptions.DEFAULT);
            RestStatus restStatus = bulkItemResponses.status();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getFieldMappingType(String index, String field) {
        try {
            GetMappingsRequest request = new GetMappingsRequest();
            request.indices(new String[]{index});
            GetMappingsResponse response = client.indices().getMapping(request, RequestOptions.DEFAULT);
            Map mapping = ((MappingMetaData)response.mappings().get(index)).getSourceAsMap();
            Map properties = (Map)mapping.get("properties");
            if (properties != null && properties.containsKey(field)) {
                Map fieldProps = (Map)properties.get(field);
                return (String)fieldProps.get("type");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u67e5\u8be2\u5b57\u6bb5\u6620\u5c04\u5931\u8d25", e);
        }
        return null;
    }

    public <T> void deleteBatch(String index, Collection<T> idList) {
        BulkRequest request = new BulkRequest();
        idList.forEach(item -> request.add(new DeleteRequest(index, item.toString())));
        try {
            client.bulk(request, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> List<T> search(String index, SearchSourceBuilder builder, Class<T> c) {
        SearchRequest request = new SearchRequest(new String[]{index});
        request.source(builder);
        try {
            SearchResponse response = client.search(request, RequestOptions.DEFAULT);
            SearchHit[] hits = response.getHits().getHits();
            ArrayList<Object> res = new ArrayList<Object>(hits.length);
            for (SearchHit hit : hits) {
                res.add(JSON.parseObject((String)hit.getSourceAsString(), c));
            }
            return res;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteIndex(String index) {
        try {
            client.indices().delete(new DeleteIndexRequest(index), RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteByQuery(String index, QueryBuilder builder) {
        DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{index});
        request.setQuery(builder);
        request.setBatchSize(10000);
        request.setConflicts("proceed");
        try {
            client.deleteByQuery(request, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void initIndex() {
        try {
            if (this.indexExist(this.index)) {
                return;
            }
            CreateIndexRequest request = new CreateIndexRequest(this.index);
            request.settings(Settings.builder().put("index.number_of_shards", 3).put("index.number_of_replicas", 2));
            CreateIndexResponse res = client.indices().create(request, RequestOptions.DEFAULT);
            if (!res.isAcknowledged()) {
                throw new RuntimeException("\u521d\u59cb\u5316\u5931\u8d25");
            }
            log.info("\u7d22\u5f15\u3010" + this.index + "\u3011\u521d\u59cb\u5316\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    public boolean indexExist(String index) throws Exception {
        GetIndexRequest request = new GetIndexRequest(new String[]{index});
        request.local(false);
        request.humanReadable(true);
        request.includeDefaults(false);
        return client.indices().exists(request, RequestOptions.DEFAULT);
    }

    public List<JSONObject> search(String index, SearchSourceBuilder builder) {
        SearchRequest request = new SearchRequest(new String[]{index});
        request.source(builder);
        try {
            SearchResponse response = client.search(request, RequestOptions.DEFAULT);
            SearchHit[] hits = response.getHits().getHits();
            ArrayList<JSONObject> res = new ArrayList<JSONObject>(hits.length);
            for (SearchHit hit : hits) {
                JSONObject jsonObject = (JSONObject)JSON.parseObject((String)hit.getSourceAsString(), JSONObject.class);
                jsonObject.put("id", (Object)hit.getId());
                res.add(jsonObject);
            }
            return res;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteAll(String index, List<JSONObject> list) throws Exception {
        list.forEach(l -> {
            DeleteRequest request = new DeleteRequest(index);
            request.id(l.getString("id"));
            try {
                client.delete(request, RequestOptions.DEFAULT);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public void clearIndex() {
        try {
            DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{this.index});
            request.setQuery((QueryBuilder)QueryBuilders.matchAllQuery());
            BulkByScrollResponse res = client.deleteByQuery(request, RequestOptions.DEFAULT);
            log.info("\u6e05\u7406\u7d22\u5f15\u3010" + this.index + "\u3011\u4e0b\u6240\u6709\u6570\u636e");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

