/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.interceptor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.geoway.ns.sys.interceptor.RepeatSubmitInterceptor;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SameUrlDataInterceptor
extends RepeatSubmitInterceptor {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final ObjectWriter objectWriter = objectMapper.writerWithDefaultPrettyPrinter();
    public final String REPEAT_PARAMS = "repeatParams";
    public final String REPEAT_TIME = "repeatTime";
    public final String SESSION_REPEAT_KEY = "repeatData";
    private int intervalTime = 10;

    public void setIntervalTime(int intervalTime) {
        this.intervalTime = intervalTime;
    }

    @Override
    public boolean isRepeatSubmit(HttpServletRequest request) throws Exception {
        Map preDataMap;
        HashMap<String, HashMap<String, Object>> sessionMap;
        String nowParams = objectWriter.writeValueAsString((Object)request.getParameterMap());
        HashMap<String, Object> nowDataMap = new HashMap<String, Object>();
        nowDataMap.put("repeatParams", nowParams);
        nowDataMap.put("repeatTime", System.currentTimeMillis());
        String url = request.getRequestURI();
        HttpSession session = request.getSession();
        Object sessionObj = session.getAttribute("repeatData");
        if (sessionObj != null && (sessionMap = (HashMap<String, HashMap<String, Object>>)sessionObj).containsKey(url) && this.compareParams(nowDataMap, preDataMap = (Map)sessionMap.get(url)) && this.compareTime(nowDataMap, preDataMap)) {
            return true;
        }
        sessionMap = new HashMap<String, HashMap<String, Object>>();
        sessionMap.put(url, nowDataMap);
        session.setAttribute("repeatData", sessionMap);
        return false;
    }

    private boolean compareParams(Map<String, Object> nowMap, Map<String, Object> preMap) {
        String nowParams = (String)nowMap.get("repeatParams");
        String preParams = (String)preMap.get("repeatParams");
        return nowParams.equals(preParams);
    }

    private boolean compareTime(Map<String, Object> nowMap, Map<String, Object> preMap) {
        long time2;
        long time1 = (Long)nowMap.get("repeatTime");
        return time1 - (time2 = ((Long)preMap.get("repeatTime")).longValue()) < (long)(this.intervalTime * 1000);
    }
}

