/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class FileManageUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileContent(File file, String newstr) throws IOException {
        String charsetName = "UTF-8";
        Boolean bool = false;
        String filein = newstr;
        String temp = "";
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        FileOutputStream fos = null;
        PrintWriter pw = null;
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            fis = new FileInputStream(file);
            isr = new InputStreamReader((InputStream)fis, charsetName);
            br = new BufferedReader(isr);
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while ((temp = br.readLine()) != null) {
                buffer.append(temp);
                buffer = buffer.append(System.getProperty("line.separator"));
                ++i;
            }
            buffer.append(filein);
            fos = new FileOutputStream(file);
            pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)fos, charsetName)));
            pw.write(buffer.toString().toCharArray());
            pw.flush();
            bool = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (pw != null) {
                pw.close();
            }
            if (fos != null) {
                fos.close();
            }
            if (br != null) {
                br.close();
            }
            if (isr != null) {
                isr.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
        return bool;
    }

    public static String readFileContent(MultipartFile file) throws Exception {
        String encoding = "UTF-8";
        Long filelength = file.getSize();
        byte[] filecontent = new byte[filelength.intValue()];
        try {
            FileInputStream in = null;
            int openCount = 0;
            while (openCount < 6000 && in == null) {
                try {
                    in = (FileInputStream)file.getInputStream();
                }
                catch (Exception ex) {
                    ++openCount;
                    in = null;
                    Thread.sleep(10L);
                }
            }
            in.read(filecontent);
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            return new String(filecontent, encoding);
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("The OS does not support " + encoding);
            e.printStackTrace();
            return null;
        }
    }
}

