/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.support;

import java.time.Duration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;

public class CustomRedisCacheManager
extends RedisCacheManager {
    private static final Logger log = LoggerFactory.getLogger(CustomRedisCacheManager.class);

    public CustomRedisCacheManager(RedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration) {
        super(cacheWriter, defaultCacheConfiguration);
    }

    protected RedisCache createRedisCache(String name, RedisCacheConfiguration cacheConfig) {
        String[] SPEL;
        if (!name.isEmpty() && name.contains("#") && StringUtils.isNumeric((CharSequence)(SPEL = name.split("#"))[1])) {
            int cycle = Integer.parseInt(SPEL[1]);
            return super.createRedisCache(SPEL[0], cacheConfig.entryTtl(Duration.ofMinutes(cycle * 60)));
        }
        return super.createRedisCache(name, cacheConfig.entryTtl(Duration.ofDays(1L)));
    }
}

