/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.service;

import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RedisLockService {
    private final Long lockExpireTime = 60L;
    private static long timeout = 65000L;
    @Autowired
    RedisTemplate redisTemplate;

    public boolean lock(String key, String resourceId) throws Exception {
        return this.lock(key, resourceId, false, true);
    }

    public boolean lock(String key, String resourceOwner, boolean await, boolean throwException) throws Exception {
        System.out.println("lock\uff1a" + key + "\uff0cresourceOwner\uff1a" + resourceOwner);
        if (StringUtils.isEmpty((CharSequence)key) || StringUtils.isEmpty((CharSequence)resourceOwner)) {
            throw new RuntimeException("key\u3001resourceId\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Boolean aBoolean = this.redisTemplate.hasKey((Object)key);
        if (aBoolean.booleanValue()) {
            Object o = this.redisTemplate.opsForValue().get((Object)key);
            if (throwException) {
                if (resourceOwner.equals(o)) {
                    throw new RuntimeException("\u64cd\u4f5c\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                }
                throw new RuntimeException("\u6b63\u5728\u88ab\u5176\u4ed6\u7528\u6237\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            if (await) {
                return this._lock(key, resourceOwner);
            }
            return false;
        }
        aBoolean = this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)resourceOwner, this.lockExpireTime.longValue(), TimeUnit.SECONDS);
        if (!aBoolean.booleanValue()) {
            Object o = this.redisTemplate.opsForValue().get((Object)key);
            if (throwException) {
                if (resourceOwner.equals(o)) {
                    throw new RuntimeException("\u64cd\u4f5c\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                }
                throw new RuntimeException("\u6b63\u5728\u88ab\u5176\u4ed6\u7528\u6237\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            if (await) {
                return this._lock(key, resourceOwner);
            }
        }
        return aBoolean;
    }

    private boolean _lock(String key, String value) {
        Boolean absent;
        long start = System.currentTimeMillis();
        do {
            if (System.currentTimeMillis() - start > timeout) {
                System.out.println("lock\uff1a" + key + "\uff0cresourceOwner\uff1a" + value + ",await\u8d85\u65f6\uff1a" + (System.currentTimeMillis() - start));
                return false;
            }
            absent = this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value, this.lockExpireTime.longValue(), TimeUnit.SECONDS);
            System.out.println("\u83b7\u53d6\u9501lock\uff1a" + key + "\uff0cresourceOwner\uff1a" + value + ",doing\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        } while (!absent.booleanValue());
        System.out.println("lock\uff1a" + key + "\uff0cresourceOwner\uff1a" + value + ",await\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        return true;
    }

    public boolean unlock(String key, String resourceOwner) {
        long start = System.currentTimeMillis();
        Object o = this.redisTemplate.opsForValue().get((Object)key);
        if (!resourceOwner.equals(o)) {
            System.out.println("\u91ca\u653e\u9501\u9501\u5931\u8d25lock\uff1a" + key + "\uff0cresourceOwner\uff1a" + resourceOwner + ",doing\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
            return false;
        }
        System.out.println("\u91ca\u653e\u9501\u9501lock\uff1a" + key + "\uff0cresourceOwner\uff1a" + resourceOwner + ",doing\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        return this.redisTemplate.delete((Object)key);
    }
}

