/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.service.impl;

import com.geoway.ns.sys.mapper.AppCatalogRightMapper;
import com.geoway.ns.sys.service.RoleService;
import com.geoway.sso.client.client.RoleClient;
import com.geoway.sso.client.client.TenantClient;
import com.geoway.sso.client.rpc.RpcPage;
import com.geoway.sso.client.rpc.RpcSysRole;
import com.geoway.sso.client.rpc.RpcSysTenant;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RoleServiceImpl
implements RoleService {
    @Autowired
    private RoleClient roleClient;
    @Autowired
    private TenantClient tenantClient;
    @Resource
    private AppCatalogRightMapper appCatalogRightMapper;

    @Override
    public RpcPage<RpcSysRole> queryPage(Integer page, Integer size, String key) {
        RpcPage roles = this.roleClient.queryRolePage(key + ";type_EQ_1", page, size);
        return roles;
    }

    @Override
    public List<RpcSysRole> queryTree(String filterParam) {
        return this.roleClient.queryRoleTree(filterParam);
    }

    @Override
    public RpcPage<RpcSysRole> queryByCatalogId(Integer page, Integer size, String catalogId, String filterParam) {
        List<String> roleIds = this.appCatalogRightMapper.selectRoleIdsByCatalogId(catalogId);
        String queryRoleIds = roleIds.stream().collect(Collectors.joining(","));
        filterParam = filterParam + ";id_IN_" + queryRoleIds;
        return this.queryPage(page, size, filterParam);
    }

    @Override
    public RpcPage<RpcSysTenant> queryTenantRolePage(Integer page, Integer size, String filterParam) {
        RpcPage roles = this.tenantClient.queryTenantPage(filterParam, page, size);
        return roles;
    }
}

