/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.tenant.interceptor;

import com.geoway.adf.dms.config.dto.user.LoginUserInfo;
import com.geoway.adf.dms.config.service.LoginUserService;
import com.geoway.adf.dms.config.util.ThreadLocalUtil;
import com.geoway.ns.sys.annotation.WhiteRequest;
import com.geoway.ns.sys.config.CorsProperties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
@ConditionalOnProperty(name={"right.tenant-enabled"}, havingValue="true")
public class UserHandlerInterceptor
implements HandlerInterceptor {
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private CorsProperties corsProperties;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        HandlerMethod handlerMethod;
        WhiteRequest whitelist;
        String originHeader = request.getHeader("Origin");
        if (originHeader != null && (this.corsProperties.getOrigins().contains(originHeader) || this.corsProperties.getOrigins().contains("*"))) {
            response.setHeader("Access-Control-Allow-Origin", originHeader);
            response.setHeader("Access-Control-Allow-Credentials", String.valueOf(this.corsProperties.isCredentials()));
        }
        if ("OPTIONS".equalsIgnoreCase(request.getMethod())) {
            response.setHeader("Access-Control-Allow-Methods", this.corsProperties.getMethods());
            response.setHeader("Access-Control-Allow-Headers", this.corsProperties.getHeaders());
            response.setHeader("Access-Control-Max-Age", String.valueOf(this.corsProperties.getMaxAge()));
            response.setStatus(200);
            return false;
        }
        String requestURI = request.getRequestURI();
        if (handler instanceof HandlerMethod && (whitelist = (WhiteRequest)(handlerMethod = (HandlerMethod)handler).getMethodAnnotation(WhiteRequest.class)) != null) {
            return true;
        }
        LoginUserInfo userInfo = this.loginUserService.getUserInfo(request);
        if (userInfo == null) {
            response.setStatus(401);
            return false;
        }
        ThreadLocalUtil.addCurrentUser((LoginUserInfo)userInfo);
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        ThreadLocalUtil.removeUser();
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }
}

