/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.monitor.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.ns.monitor.constants.enums.AccessStatusType;
import com.geoway.ns.monitor.constants.enums.StatisticType;
import com.geoway.ns.monitor.constants.enums.StatisticUnit;
import com.geoway.ns.monitor.dto.echarts.EchartsResultDTO;
import com.geoway.ns.monitor.dto.result.AuthorizerResultDTO;
import com.geoway.ns.monitor.dto.result.LogInfoDTO;
import com.geoway.ns.monitor.dto.result.MonitorSearchDTO;
import com.geoway.ns.monitor.entity.ZyfxAccessStatistics;
import com.geoway.ns.monitor.mapper.ZyfxAccessStatisticsMapper;
import com.geoway.ns.monitor.service.ApiService;
import com.geoway.ns.monitor.service.AuthorizeTokenService;
import com.geoway.ns.monitor.service.ZyfxAccessStatisticsService;
import com.geoway.ns.monitor.utils.EsUtilMonitor;
import com.geoway.ns.proxy.constant.enums.AccessType;
import com.geoway.ns.proxy.constant.enums.ResponseExceptionType;
import com.geoway.ns.proxy.constant.enums.ServiceType;
import com.geoway.ns.sys.dto.SysUserDTO;
import com.geoway.ns.sys.service.ITokenService;
import com.geoway.ns.zyfx.domain.ZyfxObject;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class ZyfxAccessStatisticsServiceImpl
extends ServiceImpl<ZyfxAccessStatisticsMapper, ZyfxAccessStatistics>
implements ZyfxAccessStatisticsService {
    @Autowired
    private ZyfxAccessStatisticsMapper statisticsMapper;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private EsUtilMonitor esUtilMonitor;
    @Autowired
    private AuthorizeTokenService authorizeTokenService;
    @Autowired
    private ApiService apiService;
    @Resource
    private ITokenService tokenService;

    @Override
    public IPage<ZyfxAccessStatistics> queryServiceList(Integer page, Integer size, String name, Integer status, Integer resourceType, Long strTime, Long endTime) throws Exception {
        QueryWrapper wrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            List<String> rids = this.apiService.queryServiceIds(name);
            if (rids.size() > 0) {
                wrapper.in((Object)"f_resourceid", rids);
            } else {
                return new Page((long)page.intValue(), (long)size.intValue());
            }
        }
        if (ObjectUtil.isNotEmpty((Object)resourceType)) {
            wrapper.eq((Object)"f_resourcetype", (Object)resourceType);
        }
        if (status == AccessStatusType.SUCCESS.value) {
            wrapper.eq((Object)"f_exception", (Object)0);
        } else if (status == AccessStatusType.EXCEPTION.value) {
            wrapper.gt((Object)"f_exception", (Object)0);
        }
        if (strTime != null) {
            wrapper.between((Object)"f_accesstime", (Object)new Date(strTime), (Object)new Date(endTime));
            wrapper.eq((Object)"f_precision", (Object)StatisticUnit.DAY.value);
        } else {
            wrapper.eq((Object)"f_precision", (Object)StatisticUnit.ALL.value);
        }
        ((QueryWrapper)wrapper.groupBy((Object)"f_resourceid", (Object[])new String[]{"f_resourcetype"})).select(new String[]{"f_resourceid as resourceId", "sum(f_accesscount) as accessCount", "sum(f_exception) as exception", "sum(f_costtime) as costTime", "max(f_accesstime) as accessTime", "f_resourcetype as resourceType", "max(f_params) as params"}).orderByDesc((Object)"accessCount");
        IPage Pages = this.page((IPage)new Page((long)page.intValue(), (long)size.intValue()), (Wrapper)wrapper);
        List records = Pages.getRecords();
        Map<String, List> map = this.getException(records, null, 0);
        for (ZyfxAccessStatistics m : records) {
            m.setId(m.getResourceId());
            m.setExceptionList(map.get(m.getResourceId()));
            String resourceName = this.serviceNameManage(m.getResourceId(), (Integer)2);
            if (StringUtils.isBlank((CharSequence)resourceName) && StringUtils.isNotBlank((CharSequence)m.getParams())) {
                resourceName = JSONObject.parseObject((String)m.getParams()).getString("name");
            }
            m.setResourceName(resourceName);
            m.setServiceType(ServiceType.getByValue((int)m.getResourceType().intValue()).description);
            m.setCostTime(m.getCostTime() / (double)m.getAccessCount().longValue() * 1.0);
        }
        Pages.setRecords(records);
        return Pages;
    }

    @Override
    public IPage<AuthorizerResultDTO> queryUserList(Integer page, Integer size, String name, Integer status, Integer userType, Long strTime, Long endTime) throws Exception {
        Date strDate = null;
        Date endDate = null;
        Integer precision = StatisticUnit.ALL.value;
        if (strTime != null) {
            strDate = new Date(strTime);
            endDate = new Date(endTime);
            precision = StatisticUnit.DAY.value;
        }
        IPage<AuthorizerResultDTO> iPage = this.statisticsMapper.queryAuthorizerList((Page<AuthorizerResultDTO>)new Page((long)page.intValue(), (long)size.intValue()), name, status, strDate, endDate, userType, precision, null, null, null);
        List records = iPage.getRecords();
        records.forEach(record -> {
            record.setId(record.getAccessId());
            record.setRoll(StringUtils.isBlank((CharSequence)record.getRollId()) ? 0 : 1);
        });
        return iPage;
    }

    @Override
    public IPage<AuthorizerResultDTO> queryApplicationList(Integer page, Integer size, String name, Integer status, Long strTime, Long endTime) throws Exception {
        Date strDate = null;
        Date endDate = null;
        Integer precision = StatisticUnit.ALL.value;
        if (strTime != null) {
            strDate = new Date(strTime);
            endDate = new Date(endTime);
            precision = StatisticUnit.DAY.value;
        }
        IPage<AuthorizerResultDTO> iPage = this.statisticsMapper.queryApplicationAuthorizerList((Page<AuthorizerResultDTO>)new Page((long)page.intValue(), (long)size.intValue()), name, status, strDate, endDate, precision, null, null);
        List records = iPage.getRecords();
        records.forEach(record -> {
            record.setId(record.getAccessId());
            record.setRoll(StringUtils.isBlank((CharSequence)record.getRollId()) ? 0 : 1);
        });
        return iPage;
    }

    @Override
    public IPage queryAccessStatis(MonitorSearchDTO search) throws Exception {
        IPage Pages = new Page();
        if (StringUtils.isNotBlank((CharSequence)search.getId())) {
            if (search.getType() == StatisticType.ACCESS.value) {
                Date strDate = null;
                Date endDate = null;
                Integer precision = StatisticUnit.ALL.value;
                if (search.getStrTime() != null) {
                    strDate = new Date(search.getStrTime());
                    endDate = new Date(search.getEndTime());
                    precision = StatisticUnit.DAY.value;
                }
                Pages = this.statisticsMapper.queryAuthorizerList((Page<AuthorizerResultDTO>)new Page((long)search.getPage().intValue(), (long)search.getSize().intValue()), search.getName(), search.getStatus(), strDate, endDate, search.getSecType(), precision, search.getId(), search.getUserType(), null);
                List records = Pages.getRecords();
                Map<String, List> exceptionMap = this.getException(records, search.getId(), 1);
                records = records.stream().map(m -> {
                    AccessType accessType = AccessType.getByValue((int)m.getAuthorizerType());
                    m.setAuthorizerTypeAlias(accessType.description);
                    m.setExceptionList((List)exceptionMap.get(m.getAccessId()));
                    return m;
                }).collect(Collectors.toList());
                Pages.setRecords(records);
            } else {
                MPJLambdaWrapper queryWrapper = new MPJLambdaWrapper();
                ((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)queryWrapper.eq((Object)"f_accessid", (Object)search.getId())).eq((Object)"f_accesstype", (Object)search.getUserType())).groupBy((Object)"f_resourceid", (Object[])new String[]{"f_resourcetype"})).select(new String[]{"f_resourceid as resourceId", "f_resourcetype as resourceType", "sum(f_accesscount) as accessCount", "sum(f_exception) as exception", "sum(f_costtime) as costTime", "max(f_accesstime) as accessTime", "max(f_accesstype) as accessType", "max(f_accessid) as accessId", "max(f_params) as params", "max(f_name) as resourceName"})).orderByDesc((Object)"accessCount");
                queryWrapper.leftJoin(ZyfxObject.class, ZyfxObject::getId, ZyfxAccessStatistics::getResourceId);
                if (StringUtils.isNotBlank((CharSequence)search.getName())) {
                    List<String> rids = this.apiService.queryServiceIds(search.getName());
                    if (rids.size() > 0) {
                        queryWrapper.in((Object)"f_resourceid", rids);
                    } else {
                        return new Page((long)search.getPage().intValue(), (long)search.getSize().intValue());
                    }
                }
                if (ObjectUtil.isNotEmpty((Object)search.getSecType())) {
                    queryWrapper.eq((Object)"f_resourcetype", (Object)search.getSecType());
                }
                if (search.getStatus() != null && search.getStatus() == AccessStatusType.SUCCESS.value) {
                    queryWrapper.eq((Object)"f_exception", (Object)0);
                } else if (search.getStatus() != null) {
                    queryWrapper.gt((Object)"f_exception", (Object)0);
                }
                if (search.getStrTime() != null) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    queryWrapper.between((Object)"f_accesstime", (Object)new Date(search.getStrTime()), (Object)new Date(search.getEndTime()));
                    queryWrapper.eq((Object)"f_precision", (Object)StatisticUnit.DAY.value);
                } else {
                    queryWrapper.eq((Object)"f_precision", (Object)StatisticUnit.ALL.value);
                }
                Pages = this.page((IPage)new Page((long)search.getPage().intValue(), (long)search.getSize().intValue()), (Wrapper)queryWrapper);
                List records = Pages.getRecords();
                Map<String, List> exceptionMap = this.getException(records, search.getId(), 0);
                records.stream().map(m -> {
                    m.setExceptionList((List)exceptionMap.get(m.getResourceId()));
                    return m;
                }).collect(Collectors.toList());
                Pages.setRecords(this.nameManage(records));
            }
        }
        return Pages;
    }

    @Override
    public IPage queryAccessRecord(MonitorSearchDTO search) throws Exception {
        SearchSourceBuilder builder = new SearchSourceBuilder();
        BoolQueryBuilder query = QueryBuilders.boolQuery();
        if (search.getType() == StatisticType.ACCESS.value) {
            query.filter((QueryBuilder)QueryBuilders.matchQuery((String)"serviceId", (Object)search.getId()));
            query.filter((QueryBuilder)QueryBuilders.matchQuery((String)"userType", (Object)search.getUserType()));
            if (search.getSecType() != null) {
                query.filter((QueryBuilder)QueryBuilders.matchQuery((String)"serviceType", (Object)search.getSecType()));
            }
            if (StringUtils.isNotBlank((CharSequence)search.getCid())) {
                query.filter((QueryBuilder)QueryBuilders.matchQuery((String)"userId", (Object)search.getCid()));
            }
        } else {
            query.filter((QueryBuilder)QueryBuilders.matchQuery((String)"userId", (Object)search.getId()));
            query.filter((QueryBuilder)QueryBuilders.matchQuery((String)"userType", (Object)search.getUserType()));
            if (search.getSecType() != null) {
                query.filter((QueryBuilder)QueryBuilders.matchQuery((String)"serviceType", (Object)search.getSecType()));
            }
            if (StringUtils.isNotBlank((CharSequence)search.getCid())) {
                query.filter((QueryBuilder)QueryBuilders.matchQuery((String)"serviceId", (Object)search.getCid()));
            }
        }
        if (search.getStatus() != null) {
            query.filter((QueryBuilder)QueryBuilders.matchQuery((String)"exception", (Object)search.getStatus()));
        }
        if (search.getStrTime() != null) {
            query.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"accessTime").gte((Object)search.getStrTime()).lte((Object)search.getEndTime()));
        }
        if (StringUtils.isNotBlank((CharSequence)search.getName())) {
            query.filter((QueryBuilder)QueryBuilders.wildcardQuery((String)"serviceName.keyword", (String)("*" + search.getName() + "*")));
        }
        builder.sort("accessTime", SortOrder.DESC);
        builder.query((QueryBuilder)query);
        Page<LogInfoDTO> res = this.esUtilMonitor.searchPage(builder, LogInfoDTO.class, search.getPage(), search.getSize());
        List records = res.getRecords();
        for (LogInfoDTO logInfo : records) {
            logInfo.setUserType(AccessType.getByValue((int)Integer.valueOf((String)logInfo.getUserType()).intValue()).description);
        }
        return res;
    }

    @Override
    public JSONObject statistics() throws Exception {
        JSONObject jsonObject = new JSONObject();
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)wrapper.eq((Object)"f_precision", (Object)StatisticUnit.ALL.value)).select(new String[]{"sum(f_accesscount) as accessCount", "sum(f_exception) as exception", "sum(f_costtime) as costtime"});
        ZyfxAccessStatistics one = (ZyfxAccessStatistics)this.getOne((Wrapper)wrapper);
        if (one == null) {
            jsonObject.put("accessCount", (Object)0);
            jsonObject.put("exception", (Object)0);
            jsonObject.put("succeed", (Object)0);
            jsonObject.put("averageTime", (Object)0);
            jsonObject.put("normal", (Object)0);
            jsonObject.put("abnormal", (Object)0);
        } else {
            jsonObject.put("accessCount", (Object)one.getAccessCount());
            jsonObject.put("exception", (Object)one.getException());
            Double succeed = (double)(one.getAccessCount() - one.getException()) / ((double)one.getAccessCount().longValue() * 1.0) * 100.0;
            jsonObject.put("succeed", (Object)succeed.intValue());
            Double time = one.getCostTime() / ((double)one.getAccessCount().longValue() * 1.0);
            jsonObject.put("normal", (Object)(one.getAccessCount() - one.getException()));
            jsonObject.put("abnormal", (Object)one.getException());
            jsonObject.put("averageTime", (Object)time);
        }
        jsonObject.put("totalServiceNumber", (Object)this.statisticsMapper.statistics());
        jsonObject.put("applicationNumber", null);
        return jsonObject;
    }

    @Override
    public List<Map<String, Object>> queryActiveAuthorizer(Integer accessType, Integer limit) {
        List<Map<String, Object>> activeList = ((ZyfxAccessStatisticsMapper)this.baseMapper).queryActiveAuthorizer(accessType, StatisticUnit.ALL.value, limit);
        return activeList;
    }

    @Override
    public HashMap<String, Object> countResource(Integer precision) throws Exception {
        return null;
    }

    @Override
    public Map<String, Object> getServiceStatisByCatalog(Integer precision, Long strTime, Long endTime, Integer type) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map<Object, List<EchartsResultDTO>> chatMap = this.queryServiceAll(type);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"f_precision", (Object)precision);
        queryWrapper.select(new String[]{"f_resourcetype as ResourceType", "sum(f_accesscount) as accessCount", "sum(f_exception) as exception"}).groupBy((Object)"f_resourcetype");
        if (precision.equals(StatisticUnit.DAY.value)) {
            queryWrapper.between((Object)"f_accesstime", (Object)new Date(strTime), (Object)new Date(endTime));
        }
        List list = this.list((Wrapper)queryWrapper);
        Map<String, ZyfxAccessStatistics> collect = list.stream().collect(Collectors.toMap(a -> ServiceType.getByValue((int)a.getResourceType().intValue()).alias, a -> a));
        ZyfxAccessStatistics statistics = collect.get(ServiceType.COMPONENT.alias);
        map.put("statis", collect);
        map.put("chat", chatMap);
        return map;
    }

    @Override
    public Map<String, Object> getAccessStatis() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<ZyfxAccessStatistics> mapServiceMap = ((ZyfxAccessStatisticsMapper)this.baseMapper).getAccessStatis();
        map.put("allService", mapServiceMap);
        return map;
    }

    @Override
    public Map<String, Object> getResponseStatis() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<ZyfxAccessStatistics> mapServiceMap1 = ((ZyfxAccessStatisticsMapper)this.baseMapper).getResponseStatis(null, 1);
        List<ZyfxAccessStatistics> mapServiceMap2 = ((ZyfxAccessStatisticsMapper)this.baseMapper).getResponseStatis(1, 5);
        List<ZyfxAccessStatistics> mapServiceMap3 = ((ZyfxAccessStatisticsMapper)this.baseMapper).getResponseStatis(5, 10);
        List<ZyfxAccessStatistics> mapServiceMap4 = ((ZyfxAccessStatisticsMapper)this.baseMapper).getResponseStatis(10, null);
        map.put("rangeLess1", mapServiceMap1);
        map.put("range1to5", mapServiceMap2);
        map.put("range5to10", mapServiceMap3);
        map.put("rangeGreater10", mapServiceMap4);
        return map;
    }

    @Override
    public List getFlowStatis() {
        ArrayList list = new ArrayList();
        SearchSourceBuilder builder = new SearchSourceBuilder();
        BoolQueryBuilder query = QueryBuilders.boolQuery();
        builder.aggregation((AggregationBuilder)((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)"logs_per_day").field("accessTime")).calendarInterval(DateHistogramInterval.HOUR).format("yyyy-MM-dd'T'HH")).minDocCount(0L));
        LocalDateTime localDateTime = LocalDateTime.of(LocalDate.now(), LocalTime.MIN);
        LocalDateTime oneHourBefore = localDateTime.minusDays(1L);
        query.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"accessTime").gt((Object)oneHourBefore.toInstant(ZoneOffset.of("+8")).toEpochMilli()));
        builder.sort("accessTime", SortOrder.DESC);
        builder.query((QueryBuilder)query);
        String json = this.esUtilMonitor.groupCounts(builder, "logs_per_day");
        SimpleDateFormat sdf = new SimpleDateFormat("HH");
        if (StringUtils.isNotBlank((CharSequence)json)) {
            JSONObject jsonObject = JSONObject.parseObject((String)json);
            List countList = jsonObject.getJSONArray("buckets").toJavaList(JSONObject.class);
            countList.forEach(count -> {
                HashMap<String, Object> map = new HashMap<String, Object>();
                Date date = new Date(Long.valueOf(count.getString("key")));
                map.put("name", sdf.format(date) + ":00");
                map.put("value", count.getInteger("docCount"));
                list.add(map);
            });
        }
        return list;
    }

    @Override
    public Integer queryExceptionTotalNumber() {
        Integer exceptionNumber = 0;
        ArrayList<Map> notExceptionList = this.GetServiceStatus(ResponseExceptionType.NotException.value);
        ArrayList<Map> exceptionList = this.GetServiceStatus(ResponseExceptionType.Exception.value);
        for (Map exceptionMap : exceptionList) {
            Stream<Map> list = notExceptionList.stream().filter(p -> p.get("name").equals(exceptionMap.get("name")));
            if (list.count() > 0L) {
                if (Integer.valueOf(list.findFirst().get().get("value").toString()) >= Integer.valueOf(exceptionMap.get("value").toString())) continue;
                exceptionNumber = exceptionNumber + 1;
                continue;
            }
            exceptionNumber = exceptionNumber + 1;
        }
        return exceptionNumber;
    }

    private ArrayList<Map> GetServiceStatus(Integer exceptionType) {
        ArrayList<Map> list = new ArrayList<Map>();
        SearchSourceBuilder builder = new SearchSourceBuilder();
        BoolQueryBuilder query = QueryBuilders.boolQuery();
        builder.aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"exception_count").field("serviceId.keyword")).size(999));
        if (exceptionType.equals(ResponseExceptionType.NotException.value)) {
            query.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"exception").lte((Object)exceptionType));
        } else {
            query.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"exception").gte((Object)exceptionType));
        }
        LocalDateTime localDateTime = LocalDateTime.of(LocalDate.now(), LocalTime.MIN);
        LocalDateTime oneHourBefore = localDateTime.minusHours(1L);
        query.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"accessTime").gt((Object)oneHourBefore.toInstant(ZoneOffset.of("+8")).toEpochMilli()));
        builder.sort("accessTime", SortOrder.DESC);
        builder.query((QueryBuilder)query);
        String json = this.esUtilMonitor.groupCounts(builder, "exception_count");
        if (StringUtils.isNotBlank((CharSequence)json)) {
            JSONObject jsonObject = JSONObject.parseObject((String)json);
            List countList = jsonObject.getJSONArray("buckets").toJavaList(JSONObject.class);
            countList.forEach(count -> {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("name", count.getString("keyAsString"));
                map.put("value", count.getInteger("docCount"));
                list.add(map);
            });
        }
        return list;
    }

    @Override
    public Map<String, Long> getHotSpotAreatatis(String token) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        try {
            List<ZyfxAccessStatistics> mapServiceMap = ((ZyfxAccessStatisticsMapper)this.baseMapper).getHotSpotAreatatis();
            for (ZyfxAccessStatistics zyfx : mapServiceMap) {
                SysUserDTO sysUserDTO = this.tokenService.querySysUserByUserId(token, zyfx.getAccessId());
                if (sysUserDTO.getXzqdm().equals("430000")) {
                    sysUserDTO.setXzqdm("430100");
                }
                if (map.containsKey(sysUserDTO.getXzqdm())) {
                    map.put(sysUserDTO.getXzqdm(), (Long)map.get(sysUserDTO.getXzqdm()) + zyfx.getAccessCount());
                    continue;
                }
                map.put(sysUserDTO.getXzqdm(), zyfx.getAccessCount());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    @Override
    public Map<String, Object> getNumByServiceType(Integer precision) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<EchartsResultDTO> mapServiceMap = ((ZyfxAccessStatisticsMapper)this.baseMapper).getNumByServiceType(ServiceType.MAP.values);
        List<EchartsResultDTO> analysServiceMap = ((ZyfxAccessStatisticsMapper)this.baseMapper).getNumByServiceType(ServiceType.ANALYS.values);
        List<EchartsResultDTO> compentServiceMap = ((ZyfxAccessStatisticsMapper)this.baseMapper).getNumByServiceType(ServiceType.COMPONENT.values);
        ArrayList build = new ArrayList();
        map.put("mapService", mapServiceMap == null ? build : mapServiceMap);
        map.put("analysService", analysServiceMap == null ? build : analysServiceMap);
        map.put("compentService", compentServiceMap == null ? build : compentServiceMap);
        return map;
    }

    @Override
    public Map<String, Object> getNumByMapServiceType(Integer precision) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ZyfxAccessStatistics mapServiceMap = ((ZyfxAccessStatisticsMapper)this.baseMapper).getNumByMapServiceType(precision, ServiceType.MAP.value);
        ZyfxAccessStatistics analysServiceMap = ((ZyfxAccessStatisticsMapper)this.baseMapper).getNumByMapServiceType(precision, ServiceType.ANALYS.value);
        ZyfxAccessStatistics compentServiceMap = ((ZyfxAccessStatisticsMapper)this.baseMapper).getNumByMapServiceType(precision, ServiceType.COMPONENT.value);
        ZyfxAccessStatistics build = ZyfxAccessStatistics.builder().counts(0L).accessCount(0L).exception(0L).build();
        map.put("mapService", mapServiceMap == null ? build : mapServiceMap);
        map.put("analysService", analysServiceMap == null ? build : analysServiceMap);
        map.put("compentService", compentServiceMap == null ? build : compentServiceMap);
        return map;
    }

    @Override
    public Map<String, Object> getHotServiceByServiceType(Integer precision, Integer limit, Long strTime, Long endTime) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Date strDate = precision == StatisticUnit.ALL.value ? null : new Date(strTime);
        Date endDate = precision == StatisticUnit.ALL.value ? null : new Date(endTime);
        List<ZyfxAccessStatistics> mapServiceMap = ((ZyfxAccessStatisticsMapper)this.baseMapper).getHotServiceByServiceType(precision, ServiceType.MAP.value, limit, strDate, endDate);
        List<ZyfxAccessStatistics> analysServiceMap = ((ZyfxAccessStatisticsMapper)this.baseMapper).getHotServiceByServiceType(precision, ServiceType.ANALYS.value, limit, strDate, endDate);
        map.put("mapService", mapServiceMap);
        map.put("analysService", analysServiceMap);
        List<ZyfxAccessStatistics> allMap = ((ZyfxAccessStatisticsMapper)this.baseMapper).getHotServiceByServiceType(precision, null, limit, strDate, endDate);
        map.put("allService", allMap);
        return map;
    }

    @Override
    public Map<String, Object> queryExceptionByNow() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        long times = LocalDateTime.of(LocalDate.now(), LocalTime.MIN).toInstant(ZoneOffset.of("+8")).toEpochMilli();
        SearchSourceBuilder builder = new SearchSourceBuilder();
        BoolQueryBuilder query = QueryBuilders.boolQuery();
        query.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"exception").gt((Object)ResponseExceptionType.NotException.value));
        query.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"accessTime").gt((Object)times));
        builder.sort("accessTime", SortOrder.DESC);
        builder.query((QueryBuilder)query);
        builder.aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"code").field("code")).size(99));
        String json = this.esUtilMonitor.groupCounts(builder, "code");
        ArrayList list = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)json)) {
            JSONObject jsonObject = JSONObject.parseObject((String)json);
            List countList = jsonObject.getJSONArray("buckets").toJavaList(JSONObject.class);
            countList.forEach(count -> {
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                map.put("name", count.getInteger("keyAsString"));
                map.put("value", count.getInteger("docCount"));
                list.add(map);
            });
        }
        result.put("chat", list);
        List arrayList = this.esUtilMonitor.serviceMonitorGroup(builder);
        arrayList.forEach(p -> {
            if (p.get("serviceName") == null) {
                p.put("serviceName", this.apiService.queryServiceName(p.get("serviceId").toString()));
            }
        });
        result.put("list", arrayList);
        return result;
    }

    @Override
    public List queryExceptionChat(Long times) {
        ArrayList list = new ArrayList();
        SearchSourceBuilder builder = new SearchSourceBuilder();
        BoolQueryBuilder query = QueryBuilders.boolQuery();
        builder.aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"exception_count").field("code")).size(999));
        query.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"exception").gt((Object)ResponseExceptionType.NotException.value));
        if (times != null) {
            query.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"accessTime").gt((Object)times));
        }
        builder.query((QueryBuilder)query);
        String json = this.esUtilMonitor.groupCounts(builder, "exception_count");
        if (StringUtils.isNotBlank((CharSequence)json)) {
            JSONObject jsonObject = JSONObject.parseObject((String)json);
            List countList = jsonObject.getJSONArray("buckets").toJavaList(JSONObject.class);
            countList.forEach(count -> {
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                map.put("name", count.getInteger("keyAsString"));
                map.put("value", count.getInteger("docCount"));
                list.add(map);
            });
        }
        return list;
    }

    @Override
    public List<Object> queryExceptionType() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (ResponseExceptionType type : ResponseExceptionType.values()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", type.name);
            map.put("value", type.value);
            list.add(map);
        }
        return list;
    }

    @Override
    public List queryExceptionListSort(Integer size, Integer type, Long times) throws Exception {
        List<Object> result = new ArrayList();
        QueryWrapper wrapper = new QueryWrapper();
        if (type == 0) {
            ((QueryWrapper)wrapper.groupBy((Object)"f_resourceid", (Object[])new String[]{"f_resourcetype"})).select(new String[]{"f_resourceid as resourceId", "count(f_accessid) as counts", "sum(f_exception) as exception", "f_resourcetype as resourceType", "max(f_accesstime) as accessTime", "max(f_params) as params"});
            ((QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"f_precision", (Object)StatisticUnit.ALL.value)).gt((Object)"f_exception", (Object)0)).orderByDesc((Object)"exception")).last(size == 5 || size == 10 ? "limit " + size : "limit 5");
            if (times != null) {
                wrapper.ge((Object)"f_accesstime", (Object)new Date(times));
            }
            result = this.list((Wrapper)wrapper);
            result = this.nameManage(result);
        } else {
            Integer accessType = type == 1 ? AccessType.USER.value : AccessType.APPLICATION.value;
            Date date = times == null ? null : new Date(times);
            size = size == 5 || size == 10 ? size : 5;
            result = this.statisticsMapper.queryExceptionListSort(StatisticUnit.ALL.value, accessType, date, size);
            result.forEach(res -> res.setRoll(StringUtils.isBlank((CharSequence)res.getRollId()) ? 0 : 1));
        }
        return result;
    }

    @Override
    public Map<String, Object> queryAccesscount(Integer type) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"sum(f_accesscount) as accessCount"}).eq((Object)"f_precision", (Object)StatisticUnit.ALL.value);
        if (type != null) {
            queryWrapper.eq((Object)"f_resourcetype", (Object)ServiceType.getByValues((int)type));
        }
        ZyfxAccessStatistics statisticsAll = (ZyfxAccessStatistics)((ZyfxAccessStatisticsMapper)this.baseMapper).selectOne((Wrapper)queryWrapper);
        queryWrapper.clear();
        Date startTime = new Date(LocalDateTime.of(LocalDate.now(), LocalTime.MIN).toInstant(ZoneOffset.of("+8")).toEpochMilli());
        Date endTime = new Date(LocalDateTime.of(LocalDate.now(), LocalTime.MAX).toInstant(ZoneOffset.of("+8")).toEpochMilli());
        ((QueryWrapper)queryWrapper.select(new String[]{"sum(f_accesscount) as accessCount"}).eq((Object)"f_precision", (Object)StatisticUnit.DAY.value)).between((Object)"f_accessTime", (Object)startTime, (Object)endTime);
        if (type != null) {
            queryWrapper.eq((Object)"f_resourcetype", (Object)ServiceType.getByValues((int)type));
        }
        ZyfxAccessStatistics statisticsDay = (ZyfxAccessStatistics)((ZyfxAccessStatisticsMapper)this.baseMapper).selectOne((Wrapper)queryWrapper);
        map.put("sum", statisticsAll == null ? 0L : statisticsAll.getAccessCount());
        map.put("day", statisticsDay == null ? 0L : statisticsDay.getAccessCount());
        return map;
    }

    private Map<Object, List<EchartsResultDTO>> queryServiceAll(Integer type) {
        HashMap<Object, List<EchartsResultDTO>> chatMap = new HashMap<Object, List<EchartsResultDTO>>();
        if (type == 1) {
            List<EchartsResultDTO> maps = this.statisticsMapper.statisEcharts(ServiceType.MAP.value);
            chatMap.put(ServiceType.MAP.alias, maps);
            List<EchartsResultDTO> analys = this.statisticsMapper.statisEcharts(ServiceType.ANALYS.value);
            chatMap.put(ServiceType.ANALYS.alias, analys);
        }
        return chatMap;
    }

    private Map<String, List> getException(List records, String id, Integer type) {
        ArrayList<String> ids = new ArrayList();
        if (type == 0) {
            List record = records;
            ids = record.stream().filter(f -> f.getException() > 0L).map(m -> m.getResourceId()).collect(Collectors.toList());
        } else {
            List record = records;
            ids = record.stream().filter(f -> f.getException() > 0L).map(m -> m.getAccessId()).collect(Collectors.toList());
        }
        return this.esUtilMonitor.queryExceptionByIds(ids, id, type);
    }

    private Map<Object, List<EchartsResultDTO>> serviceNameManage(Map<Object, List<EchartsResultDTO>> resultMap, Integer type) {
        if (type == 1) {
            resultMap.put(ServiceType.MAP.alias, resultMap.get(ServiceType.MAP.alias));
            resultMap.put(ServiceType.ANALYS.alias, resultMap.get(ServiceType.ANALYS.alias));
        }
        return resultMap;
    }

    private List<ZyfxAccessStatistics> nameManage(List<ZyfxAccessStatistics> list) {
        list.stream().map(map -> {
            String params = map.getParams();
            map.setName(this.serviceNameManage(map.getResourceId(), map.getResourceType()));
            if (StringUtils.isEmpty((CharSequence)map.getName()) && JSONObject.isValidObject((String)params)) {
                map.setName(JSONObject.parseObject((String)params).getString("name"));
            }
            return map;
        }).collect(Collectors.toList());
        return list;
    }

    private void getResouceList() {
        ServiceType[] values;
        for (ServiceType service : values = ServiceType.values()) {
            List<ZyfxObject> list;
            if (service.value == -1 || service.value == 3) continue;
            String key = "resoureData" + service.value;
            if (!this.redisTemplate.hasKey((Object)key).booleanValue() && (list = this.apiService.queryService(service.value)) != null && list.size() > 0) {
                for (ZyfxObject resouce : list) {
                    this.redisTemplate.boundHashOps((Object)("resoureData" + service.value)).put((Object)resouce.getId(), (Object)resouce.getName());
                }
            }
            this.redisTemplate.expire((Object)("resoureData" + service.value), 3L, TimeUnit.MINUTES);
        }
    }

    private Boolean refResource(Integer type) {
        Boolean hasKey = this.redisTemplate.hasKey((Object)("resoureData" + type));
        if (!hasKey.booleanValue()) {
            this.getResouceList();
        }
        return hasKey;
    }

    private String serviceNameManage(String id, Integer type) {
        this.refResource(type);
        Object data = this.redisTemplate.boundHashOps((Object)("resoureData" + type)).get((Object)id);
        if (ObjectUtil.isNotEmpty((Object)data)) {
            return (String)data;
        }
        return null;
    }
}

