/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.geoway.ns.sys.dto.BaseObjectResponse;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.dto.EasyUIResponse;
import com.geoway.ns.sys.dto.FileServerResponse;
import com.geoway.ns.sys.dto.SysUserDTO;
import com.geoway.ns.sys.service.ITokenService;
import com.geoway.ns.sys.utils.MyRequestUtil;
import com.geoway.ns.zyfx.domain.ConcurrentCheck;
import com.geoway.ns.zyfx.domain.ConcurrentTask;
import com.geoway.ns.zyfx.service.ConcurrentCheckService;
import com.geoway.ns.zyfx.service.ConcurrentTaskService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u6570\u636e\u6c47\u4ea4\u4efb\u52a1"})
@RestController
@RequestMapping(value={"concurrentTask"})
public class ConcurrentTaskController {
    private static final Logger log = LoggerFactory.getLogger(ConcurrentTaskController.class);
    @Resource
    private ConcurrentTaskService concurrentTaskService;
    @Resource
    private ConcurrentCheckService concurrentCheckService;
    @Resource
    private ITokenService tokenService;

    @ApiOperation(value="\u65b0\u589e\u6570\u636e\u6c47\u4ea4\u4efb\u52a1:name(\u6570\u636e\u6c47\u4ea4\u4efb\u52a1\u540d\u79f0)\u3001templatesId(\u6c47\u4ea4\u6a21\u677fid)\u3001dataReceiver(\u6570\u636e\u63a5\u6536\u4eba)\u3001dataReceiverId(\u6570\u636e\u63a5\u6536\u4ebaid)\u3001telephone(\u8054\u7cfb\u7535\u8bdd)\u3001concurrentMode(\u6c47\u4ea4\u6a21\u5f0f\uff1a1 \u7ebf\u4e0a\u6c47\u4ea4 0 \u7ebf\u4e0b\u6c47\u4ea4)\u3001concurrentType(\u6c47\u4ea4\u7c7b\u578b\uff1a0 \u4e3b\u52a8\u7533\u8bf7 1 \u88ab\u52a8\u63d0\u4ea4)\u3001deadline(\u622a\u6b62\u65f6\u95f4)\u5fc5\u586b\u3001\u5982\u679c\u6c47\u4ea4\u7c7b\u578b\u662f1\u88ab\u52a8\u6c47\u4ea4\uff0c\u5219\u4efb\u52a1\u63a5\u6536\u4ebataskReceiverList(\u6c47\u4ea4\u4efb\u52a1\u63a5\u6536\u4eba\uff1a\u6570\u636e\u683c\u5f0f\u4e3a'[{taskReceiver:\u5f20\u4e09,taskReceiverId:1},{taskReceiver:\u674e\u56db,taskReceiverId:2}])\u4e5f\u5fc5\u586b,dataReceivingUnit(\u6570\u636e\u63a5\u6536\u5355\u4f4d)\u3001email(\u90ae\u7bb1)\u3001note(\u5907\u6ce8)\u9009\u586b")
    @PostMapping(value={"addConcurrentTask"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse addConcurrentTask(HttpServletRequest request, @ModelAttribute ConcurrentTask concurrentTask) throws Exception {
        BaseObjectResponse response = new BaseObjectResponse();
        SysUserDTO sysUser = this.tokenService.queryCurrentSysUser();
        try {
            concurrentTask.setCreateTime(new Date());
            concurrentTask.setTaskPublisher(sysUser.getAlisname());
            concurrentTask.setTaskPublisherId(sysUser.getId());
            List<ConcurrentCheck> concurrentCheckList = this.concurrentTaskService.addConcurrentTask(concurrentTask);
            concurrentCheckList.forEach(concurrentCheck -> {
                concurrentCheck.setTaskId(concurrentTask.getId());
                if (concurrentTask.getConcurrentType() == 0) {
                    concurrentCheck.setCheckStatus(0);
                } else {
                    concurrentCheck.setCheckStatus(-1);
                }
            });
            this.concurrentCheckService.saveBatch(concurrentCheckList);
            response.setData((Object)"\u6570\u636e\u6c47\u4ea4\u4efb\u52a1\u65b0\u5efa\u6210\u529f");
        }
        catch (Exception e) {
            return BaseResponse.buildFailuaResponse((String)e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e\u6c47\u4ea4\u4efb\u52a1:id(\u6570\u636e\u6c47\u4ea4\u4efb\u52a1id,\u5b58\u5728\u591a\u4e2a\u7528\u82f1\u6587\u9017\u53f7\u9694\u5f00)\u5fc5\u586b")
    @PostMapping(value={"deleteConcurrentTask"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse deleteConcurrentTask(@ModelAttribute ConcurrentTask concurrentTask) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            List<String> idList = this.concurrentTaskService.deleteConcurrentTask(concurrentTask);
            QueryWrapper concurrentCheckWrapper = new QueryWrapper();
            concurrentCheckWrapper.lambda().in(ConcurrentCheck::getTaskId, idList);
            this.concurrentCheckService.remove((Wrapper)concurrentCheckWrapper);
            response.setData((Object)"\u6570\u636e\u6c47\u4ea4\u4efb\u52a1\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            return BaseResponse.buildFailuaResponse((String)e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6570\u636e\u6c47\u4ea4\u4efb\u52a1\u4efb\u52a1\u4fe1\u606f\uff1apage(\u9875\u7801),rows(\u6bcf\u9875\u6570\u636e\u91cf)\u5206\u9875\u4fe1\u606f\u5fc5\u586b,name(\u6570\u636e\u6c47\u4ea4\u4efb\u52a1\u540d\u79f0)\u3001checkStatus(\u5ba1\u6279\u72b6\u6001 -1 \u672a\u5ba1\u6838 0 \u5f85\u5ba1\u6838 1 \u901a\u8fc7 2 \u62d2\u7edd)startQueryDate(\u8d77\u59cb\u521b\u5efa\u65f6\u95f4)\u3001endQueryDate(\u622a\u6b62\u521b\u5efa\u65f6\u95f4)\u9009\u586b")
    @PostMapping(value={"queryConcurrentTaskPage"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse queryConcurrentTaskPage(HttpServletRequest request, @ModelAttribute ConcurrentTask concurrentTask, @RequestParam(value="token", required=false) String token) {
        EasyUIResponse response = new EasyUIResponse();
        try {
            if (StrUtil.isBlank((CharSequence)token)) {
                token = MyRequestUtil.queryAccessTokenInHeader((HttpServletRequest)request);
            }
            if (StrUtil.isNotBlank((CharSequence)token)) {
                SysUserDTO sysUser = this.tokenService.queryCurrentSysUser();
                concurrentTask.setUserId(sysUser.getId());
            }
            IPage<ConcurrentTask> concurrentTaskIPage = this.concurrentTaskService.queryConcurrentTaskPage(concurrentTask);
            response.setRows(concurrentTaskIPage.getRecords());
            response.setTotal(Long.valueOf(concurrentTaskIPage.getTotal()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return EasyUIResponse.buildFailuaResponse((String)e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u4e0a\u4f20\u6570\u636e\u6c47\u4ea4\u4efb\u52a1\u6570\u636e")
    @PostMapping(value={"/uploadFile"})
    public BaseResponse uploadFile(@RequestParam(value="file") MultipartFile multipartFile) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            FileServerResponse fileUploadResponse = this.concurrentTaskService.uploadFile(multipartFile);
            response.setData((Object)fileUploadResponse);
        }
        catch (Exception e) {
            return BaseObjectResponse.buildFailuaResponse((String)e.getMessage());
        }
        return response;
    }
}

