/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.dto.DataResponse;
import com.geoway.ns.sys.dto.RowsResponse;
import com.geoway.ns.sys.dto.SysUserDTO;
import com.geoway.ns.sys.service.ITokenService;
import com.geoway.ns.sys.utils.MyRequestUtil;
import com.geoway.ns.zyfx.domain.ZyfxObject;
import com.geoway.ns.zyfx.service.ZyfxImageService;
import com.geoway.ns.zyfx.service.ZyfxObjectService;
import com.geoway.ns.zyfx.service.ZyfxRegAvalService;
import com.geoway.sso.client.util.SessionUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5bf9\u8c61\u96c6\u6ce8\u518c\u5ba1\u6838\u63a5\u53e3"})
@RestController
@RequestMapping(value={"zyfx/regaval"})
public class ZyfxObjectRegController {
    private static final Logger log = LoggerFactory.getLogger(ZyfxObjectRegController.class);
    @Autowired
    ZyfxObjectService zyfxObjectService;
    @Autowired
    ZyfxImageService zyfxImageService;
    @Autowired
    ZyfxRegAvalService zyfxRegAvalService;
    @Autowired
    ITokenService tokenService;

    @ApiOperation(value="\u67e5\u8be2\u8d44\u6e90\u5bf9\u8c61\u96c6\u6ce8\u518c\u5217\u8868")
    @RequestMapping(value={"/reglist"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public RowsResponse queryCatalogRegList(HttpServletRequest request, @RequestParam(value="groupType", required=true) Integer groupType, @RequestParam(value="filterParam", required=false, defaultValue="") String filterParam, @RequestParam(value="sortParam", required=false, defaultValue="") String sortParam, @RequestParam(value="page", required=true) Integer page, @RequestParam(value="size", required=true) Integer size) {
        RowsResponse response = new RowsResponse();
        try {
            String userId;
            if (StrUtil.isBlank((CharSequence)sortParam)) {
                sortParam = "SORT_createtime_ASC";
            }
            if (filterParam.indexOf("Q_lylx_S_EQ") == -1) {
                filterParam = filterParam + "Q_lylx_S_EQ=\u5171\u4eab\u6ce8\u518c";
            }
            if ((userId = SessionUtils.getUserId((HttpServletRequest)request)) == null) {
                userId = this.tokenService.queryCurrentSysUserId();
            }
            IPage<ZyfxObject> objectList = this.zyfxRegAvalService.queryPageByRegUserFilter(userId, groupType, filterParam, sortParam, page, size);
            response.setRows(objectList.getRecords());
            response.setTotal(Long.valueOf(objectList.getTotal()));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u67e5\u8be2\u8d44\u6e90\u5bf9\u8c61\u96c6\u5ba1\u6838\u5217\u8868")
    @RequestMapping(value={"/avallist"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public RowsResponse queryCatalogAvalList(HttpServletRequest request, @RequestParam(value="groupType", required=true) Integer groupType, @RequestParam(value="filterParam", required=false, defaultValue="") String filterParam, @RequestParam(value="sortParam", required=false, defaultValue="") String sortParam, @RequestParam(value="page", required=true) Integer page, @RequestParam(value="size", required=true) Integer size) {
        RowsResponse response = new RowsResponse();
        try {
            String userId;
            if (StrUtil.isBlank((CharSequence)sortParam)) {
                sortParam = "SORT_createtime_ASC";
            }
            if (filterParam.indexOf("Q_lylx_S_EQ") == -1) {
                filterParam = filterParam + "Q_lylx_S_EQ=\u5171\u4eab\u6ce8\u518c";
            }
            if ((userId = SessionUtils.getUserId((HttpServletRequest)request)) == null) {
                userId = this.tokenService.queryCurrentSysUserId();
            }
            IPage<ZyfxObject> objectList = this.zyfxRegAvalService.queryPageByAvalUserFilter(userId, groupType, filterParam, sortParam, page, size);
            response.setRows(objectList.getRecords());
            response.setTotal(Long.valueOf(objectList.getTotal()));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u5220\u9664\u5bf9\u8c61\u96c6")
    @PostMapping(value={"delete"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse realDelete(HttpServletRequest request, @RequestParam(value="ids", defaultValue="") String ids) {
        BaseResponse response = new BaseResponse();
        try {
            this.zyfxObjectService.realDelete(ids);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u5ba1\u6838\u6ce8\u518c\u7684\u6570\u636e")
    @PostMapping(value={"aval"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse realDelete(HttpServletRequest request, @RequestParam(value="id") String objectId, @RequestParam(value="status") int status, @RequestParam(value="comment") String comment) {
        BaseResponse response = new BaseResponse();
        try {
            String token = MyRequestUtil.queryAccessTokenInHeader((HttpServletRequest)request);
            SysUserDTO sysUser = this.tokenService.querySysUserByToken(token);
            if (sysUser == null) {
                return DataResponse.error((String)"\u7cfb\u7edf\u672a\u767b\u5165");
            }
            this.zyfxRegAvalService.aval(objectId, status, comment);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }
}

