/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.ns.zyfx.domain.ZyfxAccess;
import com.geoway.ns.zyfx.domain.ZyfxObject;
import com.geoway.ns.zyfx.mapper.ZyfxAccessMapper;
import com.geoway.ns.zyfx.service.ZyfxAccessService;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class ZyfxAccessServiceImpl
extends ServiceImpl<ZyfxAccessMapper, ZyfxAccess>
implements ZyfxAccessService {
    @Override
    public void addOneAccess(String objectId, String userId) {
        if (StrUtil.isBlank((CharSequence)userId)) {
            userId = "";
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ZyfxAccess::getObjectid, (Object)objectId);
        queryWrapper.eq(ZyfxAccess::getUserid, (Object)userId);
        if (this.count((Wrapper)queryWrapper) == 0L) {
            ZyfxAccess zyfxAccess = new ZyfxAccess();
            zyfxAccess.setObjectid(objectId);
            zyfxAccess.setUserid(userId);
            zyfxAccess.setAccesscount(0);
            this.save(zyfxAccess);
        } else {
            queryWrapper.last("LIMIT 1");
            ZyfxAccess zyfxAccess = (ZyfxAccess)this.getOne((Wrapper)queryWrapper);
            LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
            updateWrapper.eq(ZyfxAccess::getId, (Object)zyfxAccess.getId());
            updateWrapper.setSql(" f_accesscount = f_accesscount + 1");
            this.update((Wrapper)updateWrapper);
        }
    }

    @Override
    public long queryAccessCountByObjectId(String objectId) {
        return ((ZyfxAccessMapper)this.baseMapper).queryAccessCount(objectId);
    }

    @Override
    public Map<String, Long> queryAccessCountByObjectIds(List<String> objectIds) {
        List<Map> accessCountMaps = ((ZyfxAccessMapper)this.baseMapper).queryAccessCountByObjectIds(objectIds);
        Map<Object, Object> result = accessCountMaps.stream().collect(Collectors.toMap(s -> s.get("objectid"), s -> s.get("accesscount")));
        return result;
    }

    @Override
    public List<Map<String, Object>> queryMaxAccessGroupByObjectId(int groupType, int maxCount) {
        MPJLambdaWrapper queryWrapper = new MPJLambdaWrapper();
        queryWrapper.leftJoin(ZyfxObject.class, ZyfxObject::getId, ZyfxAccess::getObjectid);
        queryWrapper.selectAs(ZyfxAccess::getObjectid, "objectid");
        queryWrapper.selectSum(ZyfxAccess::getAccesscount, "accesscount");
        if (groupType > 0) {
            queryWrapper.eq(ZyfxObject::getGrouptype, (Object)groupType);
        }
        queryWrapper.ne(ZyfxObject::getIsDel, (Object)1);
        queryWrapper.groupBy(ZyfxAccess::getObjectid);
        queryWrapper.orderByDesc((Object)"accesscount");
        queryWrapper.last(" limit " + maxCount);
        return this.listMaps((Wrapper)queryWrapper);
    }
}

