/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.ns.zyfx.domain.ZyfxImage;
import com.geoway.ns.zyfx.mapper.ZyfxImageMapper;
import com.geoway.ns.zyfx.service.ZyfxImageService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.io.IOUtils;
import org.springframework.stereotype.Service;

@Service
public class ZyfxImageServiceImpl
extends ServiceImpl<ZyfxImageMapper, ZyfxImage>
implements ZyfxImageService {
    @Override
    public ZyfxImage updateZyfxImage(String iconId, InputStream inputStream, String tag) throws IOException {
        ZyfxImage zyfxImage = null;
        boolean isEdit = false;
        if (StrUtil.isNotEmpty((CharSequence)iconId)) {
            zyfxImage = (ZyfxImage)this.getById((Serializable)((Object)iconId));
            isEdit = true;
        }
        if (zyfxImage == null) {
            zyfxImage = new ZyfxImage();
        }
        byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
        zyfxImage.setImage((byte[])bytes.clone());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Thumbnails.of((InputStream[])new InputStream[]{byteArrayInputStream}).size(120, 90).toOutputStream((OutputStream)byteArrayOutputStream);
        zyfxImage.setThumnail(byteArrayOutputStream.toByteArray());
        byteArrayOutputStream.close();
        if (byteArrayInputStream != null) {
            byteArrayInputStream.close();
        }
        if (inputStream != null) {
            inputStream.close();
        }
        if (isEdit) {
            // empty if block
        }
        zyfxImage.setTag(tag);
        this.saveOrUpdate(zyfxImage);
        return zyfxImage;
    }
}

