/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.ns.base.exception.BizException;
import com.geoway.ns.sys.dto.SysUserDTO;
import com.geoway.ns.sys.service.ITokenService;
import com.geoway.ns.sys.support.query.MPJQueryMapperUtil;
import com.geoway.ns.zyfx.domain.ZyfxObject;
import com.geoway.ns.zyfx.domain.ZyfxRegAval;
import com.geoway.ns.zyfx.mapper.ZyfxObjectMapper;
import com.geoway.ns.zyfx.mapper.ZyfxRegAvalMapper;
import com.geoway.ns.zyfx.service.ZyfxRegAvalService;
import com.github.yulichang.interfaces.MPJBaseJoin;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ZyfxRegAvalServiceImpl
extends ServiceImpl<ZyfxRegAvalMapper, ZyfxRegAval>
implements ZyfxRegAvalService {
    @Autowired
    ZyfxObjectMapper zyfxObjectMapper;
    @Autowired
    ITokenService tokenService;

    @Override
    public IPage<ZyfxObject> queryPageByRegUserFilter(String userId, int groupType, String filterParam, String sortParam, int page, int size) throws Exception {
        MPJQueryMapperUtil qmu = new MPJQueryMapperUtil();
        MPJLambdaWrapper queryWrapper = qmu.queryMapper(filterParam, sortParam, ZyfxObject.class);
        queryWrapper.leftJoin(ZyfxRegAval.class, ZyfxRegAval::getObjectid, ZyfxObject::getId);
        queryWrapper.eq(ZyfxRegAval::getReguserid, (Object)userId);
        queryWrapper.eq(ZyfxObject::getGrouptype, (Object)groupType);
        Page pageT = new Page((long)page, (long)size);
        return this.zyfxObjectMapper.selectJoinPage((IPage)pageT, ZyfxObject.class, (MPJBaseJoin)queryWrapper);
    }

    @Override
    public IPage<ZyfxObject> queryPageByAvalUserFilter(String userId, int groupType, String filterParam, String sortParam, int page, int size) throws Exception {
        MPJQueryMapperUtil qmu = new MPJQueryMapperUtil();
        MPJLambdaWrapper queryWrapper = qmu.queryMapper(filterParam, sortParam, ZyfxObject.class);
        queryWrapper.leftJoin(ZyfxRegAval.class, ZyfxRegAval::getObjectid, ZyfxObject::getId);
        queryWrapper.eq(ZyfxObject::getGrouptype, (Object)groupType);
        Page pageT = new Page((long)page, (long)size);
        return this.zyfxObjectMapper.selectJoinPage((IPage)pageT, ZyfxObject.class, (MPJBaseJoin)queryWrapper);
    }

    @Override
    public void addOneRegValRecord(String objectId) throws Exception {
        SysUserDTO sysUserDTO = this.tokenService.queryCurrentSysUser();
        ZyfxRegAval zyfxRegAval = new ZyfxRegAval();
        zyfxRegAval.setReguserid(sysUserDTO.getId());
        zyfxRegAval.setRegusername(sysUserDTO.getUsername());
        zyfxRegAval.setObjectid(objectId);
        zyfxRegAval.setAvalstatus(0);
        this.saveOrUpdate(zyfxRegAval);
    }

    @Override
    public void aval(String objectId, int status, String comment) throws Exception {
        SysUserDTO sysUser = this.tokenService.queryCurrentSysUser();
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ZyfxRegAval::getObjectid, (Object)objectId);
        queryWrapper.eq(ZyfxRegAval::getAvalstatus, (Object)0);
        if (!this.tokenService.isChecker(sysUser).booleanValue()) {
            throw new BizException("\u5f53\u524d\u7528\u6237\u65e0\u5ba1\u6279\u6743\u9650");
        }
        long icount = this.count((Wrapper)queryWrapper);
        if (icount == 0L) {
            throw new BizException("\u8be5\u6570\u636e\u5df2\u7ecf\u5ba1\u6838\u901a\u8fc7\u4e86");
        }
        queryWrapper.last(" limit 1");
        ZyfxRegAval regAval = (ZyfxRegAval)this.getOne((Wrapper)queryWrapper);
        LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
        updateWrapper.eq(ZyfxRegAval::getId, (Object)regAval.getId());
        updateWrapper.set(ZyfxRegAval::getAvalstatus, (Object)status);
        updateWrapper.set(ZyfxRegAval::getComment, (Object)comment);
        updateWrapper.set(ZyfxRegAval::getAvaluserid, (Object)sysUser.getId());
        updateWrapper.set(ZyfxRegAval::getAvalusername, (Object)sysUser.getUsername());
        this.update((Wrapper)updateWrapper);
        LambdaUpdateWrapper updateWrapper2 = Wrappers.lambdaUpdate();
        updateWrapper2.eq(ZyfxObject::getId, (Object)objectId);
        updateWrapper2.set(ZyfxObject::getFlowstatus, (Object)status);
        if (status == 2) {
            updateWrapper2.set(ZyfxObject::getStatus, (Object)1);
        }
        this.zyfxObjectMapper.update(null, (Wrapper)updateWrapper2);
    }
}

