/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.monitor.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.adf.dms.config.dto.sysparam.SysParamDTO;
import com.geoway.adf.dms.config.service.SysParamsService;
import com.geoway.ns.monitor.dto.ResoureParamDTO;
import com.geoway.ns.monitor.dto.result.ServiceInfoDTO;
import com.geoway.ns.monitor.service.ApiService;
import com.geoway.ns.monitor.service.AuthorizeTokenService;
import com.geoway.ns.proxy.constant.ProxyConstants;
import com.geoway.ns.proxy.constant.enums.AccessType;
import com.geoway.ns.proxy.constant.enums.ServiceType;
import com.geoway.ns.proxy.entity.AuthorizeToken;
import com.geoway.ns.proxy.mapper.AuthorizeTokenMapper;
import com.geoway.ns.sys.dto.SysUserDTO;
import com.geoway.ns.sys.enums.SysParamGroupEnum;
import com.geoway.ns.sys.utils.MyBatisQueryMapperUtil;
import com.geoway.ns.zyfx.enums.AuthorizeType;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AuthorizeTokenServiceImpl
extends ServiceImpl<AuthorizeTokenMapper, AuthorizeToken>
implements AuthorizeTokenService {
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private ApiService apiService;
    @Autowired
    private SysParamsService sysParamsService;
    @Value(value="${share.proxy.oneToken: true}")
    private Boolean oneToken;

    @Override
    public IPage<AuthorizeToken> listFilter(String filterParams, Integer page, Integer size) throws Exception {
        Page authorizeTokenPage = new Page((long)page.intValue(), (long)size.intValue());
        MyBatisQueryMapperUtil mf = new MyBatisQueryMapperUtil();
        QueryWrapper queryWrapper = mf.queryMapper(filterParams, AuthorizeToken.class);
        queryWrapper.ne((Object)"f_status", (Object)2);
        queryWrapper.select(AuthorizeToken.class, info -> !info.getColumn().equals("f_url")).orderByDesc((Object)"f_updatetime");
        queryWrapper.orderByDesc((Object)"f_id");
        IPage authorizeTokenIPage = this.page((IPage)authorizeTokenPage, (Wrapper)queryWrapper);
        return authorizeTokenIPage;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String saveOrUpdateAuthorizeToken(AuthorizeToken authorizeToken) throws Exception {
        String token = null;
        String appUrl = "";
        if (StringUtils.isBlank((CharSequence)authorizeToken.getFrequency())) {
            authorizeToken.setFrequency("[{\"value\":0,\"type\":\"\",\"time\":[\"\",\"\"]}]");
        }
        this.verifaictionFrequency(authorizeToken.getFrequency());
        authorizeToken.setUpdateTime(new Date());
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(AuthorizeToken::getResourceId, (Object)authorizeToken.getResourceId());
        queryWrapper.eq(AuthorizeToken::getAuthorizerId, (Object)authorizeToken.getAuthorizerId());
        queryWrapper.last("LIMIT 1");
        AuthorizeToken authToken = (AuthorizeToken)this.getOne((Wrapper)queryWrapper);
        authorizeToken.setStatus(Integer.valueOf(0));
        if (ObjectUtil.isEmpty((Object)authToken)) {
            String qToken = this.queryTokenByAuthorizeInfo(authorizeToken);
            authorizeToken.setToken(qToken);
            authorizeToken.setRelativeUrl(this.initProxyUrl(authorizeToken.getUrl()));
            this.save(authorizeToken);
            token = authorizeToken.getToken();
        } else {
            authorizeToken.setRelativeUrl(this.initProxyUrl(authorizeToken.getUrl()));
            this.update(authorizeToken, (Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"f_resourceid", (Object)authorizeToken.getResourceId())).eq((Object)"f_authorizerid", (Object)authorizeToken.getAuthorizerId()));
            this.redisTemplate.delete((Object)("authorizers:" + authToken.getToken()));
            token = authToken.getToken();
        }
        return token;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeAuthorizeToken(String token, String sid) {
        if (StrUtil.isNotBlank((CharSequence)token)) {
            LambdaUpdateWrapper update = Wrappers.lambdaUpdate();
            ((LambdaUpdateWrapper)update.eq(AuthorizeToken::getToken, (Object)token)).set(AuthorizeToken::getStatus, (Object)2);
            this.update((Wrapper)update);
            if (this.redisTemplate.hasKey((Object)("authorizers:" + token)).booleanValue()) {
                this.redisTemplate.delete((Object)("authorizers:" + token));
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveAuthorizeTokenList(String params, HttpServletRequest request) throws Exception {
        SysUserDTO auther = new SysUserDTO();
        ArrayList<SysUserDTO> applyers = new ArrayList<SysUserDTO>();
        ArrayList<String> serviceIds = new ArrayList<String>();
        Date upTime = null;
        Integer type = null;
        String ipScope = null;
        String frequency = null;
        Integer accessType = null;
        if (StrUtil.isNotBlank((CharSequence)params)) {
            List authorizeTokenList = JSONObject.parseArray((String)params, AuthorizeToken.class);
            for (AuthorizeToken item : authorizeTokenList) {
                if (type == null) {
                    type = ServiceType.getByValue((int)item.getResourceType().intValue()).values;
                    upTime = item.getIndate();
                    ipScope = item.getIpScope();
                    frequency = item.getFrequency();
                    accessType = item.getAuthorizerType();
                }
                if (auther.getId() == null) {
                    SysUserDTO userInfo = this.getUserInfo(item.getAuthorization(), AccessType.USER.value);
                    BeanUtils.copyProperties((Object)userInfo, (Object)auther);
                }
                SysUserDTO infoDTO = this.getUserInfo(item.getAuthorizerId(), accessType);
                SysUserDTO userInfo = new SysUserDTO();
                BeanUtils.copyProperties((Object)infoDTO, (Object)userInfo);
                userInfo.setId(item.getAuthorizerId());
                userInfo.setUsername(item.getAuthorizerName());
                if (!serviceIds.contains(item.getResourceId())) {
                    serviceIds.add(item.getResourceId());
                }
                if (applyers.contains(userInfo)) continue;
                applyers.add(userInfo);
            }
        } else {
            throw new Exception("\u6ca1\u6709\u4f20\u9012\u6388\u6743\u5bf9\u8c61\uff01");
        }
        this.apiService.batchAuth(auther, applyers, serviceIds, upTime, type, accessType, ipScope, frequency);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateAuthorizeToken(AuthorizeToken authorizeToken) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)authorizeToken.getId())) {
            this.verifaictionFrequency(authorizeToken.getFrequency());
            if (this.redisTemplate.hasKey((Object)("authorizers:" + authorizeToken.getToken())).booleanValue()) {
                this.redisTemplate.delete((Object)("authorizers:" + authorizeToken.getToken()));
            }
            authorizeToken.setToken(null);
            this.updateById(authorizeToken);
        }
    }

    @Override
    public AuthorizeToken findByToken(String token) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)token)) {
            AuthorizeToken authorzier = (AuthorizeToken)this.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"f_token", (Object)token)).ne((Object)"f_status", (Object)2));
            if (ObjectUtil.isEmpty((Object)authorzier)) {
                String msg = "token\u4e3a\u3010" + token + "\u3011\u7684\u6388\u6743\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01";
                throw new Exception(msg);
            }
            String url = "";
            String params = authorzier.getParams();
            ResoureParamDTO dto = (ResoureParamDTO)JSON.parseObject((String)params, ResoureParamDTO.class);
            String groupType = dto.getSourceGroupType();
            if ("10".equals(groupType)) {
                int index = authorzier.getRelativeUrl().indexOf("/all/");
                String relativeUrl = authorzier.getRelativeUrl();
                url = this.getProxyURL() + relativeUrl.substring(0, index);
            } else {
                int indexOf = authorzier.getRelativeUrl().indexOf("?");
                url = this.getProxyURL() + authorzier.getRelativeUrl() + (indexOf < 0 ? "?gk=" : "&gk=") + token;
            }
            authorzier.setRelativeUrl(url);
            return authorzier;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateUrl(String id, String url) {
        if (StringUtils.isNotBlank((CharSequence)id) && StringUtils.isNotBlank((CharSequence)url)) {
            int index = url.indexOf("/", url.indexOf("/") + 2);
            String relative = url.substring(index);
            int i = relative.indexOf("?");
            if (i == relative.length() - 1) {
                relative = relative.substring(0, i);
            }
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            List list = this.list((Wrapper)wrapper.eq(AuthorizeToken::getResourceId, (Object)id));
            for (AuthorizeToken info : list) {
                String token = info.getToken();
                info.setRelativeUrl(i < ProxyConstants.UNITY_NUMBER_ZERO ? relative + "?gk=" + token : relative + "&gk=" + token);
            }
            this.updateBatchById(list);
        }
    }

    @Override
    public String getTemporaryToken(String id, Integer type, String url) throws Exception {
        HashMap map = new HashMap();
        String resourceUrl = null;
        resourceUrl = StringUtils.isBlank((CharSequence)url) ? this.apiService.getResourceUrl(id, type).getUrl() : url;
        HttpRequest post = HttpUtil.createPost((String)(this.getProxyURL() + "/getTempProxy"));
        post.form("url", (Object)resourceUrl);
        post.form("type", (Object)10);
        String body = post.execute().body();
        JSONObject jsonObject = JSONObject.parseObject((String)body);
        if (jsonObject.getInteger("code") != 200) {
            throw new Exception(jsonObject.getString("message"));
        }
        return jsonObject.getString("data");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateStatus(String token, Integer status) {
        LambdaUpdateWrapper update = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)update.eq(AuthorizeToken::getToken, (Object)token)).set(AuthorizeToken::getStatus, (Object)status);
        this.update((Wrapper)update);
        if (this.redisTemplate.hasKey((Object)("authorizers:" + token)).booleanValue()) {
            this.redisTemplate.delete((Object)("authorizers:" + token));
        }
    }

    @Override
    public List getAuthorizerByService(String serviceName, String serviceId, Integer serviceType, Integer authorizeType) {
        if (StringUtils.isNotBlank((CharSequence)serviceName)) {
            ServiceInfoDTO serviceInfoDTO = this.apiService.ServiceInfoByFilter(serviceName, serviceType);
            serviceId = serviceInfoDTO.getId();
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(AuthorizeToken::getResourceId, (Object)serviceId)).eq(AuthorizeToken::getResourceType, (Object)ServiceType.getByValues((int)serviceType))).eq(AuthorizeToken::getStatus, (Object)ProxyConstants.AUTHORIZE_STATUS_NORMAL);
        if (authorizeType != null) {
            wrapper.eq(AuthorizeToken::getAuthorizerType, (Object)authorizeType);
        }
        List list = this.list((Wrapper)wrapper);
        list.forEach(f -> {
            f.setUrl(null);
            f.setRelativeUrl(this.getProxyURL() + f.getRelativeUrl());
        });
        return list;
    }

    @Override
    public void updateResourceInfo(String resourceId, String url, String name, String sourceType, String groupType) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sourceName", name);
        map.put("sourceGroupType", groupType);
        LambdaUpdateWrapper update = Wrappers.lambdaUpdate(AuthorizeToken.class);
        ((LambdaUpdateWrapper)update.eq(AuthorizeToken::getResourceId, (Object)resourceId)).eq(AuthorizeToken::getResourceType, (Object)sourceType);
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)update.set(AuthorizeToken::getRelativeUrl, (Object)this.initProxyUrl(url))).set(AuthorizeToken::getUrl, (Object)url)).set(AuthorizeToken::getParams, (Object)JSON.toJSONString(map));
        this.update((Wrapper)update);
    }

    public String createToken(AuthorizeToken authorizeToken) {
        long time = System.currentTimeMillis();
        StringBuilder str = new StringBuilder(String.valueOf(time));
        String resource = null;
        Integer resourceType = authorizeToken.getResourceType();
        resource = ServiceType.getByValue((int)resourceType.intValue()).type;
        Integer authorizerType = authorizeToken.getAuthorizerType();
        resource = resource + AccessType.getByValue((int)authorizerType.intValue()).type;
        Integer authorizerWay = authorizeToken.getAuthorizeWay();
        resource = resource + AuthorizeType.getByValue((int)authorizerWay.intValue()).type;
        resource = this.ChangeAscII(resource);
        str.reverse();
        str.append(resource);
        return str.toString();
    }

    public String ChangeAscII(String value) {
        StringBuffer sbu = new StringBuffer();
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            sbu.append((int)chars[i]);
        }
        return sbu.toString();
    }

    public String initProxyUrl(String url) {
        int index = url.indexOf("/", url.indexOf("/") + 2);
        return url.substring(index);
    }

    public SysUserDTO getUserInfo(String id, Integer type) throws Exception {
        SysUserDTO user = new SysUserDTO();
        user.setUsername("admin");
        user.setId("1");
        user.setAlisname("\u7ba1\u7406\u5458");
        return user;
    }

    private String queryTokenByAuthorizeInfo(AuthorizeToken authorizeToken) {
        String token = null;
        if (this.oneToken.booleanValue()) {
            LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.eq(AuthorizeToken::getAuthorizerType, (Object)authorizeToken.getAuthorizerType());
            queryWrapper.eq(AuthorizeToken::getAuthorizerId, (Object)authorizeToken.getAuthorizerId());
            queryWrapper.last("LIMIT 1");
            queryWrapper.orderByDesc(AuthorizeToken::getUpdateTime);
            AuthorizeToken qToken = (AuthorizeToken)this.getOne((Wrapper)queryWrapper);
            if (qToken != null) {
                token = qToken.getToken();
            }
        }
        if (StrUtil.isBlank(token)) {
            token = this.createToken(authorizeToken);
        }
        return token;
    }

    private void verifaictionFrequency(String frequency) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)frequency)) {
            Boolean flag = true;
            List list = JSONObject.parseArray((String)frequency, JSONObject.class);
            if (list.size() > 1) {
                block4: for (int i = 0; i < list.size() && flag.booleanValue(); ++i) {
                    LocalTime endFri;
                    LocalTime strFri;
                    JSONArray time = ((JSONObject)list.get(i)).getJSONArray("time");
                    String type = ((JSONObject)list.get(i)).getString("type");
                    if (time == null || "".equals(time.getString(0)) || "".equals(time.getString(1))) {
                        flag = false;
                        break;
                    }
                    DateTimeFormatter pattern = type.equals("HOURS") ? DateTimeFormatter.ofPattern("HH") : DateTimeFormatter.ofPattern("HH:mm");
                    try {
                        strFri = LocalTime.parse(time.getString(0), pattern);
                        endFri = LocalTime.parse(time.getString(1), pattern);
                    }
                    catch (Exception e) {
                        pattern = DateTimeFormatter.ofPattern("HH:mm");
                        strFri = LocalTime.parse(time.getString(0), pattern);
                        endFri = LocalTime.parse(time.getString(1), pattern);
                    }
                    for (int j = i + 1; j < list.size() && flag.booleanValue(); ++j) {
                        LocalTime endSec;
                        LocalTime strSec;
                        JSONArray times = ((JSONObject)list.get(j)).getJSONArray("time");
                        String types = ((JSONObject)list.get(j)).getString("type");
                        if (times == null || "".equals(times.getString(0)) || "".equals(times.getString(1))) {
                            flag = false;
                            continue block4;
                        }
                        DateTimeFormatter patterns = types.equals("HOURS") ? DateTimeFormatter.ofPattern("HH") : DateTimeFormatter.ofPattern("HH:mm");
                        try {
                            strSec = LocalTime.parse(times.getString(0), patterns);
                            endSec = LocalTime.parse(times.getString(1), patterns);
                        }
                        catch (Exception e) {
                            patterns = DateTimeFormatter.ofPattern("HH:mm");
                            strSec = LocalTime.parse(times.getString(0), patterns);
                            endSec = LocalTime.parse(times.getString(1), patterns);
                        }
                        if (strSec.compareTo(strFri) == 1 && strSec.compareTo(endFri) == -1) {
                            flag = false;
                            continue;
                        }
                        if (endSec.compareTo(strFri) == 1 && endSec.compareTo(endFri) == -1) {
                            flag = false;
                            continue;
                        }
                        if (strFri.compareTo(strSec) == 1 && strFri.compareTo(endSec) == -1) {
                            flag = false;
                            continue;
                        }
                        if (endFri.compareTo(strSec) == 1 && endFri.compareTo(endSec) == -1) {
                            flag = false;
                            continue;
                        }
                        if (strSec.compareTo(strFri) != 0 || endSec.compareTo(endFri) != 0) continue;
                        flag = false;
                    }
                }
                if (!flag.booleanValue()) {
                    throw new Exception("\u65f6\u6bb5\u5b58\u5728\u51b2\u7a81\uff01");
                }
            }
        }
    }

    private String getProxyURL() {
        SysParamDTO api = this.sysParamsService.getDetail(SysParamGroupEnum.API.value, SysParamGroupEnum.API_PROXY_URL.value);
        return api.getValue();
    }
}

