/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.service.impl.export;

import com.alibaba.excel.util.StringUtils;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.datasource.dto.district.DistrictItemDTO;
import com.geoway.adf.dms.datasource.service.DistrictService;
import com.geoway.ns.zyfx.domain.ZyfxObjectApply;
import com.geoway.ns.zyfx.dto.ZyfxObjectDetail;
import com.geoway.ns.zyfx.service.ExportTaskParamsService;
import com.geoway.ns.zyfx.service.ZyfxObjectService;
import com.geoway.webstore.export.constant.ExportRasterFormatEnum;
import com.geoway.webstore.export.constant.ExportTypeEnum;
import com.geoway.webstore.export.dto.ExportCustomTaskUnitDTO;
import com.geoway.webstore.export.params.ExportTaskLayerParams;
import com.geoway.webstore.export.params.ExportTaskRasterParams;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RasterDataTaskParamsServiceImpl
implements ExportTaskParamsService {
    @Autowired
    private DistrictService districtService;
    @Autowired
    private ZyfxObjectService zyfxObjectService;

    @Override
    public ExportCustomTaskUnitDTO toExportTaskLayerParams(String outputPath, ZyfxObjectApply shareDataApplyDetail) {
        DistrictItemDTO targetDistrictItemDTO = ExportTaskParamsService.getTargetDistrictItemDTO(shareDataApplyDetail);
        int targetLevel = ExportTaskParamsService.getTargetXzqDistrictLevel(shareDataApplyDetail);
        ArrayList<ExportTaskLayerParams> outputParams = new ArrayList<ExportTaskLayerParams>();
        ZyfxObjectDetail zyfxObjectDetail = this.zyfxObjectService.findDetailById(shareDataApplyDetail.getObjectid(), false, false);
        String realDatasetId = ExportTaskParamsService.getRealDatasetId(zyfxObjectDetail);
        this.getExportTaskLayerParams(outputPath, targetDistrictItemDTO, shareDataApplyDetail, realDatasetId, targetLevel, outputParams);
        ExportCustomTaskUnitDTO taskUnitDTO = new ExportCustomTaskUnitDTO();
        taskUnitDTO.setName(shareDataApplyDetail.getObjectname());
        taskUnitDTO.setTaskLayerParamsList(outputParams);
        return taskUnitDTO;
    }

    private void getExportTaskLayerParams(String parentPath, DistrictItemDTO districtItemDTO, ZyfxObjectApply shareDataApplyDetail, String targetDatasetId, int targetOrgLevel, List<ExportTaskLayerParams> params) {
        if (shareDataApplyDetail == null || StringUtils.isEmpty((CharSequence)shareDataApplyDetail.getParams())) {
            return;
        }
        JSONObject paramJson = JSONObject.parseObject((String)shareDataApplyDetail.getParams());
        if (districtItemDTO.getLevelIndex() == targetOrgLevel) {
            String targetPath = Paths.get(parentPath, String.format("%s_%s", districtItemDTO.getName(), districtItemDTO.getCode())).toFile().getAbsolutePath();
            File targetFile = new File(targetPath);
            if (!targetFile.exists()) {
                targetFile.mkdirs();
            }
            targetPath = Paths.get(targetPath, shareDataApplyDetail.getObjectname() + "." + this.getExportSuffix(shareDataApplyDetail)).toFile().getAbsolutePath();
            ExportTaskRasterParams vectorParams = new ExportTaskRasterParams();
            vectorParams.setFormat(this.getExportFormat(shareDataApplyDetail));
            vectorParams.setSrid(Integer.valueOf(4490));
            vectorParams.setDatasetId(targetDatasetId);
            vectorParams.setType(ExportTypeEnum.GEOMETRY);
            vectorParams.setGeometry(this.districtService.getDistrictItemGeometry(districtItemDTO.getId()).toWkt());
            vectorParams.setCondition(paramJson.getString("filter"));
            vectorParams.setRelation("Intersects");
            vectorParams.setTargetPath(targetPath);
            vectorParams.setTargetName(shareDataApplyDetail.getObjectname());
            params.add((ExportTaskLayerParams)vectorParams);
        } else {
            List childDistrictItems = this.districtService.getDistrictItem(districtItemDTO.getDistrictId(), null, districtItemDTO.getCode(), "", Boolean.valueOf(false), Integer.valueOf(10000));
            String tempPath = Paths.get(parentPath, String.format("%s_%s", districtItemDTO.getName(), districtItemDTO.getCode())).toFile().getPath();
            for (DistrictItemDTO childDistrictItem : childDistrictItems) {
                this.getExportTaskLayerParams(tempPath, childDistrictItem, shareDataApplyDetail, targetDatasetId, targetOrgLevel, params);
            }
        }
    }

    private ExportRasterFormatEnum getExportFormat(ZyfxObjectApply shareDataApplyDetail) {
        if (shareDataApplyDetail == null || StringUtils.isEmpty((CharSequence)shareDataApplyDetail.getParams())) {
            return null;
        }
        JSONObject paramJson = JSONObject.parseObject((String)shareDataApplyDetail.getParams());
        if (paramJson == null || !paramJson.containsKey((Object)"exportFormat")) {
            throw new RuntimeException("\u4e0d\u5305\u542bexportFormat\u5b57\u6bb5");
        }
        switch (paramJson.getString("exportFormat").toLowerCase()) {
            case "tiff": {
                return ExportRasterFormatEnum.TIFF;
            }
            case "image": {
                return ExportRasterFormatEnum.IMAGE;
            }
            case "grid": {
                return ExportRasterFormatEnum.GRID;
            }
        }
        return ExportRasterFormatEnum.TIFF;
    }

    private String getExportSuffix(ZyfxObjectApply shareDataApplyDetail) {
        if (shareDataApplyDetail == null || StringUtils.isEmpty((CharSequence)shareDataApplyDetail.getParams())) {
            return null;
        }
        JSONObject paramJson = JSONObject.parseObject((String)shareDataApplyDetail.getParams());
        if (paramJson == null || !paramJson.containsKey((Object)"exportFormat")) {
            throw new RuntimeException("\u4e0d\u5305\u542bexportFormat\u5b57\u6bb5");
        }
        switch (paramJson.getString("exportFormat").toLowerCase()) {
            case "tiff": {
                return "tiff";
            }
            case "image": {
                return "img";
            }
            case "grid": {
                return "";
            }
        }
        return "tiff";
    }
}

