/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.geoway.ns.sys.dto.BaseObjectResponse;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.dto.DataResponse;
import com.geoway.ns.sys.dto.EasyUIResponse;
import com.geoway.ns.sys.dto.SysUserDTO;
import com.geoway.ns.sys.service.impl.TokenServiceImpl;
import com.geoway.ns.sys.utils.MyRequestUtil;
import com.geoway.ns.zyfx.domain.DataDelivery;
import com.geoway.ns.zyfx.dto.RestServiceDeliveryQueryParams;
import com.geoway.ns.zyfx.service.DataDeliveryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6570\u636e\u6c47\u4ea4"})
@RestController
@RequestMapping(value={"dataDelivery/check"})
public class DataDeliveryCheckController {
    private static final Logger log = LoggerFactory.getLogger(DataDeliveryCheckController.class);
    @Resource
    private DataDeliveryService dataDeliveryService;
    @Autowired
    private TokenServiceImpl tokenService;

    @ApiOperation(value="2-\u5ba1\u6838")
    @RequestMapping(value={"/simpleCheck"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse simpleCheck(HttpServletRequest request, @RequestParam(value="checkstatus", defaultValue="0", required=false) Integer checkstatus, @RequestParam(value="comment", required=false) String comment, @RequestParam(value="id") String id) {
        DataResponse response = new DataResponse();
        try {
            String token = MyRequestUtil.queryAccessTokenInHeader((HttpServletRequest)request);
            SysUserDTO sysUser = this.tokenService.querySysUserByToken(token);
            if (sysUser == null) {
                return DataResponse.error((String)"\u7cfb\u7edf\u672a\u767b\u5165");
            }
            if (!this.tokenService.isChecker(sysUser).booleanValue()) {
                return DataResponse.error((String)"\u5f53\u524d\u7528\u6237\u65e0\u5ba1\u6279\u6743\u9650");
            }
            DataDelivery dataDelivery = this.dataDeliveryService.queryShareExDeliveryInfoDetails(id, sysUser);
            dataDelivery.setStatus(checkstatus);
            dataDelivery.setReviewremark(comment);
            dataDelivery.setUpdateTime(new Date());
            if (checkstatus == 2 && "1".equals(dataDelivery.getType())) {
                this.dataDeliveryService.generateDeliveryCertificate(dataDelivery);
            }
            response.setResult((Object)this.dataDeliveryService.saveOne(sysUser, dataDelivery));
        }
        catch (Exception ex) {
            response.markFailure(ex.getMessage());
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return response;
    }

    @ApiOperation(value="\u6839\u636eid\u5220\u9664")
    @RequestMapping(value={"deleteById"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse deleteById(HttpServletRequest request, String id) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            String token = MyRequestUtil.queryAccessTokenInHeader((HttpServletRequest)request);
            SysUserDTO sysUser = this.tokenService.querySysUserByToken(token);
            if (sysUser == null) {
                return DataResponse.error((String)"\u7cfb\u7edf\u672a\u767b\u5165");
            }
            response.setData((Object)this.dataDeliveryService.deleteById(sysUser, id));
        }
        catch (Exception e) {
            return BaseResponse.buildFailuaResponse((String)e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @RequestMapping(value={"/searchPage.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public EasyUIResponse searchPage(HttpServletRequest request, RestServiceDeliveryQueryParams params, @RequestParam(value="token", required=false) String token) {
        EasyUIResponse response = new EasyUIResponse();
        try {
            if (StringUtils.isEmpty((CharSequence)token)) {
                token = MyRequestUtil.queryAccessTokenInHeader((HttpServletRequest)request);
            }
            SysUserDTO sysUser = this.tokenService.querySysUserByToken(token);
            params.setUserId(sysUser.getId());
            if (StrUtil.isBlank((CharSequence)params.getOrder())) {
                params.setOrder("f_createtime");
            }
            if (StrUtil.isBlank((CharSequence)params.getOrderType())) {
                params.setOrderType("desc");
            }
            IPage<DataDelivery> resultPage = this.dataDeliveryService.searchPage(params, sysUser);
            response.setRows(resultPage.getRecords());
            response.setTotal(Long.valueOf(resultPage.getTotal()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            response.markFailure();
            response.setMessage(ex.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u8bbe\u7f6e\u6d88\u606f\u4e3a\u5df2\u8bfb")
    @PostMapping(value={"setHasReadById"}, produces={"application/json;charset=UTF-8"})
    public BaseObjectResponse setHasReadById(HttpServletRequest request, @RequestParam(value="id") String id, @RequestParam(value="hasRead", required=false, defaultValue="1") Integer hasRead) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            this.dataDeliveryService.setHasReadById(id, hasRead);
        }
        catch (Exception ex) {
            response.markFailure();
            response.setMessage(ex.getMessage());
        }
        return response;
    }

    @RequestMapping(value={"/query-shareExDeliveryInfoDetails"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseResponse queryShareExDeliveryInfoDetails(String id, HttpServletRequest request, @RequestParam(value="token", required=false) String token) {
        BaseObjectResponse responseDataBase = new BaseObjectResponse();
        try {
            if (StringUtils.isEmpty((CharSequence)token)) {
                token = MyRequestUtil.queryAccessTokenInHeader((HttpServletRequest)request);
            }
            SysUserDTO sysUser = this.tokenService.querySysUserByToken(token);
            DataDelivery dataDelivery = this.dataDeliveryService.queryShareExDeliveryInfoDetails(id, sysUser);
            responseDataBase.setData((Object)dataDelivery);
        }
        catch (Exception e) {
            return BaseObjectResponse.error((String)e.getMessage());
        }
        return responseDataBase;
    }
}

