/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.service.impl.export;

import com.alibaba.excel.util.StringUtils;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.datasource.dto.district.DistrictItemDTO;
import com.geoway.adf.dms.datasource.service.DistrictService;
import com.geoway.ns.zyfx.domain.ZyfxObjectApply;
import com.geoway.ns.zyfx.dto.ZyfxObjectDetail;
import com.geoway.ns.zyfx.service.ExportTaskParamsService;
import com.geoway.ns.zyfx.service.ZyfxObjectService;
import com.geoway.webstore.export.dto.ExportCustomTaskUnitDTO;
import com.geoway.webstore.export.params.ExportTaskDatumParams;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DatumDataTaskParamsServiceImpl
implements ExportTaskParamsService {
    @Autowired
    private DistrictService districtService;
    @Autowired
    private ZyfxObjectService zyfxObjectService;

    @Override
    public ExportCustomTaskUnitDTO toExportTaskLayerParams(String outputPath, ZyfxObjectApply shareDataApplyDetail) {
        DistrictItemDTO targetDistrictItemDTO = ExportTaskParamsService.getTargetDistrictItemDTO(shareDataApplyDetail);
        ArrayList<ExportTaskDatumParams> outputParams = new ArrayList<ExportTaskDatumParams>();
        ZyfxObjectDetail zyfxObjectDetail = this.zyfxObjectService.findDetailById(shareDataApplyDetail.getObjectid(), false, false);
        String realDatasetId = ExportTaskParamsService.getRealDatasetId(zyfxObjectDetail);
        ExportTaskDatumParams taskDatumParams = this.getExportTaskLayerParams(outputPath, targetDistrictItemDTO, shareDataApplyDetail, realDatasetId);
        outputParams.add(taskDatumParams);
        ExportCustomTaskUnitDTO taskUnitDTO = new ExportCustomTaskUnitDTO();
        taskUnitDTO.setName(shareDataApplyDetail.getObjectname());
        taskUnitDTO.setTaskLayerParamsList(outputParams);
        return taskUnitDTO;
    }

    private ExportTaskDatumParams getExportTaskLayerParams(String parentPath, DistrictItemDTO districtItemDTO, ZyfxObjectApply shareDataApplyDetail, String targetDatasetId) {
        if (shareDataApplyDetail == null || StringUtils.isEmpty((CharSequence)shareDataApplyDetail.getParams())) {
            return null;
        }
        JSONObject paramJson = JSONObject.parseObject((String)shareDataApplyDetail.getParams());
        if (paramJson == null || !paramJson.containsKey((Object)"filter")) {
            throw new RuntimeException("\u4e0d\u5305\u542bfilter\u8fc7\u6ee4\u5b57\u6bb5");
        }
        String targetPath = Paths.get(parentPath, String.format("%s_%s", districtItemDTO.getName(), districtItemDTO.getCode())).toFile().getPath();
        File targetFile = new File(targetPath);
        if (!targetFile.exists()) {
            targetFile.mkdirs();
        }
        ExportTaskDatumParams vectorParams = new ExportTaskDatumParams();
        vectorParams.setDatasetId(targetDatasetId);
        vectorParams.setGeometry(this.districtService.getDistrictItemGeometry(districtItemDTO.getId()).toWkt());
        vectorParams.setCondition(paramJson.getString("filter"));
        vectorParams.setRelation("Intersects");
        vectorParams.setTargetPath(targetPath);
        vectorParams.setTargetName(shareDataApplyDetail.getObjectname());
        return vectorParams;
    }
}

