ALTER TABLE tb_zyfx_catalog_scheme ADD f_pid varchar(50) NULL;
COMMENT ON COLUMN tb_zyfx_catalog_scheme.f_pid IS '父节点ID';
ALTER TABLE tb_zyfx_catalog_scheme ADD f_grouptype varchar(50) NULL;
COMMENT ON COLUMN tb_zyfx_catalog_scheme.f_grouptype IS '限制目录支持数据类型：1数据集、2服务集、3工具集；3-0工具集、3-1应用集、3-2模型集；null未不限定';

-- 先尝试更新
UPDATE tb_zyfx_catalog_scheme
SET f_name='数据资源', f_key='sjzy', f_sort=1, f_createtime='2024-06-21 17:21:00.000', f_isdefault=1, f_pid='-1', f_grouptype=NULL
WHERE f_id='1';
UPDATE tb_zyfx_catalog_scheme
SET f_name='项目资源', f_key='xmzy', f_sort=2, f_createtime='2024-06-25 17:21:00.000', f_isdefault=0, f_pid='-1', f_grouptype=NULL
WHERE f_id='3';
UPDATE tb_zyfx_catalog_scheme
SET f_name='机构资源', f_key='jgzy', f_sort=3, f_createtime='2024-06-25 17:21:00.000', f_isdefault=0, f_pid='-1', f_grouptype=NULL
WHERE f_id='2';
UPDATE tb_zyfx_catalog_scheme
SET f_name='数据资源目录', f_key='sjzyml', f_sort=1, f_createtime='2024-06-27 17:21:00.000', f_isdefault=0, f_pid='-1', f_grouptype='1'
WHERE f_id='-10000';
UPDATE tb_zyfx_catalog_scheme
SET f_name='服务资源目录', f_key='fwzyml', f_sort=2, f_createtime='2024-06-26 17:21:00.000', f_isdefault=0, f_pid='-1', f_grouptype='2'
WHERE f_id='-10001';
UPDATE tb_zyfx_catalog_scheme
SET f_name='应用资源目录', f_key='gjzyml', f_sort=3, f_createtime='2024-06-26 17:21:00.000', f_isdefault=0, f_pid='-1', f_grouptype='3'
WHERE f_id='-10002';
-- 若未更新到数据则插入
INSERT INTO tb_zyfx_catalog_scheme
(f_id, f_name, f_key, f_sort, f_createtime, f_isdefault, f_pid, f_grouptype)
SELECT '1', '数据资源', 'sjzy', 1, '2024-06-21 17:21:00.000', 1, '-1', NULL WHERE NOT EXISTS (SELECT 1 FROM tb_zyfx_catalog_scheme WHERE f_id='1');
INSERT INTO tb_zyfx_catalog_scheme
(f_id, f_name, f_key, f_sort, f_createtime, f_isdefault, f_pid, f_grouptype)
SELECT '3', '项目资源', 'xmzy', 2, '2024-06-25 17:21:00.000', 0, '-1', NULL WHERE NOT EXISTS (SELECT 1 FROM tb_zyfx_catalog_scheme WHERE f_id='3');
INSERT INTO tb_zyfx_catalog_scheme
(f_id, f_name, f_key, f_sort, f_createtime, f_isdefault, f_pid, f_grouptype)
SELECT '2', '机构资源', 'jgzy', 3, '2024-06-25 17:21:00.000', 0, '-1', NULL WHERE NOT EXISTS (SELECT 1 FROM tb_zyfx_catalog_scheme WHERE f_id='2');
INSERT INTO tb_zyfx_catalog_scheme
(f_id, f_name, f_key, f_sort, f_createtime, f_isdefault, f_pid, f_grouptype)
SELECT '-10000', '服务资源目录', 'sjzyml', 1, '2024-06-27 17:21:00.000', 0, '-1', '1' WHERE NOT EXISTS (SELECT 1 FROM tb_zyfx_catalog_scheme WHERE f_id='-10000');
INSERT INTO tb_zyfx_catalog_scheme
(f_id, f_name, f_key, f_sort, f_createtime, f_isdefault, f_pid, f_grouptype)
SELECT '-10001', '服务资源目录', 'fwzyml', 2, '2024-06-26 17:21:00.000', 0, '-1', '2' WHERE NOT EXISTS (SELECT 1 FROM tb_zyfx_catalog_scheme WHERE f_id='-10001');
INSERT INTO tb_zyfx_catalog_scheme
(f_id, f_name, f_key, f_sort, f_createtime, f_isdefault, f_pid, f_grouptype)
SELECT '-10002', '应用资源目录', 'gjzyml', 3, '2024-06-26 17:21:00.000', 0, '-1', '3' WHERE NOT EXISTS (SELECT 1 FROM tb_zyfx_catalog_scheme WHERE f_id='-10002');

INSERT INTO tb_zyfx_catalog_scheme
(f_id, f_name, f_key, f_sort, f_createtime, f_isdefault, f_pid, f_grouptype)
SELECT '11', '数据集', 'sjj', 1, '2024-06-27 17:21:00.000', 0, '1', '1' WHERE NOT EXISTS (SELECT 1 FROM tb_zyfx_catalog_scheme WHERE f_id='11');
INSERT INTO tb_zyfx_catalog_scheme
(f_id, f_name, f_key, f_sort, f_createtime, f_isdefault, f_pid, f_grouptype)
SELECT '12', '服务集', 'fwj', 2, '2024-06-26 17:21:00.000', 0, '1', '2' WHERE NOT EXISTS (SELECT 1 FROM tb_zyfx_catalog_scheme WHERE f_id='12');
INSERT INTO tb_zyfx_catalog_scheme
(f_id, f_name, f_key, f_sort, f_createtime, f_isdefault, f_pid, f_grouptype)
SELECT '13', '工具集', 'gjj', 3, '2024-06-26 17:21:00.000', 0, '1', '3-0' WHERE NOT EXISTS (SELECT 1 FROM tb_zyfx_catalog_scheme WHERE f_id='13');
INSERT INTO tb_zyfx_catalog_scheme
(f_id, f_name, f_key, f_sort, f_createtime, f_isdefault, f_pid, f_grouptype)
SELECT '14', '应用集', 'yyj', 4, '2025-05-16 17:21:00.000', 0, '1', '3-1' WHERE NOT EXISTS (SELECT 1 FROM tb_zyfx_catalog_scheme WHERE f_id='14');
INSERT INTO tb_zyfx_catalog_scheme
(f_id, f_name, f_key, f_sort, f_createtime, f_isdefault, f_pid, f_grouptype)
SELECT '15', '模型集', 'mxj', 5, '2025-05-16 17:21:00.000', 0, '1', '3-2' WHERE NOT EXISTS (SELECT 1 FROM tb_zyfx_catalog_scheme WHERE f_id='15');
--更新tb_zyfx_catalog表
UPDATE tb_zyfx_catalog
SET f_pid='-1',f_schemeid='11'
WHERE f_pid ='1001';

UPDATE tb_zyfx_catalog
SET f_pid='-1',f_schemeid='12'
WHERE f_pid ='1002';

UPDATE tb_zyfx_catalog
SET f_pid = '-1',
    f_schemeid = '13'
WHERE f_id IN (
    SELECT tzc_inner.f_id
    FROM tb_zyfx_catalog tzc_inner
    JOIN tb_zyfx_catalog_object tzco ON tzc_inner.f_id = tzco.f_catalogid
    JOIN tb_zyfx_toolset tzt ON tzco.f_objectid = tzt.f_id
    WHERE tzc_inner.f_pid = '1003'
    AND tzt.f_isapplication = 0
);

UPDATE tb_zyfx_catalog
SET f_pid = '-1',
    f_schemeid = '14'
WHERE f_id IN (
    SELECT tzc.f_id
    FROM tb_zyfx_catalog tzc
    LEFT JOIN tb_zyfx_catalog_object tzco ON tzc.f_id = tzco.f_catalogid
    LEFT JOIN tb_zyfx_toolset tzt ON tzco.f_objectid = tzt.f_id
    WHERE tzc.f_pid = '1003'
    AND tzt.f_isapplication = 1
);

UPDATE tb_zyfx_catalog
SET f_pid = '-1',
    f_schemeid = '15'
WHERE f_id IN (
    SELECT tzc.f_id
    FROM tb_zyfx_catalog tzc
    LEFT JOIN tb_zyfx_catalog_object tzco ON tzc.f_id = tzco.f_catalogid
    LEFT JOIN tb_zyfx_toolset tzt ON tzco.f_objectid = tzt.f_id
    WHERE tzc.f_pid = '1003'
    AND tzt.f_isapplication = 2
);

UPDATE tb_zyfx_catalog
SET f_pid='-1',f_schemeid='13'
WHERE f_pid ='1003';

UPDATE tb_zyfx_catalog
SET f_schemeid='11'
WHERE f_grouptype ='1' and f_schemeid='1';

UPDATE tb_zyfx_catalog
SET f_schemeid='12'
WHERE f_grouptype ='2' and f_schemeid='1';

UPDATE tb_zyfx_catalog_object
SET f_schemeid='11'
WHERE f_grouptype ='1' and f_schemeid='1';

UPDATE tb_zyfx_catalog_object
SET f_schemeid='12'
WHERE f_grouptype ='2' and f_schemeid='1';

INSERT INTO tb_zyfx_catalog
(f_id, f_pid, f_name, f_bm, f_nodetype, f_grouptype, f_code, f_schemeid, f_oid, f_bz, f_level, f_params, f_imgid, f_logoid, f_sort)
SELECT tzc.f_id||'-1', f_pid, f_name, f_bm, f_nodetype, tzc.f_grouptype, f_code,'14' as f_schemeid, f_oid, f_bz, f_level, f_params, f_imgid, f_logoid, tzc.f_sort FROM tb_zyfx_catalog AS tzc
left join tb_zyfx_catalog_object tzco on tzc.f_id =tzco.f_catalogid
left join tb_zyfx_toolset tzt on tzco.f_objectid =tzt.f_id
where tzt.f_isapplication =1 and tzc.f_schemeid='13' ;

INSERT INTO tb_zyfx_catalog_object
(f_id, f_catalogid, f_catalogcode, f_objectid, f_grouptype, f_schemeid, f_sort)
SELECT tzco.f_id||'-1' as f_id, f_catalogid||'-1' as f_catalogid, f_catalogcode, f_objectid, tzco.f_grouptype, tzco.f_schemeid, tzco.f_sort FROM  tb_zyfx_catalog_object tzco
left join tb_zyfx_toolset tzt on tzco.f_objectid =tzt.f_id
where tzt.f_isapplication =1 and tzco.f_schemeid='13' ;

INSERT INTO tb_zyfx_catalog
(f_id, f_pid, f_name, f_bm, f_nodetype, f_grouptype, f_code, f_schemeid, f_oid, f_bz, f_level, f_params, f_imgid, f_logoid, f_sort)
SELECT tzc.f_id||'-2', f_pid, f_name, f_bm, f_nodetype,tzc.f_grouptype, f_code,'15' as f_schemeid, f_oid, f_bz, f_level, f_params, f_imgid, f_logoid, tzc.f_sort FROM tb_zyfx_catalog AS tzc
left join tb_zyfx_catalog_object tzco on tzc.f_id =tzco.f_catalogid
left join tb_zyfx_toolset tzt on tzco.f_objectid =tzt.f_id
where tzt.f_isapplication =2 and tzc.f_schemeid='13' ;

INSERT INTO tb_zyfx_catalog_object
(f_id, f_catalogid, f_catalogcode, f_objectid, f_grouptype, f_schemeid, f_sort)
SELECT tzco.f_id||'-2' as f_id, f_catalogid||'-2' as f_catalogid, f_catalogcode, f_objectid, tzco.f_grouptype, tzco.f_schemeid, tzco.f_sort FROM  tb_zyfx_catalog_object tzco
left join tb_zyfx_toolset tzt on tzco.f_objectid =tzt.f_id
where tzt.f_isapplication =2 and tzco.f_schemeid='13' ;

UPDATE tb_zyfx_catalog_object
SET f_schemeid='13'
WHERE f_grouptype ='3' and f_schemeid='1';
UPDATE tb_zyfx_catalog
SET f_schemeid='13'
WHERE f_grouptype ='3' and f_schemeid='1';

