-- 汇交表
CREATE TABLE tb_share_datadelivery (
   f_id varchar(64),
   f_number varchar(64),
   f_person varchar(64) ,
   f_phone varchar(64) ,
   f_office varchar(64) ,
   f_updatetime timestamp,
   f_createtime timestamp,
   f_createuser varchar(64),
   f_dataname varchar(128),
   f_datasize float8,
   f_datatype varchar(128),
   f_quantity numeric(64),
   f_quantityunit varchar(64) ,
   f_receiver varchar(64),
   f_unittype varchar(64),
   f_type int2,
   f_time date,
   f_datasummary text,
   f_unit varchar(255),
   f_scale varchar(64),
   f_project varchar(128),
   f_hasread int2,
   f_datastage varchar(32),
   f_projectleader varchar(64),
   f_projectleadertel varchar(32),
   f_remark varchar(1024),
   f_savepath varchar(2048),
   f_status int2,
   f_reviewremark text,
   f_hjcertificate text
);

-- Column comments
COMMENT ON COLUMN  tb_share_datadelivery.f_number IS '汇交单编号';
COMMENT ON COLUMN  tb_share_datadelivery.f_person IS '汇交人';
COMMENT ON COLUMN  tb_share_datadelivery.f_phone IS '汇交人电话';
COMMENT ON COLUMN  tb_share_datadelivery.f_office IS '主管部门';
COMMENT ON COLUMN  tb_share_datadelivery.f_createuser IS '创建人';
COMMENT ON COLUMN  tb_share_datadelivery.f_dataname IS '创建人姓名';
COMMENT ON COLUMN  tb_share_datadelivery.f_datasize IS '数据量（GB）';
COMMENT ON COLUMN  tb_share_datadelivery.f_datatype IS '数据类型';
COMMENT ON COLUMN  tb_share_datadelivery.f_quantity IS '数目';
COMMENT ON COLUMN  tb_share_datadelivery.f_quantityunit IS '数目单位';
COMMENT ON COLUMN  tb_share_datadelivery.f_receiver IS '接收人';
COMMENT ON COLUMN  tb_share_datadelivery.f_unittype IS '汇交单位类型';
COMMENT ON COLUMN  tb_share_datadelivery.f_type IS '汇交类型（1=线上，2=线下）';
COMMENT ON COLUMN  tb_share_datadelivery.f_time IS '接收时间';
COMMENT ON COLUMN  tb_share_datadelivery.f_datasummary IS '数据明细';
COMMENT ON COLUMN  tb_share_datadelivery.f_unit IS '汇交单位';
COMMENT ON COLUMN  tb_share_datadelivery.f_scale IS '比例尺';
COMMENT ON COLUMN  tb_share_datadelivery.f_project IS '所属单位';
COMMENT ON COLUMN  tb_share_datadelivery.f_hasread IS '已读否';
COMMENT ON COLUMN  tb_share_datadelivery.f_datastage IS '数据阶段';
COMMENT ON COLUMN  tb_share_datadelivery.f_projectleader IS '项目负责人';
COMMENT ON COLUMN  tb_share_datadelivery.f_projectleadertel IS '项目负责人电话';
COMMENT ON COLUMN  tb_share_datadelivery.f_remark IS '备注';
COMMENT ON COLUMN  tb_share_datadelivery.f_savepath IS '存盘';
COMMENT ON COLUMN  tb_share_datadelivery.f_status IS '（0.未审核 1.审核中 2审核通过 3审核不通过 4退回）';
COMMENT ON COLUMN  tb_share_datadelivery.f_reviewremark IS '审核备注';
COMMENT ON COLUMN  tb_share_datadelivery.f_hjcertificate IS '汇交凭证';

ALTER TABLE tb_share_datadelivery ADD CONSTRAINT pk_share_datadelivery_id PRIMARY KEY (f_id);
ALTER TABLE tb_share_datadelivery ADD CONSTRAINT uk_share_datadelivery_number UNIQUE(f_id);


--数据汇交文件表
CREATE TABLE tb_share_datadelivery_file (
    f_id varchar(64),
    f_formid varchar(64),
    f_name varchar(128),
    f_size varchar(64),
    f_style varchar(255),
    f_path varchar(255),
    f_createuser varchar(64),
    f_updatetime timestamp,
    f_createtime timestamp,
    f_downloadurl varchar(512),
    f_partcount float4
);

-- Column comments

COMMENT ON COLUMN tb_share_datadelivery_file.f_id IS '唯一标识';
COMMENT ON COLUMN tb_share_datadelivery_file.f_formid IS '分发表单id';
COMMENT ON COLUMN tb_share_datadelivery_file.f_name IS '附件名称';
COMMENT ON COLUMN tb_share_datadelivery_file.f_size IS '附件大小';
COMMENT ON COLUMN tb_share_datadelivery_file.f_style IS '附件类型';
COMMENT ON COLUMN tb_share_datadelivery_file.f_path IS '附件上传路径';
COMMENT ON COLUMN tb_share_datadelivery_file.f_createuser IS '创建用户';
COMMENT ON COLUMN tb_share_datadelivery_file.f_updatetime IS '更新时间';
COMMENT ON COLUMN tb_share_datadelivery_file.f_createtime IS '创建时间';
COMMENT ON COLUMN tb_share_datadelivery_file.f_downloadurl IS '附件下载地址';
COMMENT ON COLUMN tb_share_datadelivery_file.f_partcount IS '分段上传段数';

ALTER TABLE tb_share_datadelivery_file ADD CONSTRAINT pk_share_datadelivery_file_id PRIMARY KEY (f_id);