/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.controller;

import cn.hutool.core.util.StrUtil;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.dto.RowsResponse;
import com.geoway.ns.zyfx.domain.ZyfxOrganization;
import com.geoway.ns.zyfx.service.ZyfxOrganizationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u673a\u6784\u63a5\u53e3"})
@RestController
@RequestMapping(value={"zyfx/org"})
public class ZyfxOrgController {
    private static final Logger log = LoggerFactory.getLogger(ZyfxOrgController.class);
    @Resource
    ZyfxOrganizationService zyfxOrganizationService;

    @ApiOperation(value="\u67e5\u8be2\u673a\u6784\u6811")
    @GetMapping(value={"listTree"}, produces={"application/json;charset=UTF-8"})
    public RowsResponse listTree(HttpServletRequest request, @RequestParam(value="filterParam", required=false, defaultValue="") String filterParam, @RequestParam(value="sortParam", required=false, defaultValue="") String sortParam) {
        RowsResponse response = new RowsResponse();
        try {
            if (StrUtil.isEmpty((CharSequence)sortParam)) {
                sortParam = "SORT_sort_ASC";
            }
            List<ZyfxOrganization> organizations = this.zyfxOrganizationService.queryTree(filterParam, sortParam);
            response.setRows(organizations);
            response.setTotal(Long.valueOf(organizations.size()));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u5220\u9664\u76ee\u5f55\u8282\u70b9")
    @PostMapping(value={"delete"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse deleteCatalog(HttpServletRequest request, String id) {
        BaseResponse response = new BaseResponse();
        if (StrUtil.isNotEmpty((CharSequence)id)) {
            try {
                this.zyfxOrganizationService.removeById((Serializable)((Object)id));
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error(e.getMessage(), (Throwable)e);
                response.markFailure(e.getMessage());
            }
        }
        return response;
    }

    @ApiOperation(value="\u4fdd\u5b58\u76ee\u5f55\u8282\u70b9")
    @PostMapping(value={"save"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse saveCatalog(HttpServletRequest request, @ModelAttribute ZyfxOrganization org) {
        BaseResponse response = new BaseResponse();
        try {
            this.zyfxOrganizationService.saveOrganization(org);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }
}

