/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.monitor.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.geoway.ns.proxy.constant.enums.TokenModel;
import com.geoway.ns.proxy.dto.ProxyObjectLimit;
import com.geoway.ns.proxy.entity.ProxyObject;
import com.geoway.ns.proxy.service.ProxyObjectService;
import com.geoway.ns.proxy.service.ProxyTokenService;
import com.geoway.ns.sys.dto.BaseObjectResponse;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.dto.RowsResponse;
import com.geoway.ns.sys.utils.ProxyUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u670d\u52a1\u4ee3\u7406\u5bf9\u8c61\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/proxyObject"})
public class ProxyObjectController {
    private static final Logger log = LoggerFactory.getLogger(ProxyObjectController.class);
    @Resource
    ProxyObjectService proxyObjectService;
    @Resource
    ProxyTokenService proxyTokenService;
    @Value(value="${share.proxy.url: }")
    private String proxyUrl;

    @ApiOperation(value="\u67e5\u8be2\u4ee3\u7406\u670d\u52a1\u5bf9\u8c61\u5217\u8868")
    @RequestMapping(value={"/list"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public RowsResponse listProxyObject(HttpServletRequest request, @RequestParam(value="filterParam", required=false, defaultValue="") String filterParam, @RequestParam(value="sortParam", required=false, defaultValue="") String sortParam, @RequestParam(value="serviceName", required=false, defaultValue="") String serviceName, @RequestParam(value="objectId") String objectId, @RequestParam(value="objectType") Integer objectType, @RequestParam(value="page", required=true) Integer page, @RequestParam(value="size", required=true) Integer size) {
        RowsResponse response = new RowsResponse();
        try {
            if (StrUtil.isEmpty((CharSequence)sortParam)) {
                sortParam = "SORT_createtime_ASC";
            }
            IPage objectList = this.proxyObjectService.queryAllProxyObjectByObject(objectId, objectType.intValue(), filterParam, sortParam, serviceName, page.intValue(), size.intValue());
            response.setRows(objectList.getRecords());
            response.setTotal(Long.valueOf(objectList.getTotal()));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u6279\u91cf\u6388\u6743\u670d\u52a1")
    @PostMapping(value={"/batchEmpower"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse addProxyObject(HttpServletRequest request, @RequestParam(value="objectId") String objectId, @RequestParam(value="objectName") String objectName, @RequestParam(value="objectType") Integer objectType, @RequestParam(value="serviceIds") String serviceIds, @ModelAttribute ProxyObjectLimit proxyObjectLimit) {
        BaseResponse response = new BaseResponse();
        try {
            this.proxyObjectService.batchAddProxyObject(objectId, objectName, objectType.intValue(), 2, serviceIds, proxyObjectLimit);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u5220\u9664\u670d\u52a1\u4ee3\u7406")
    @PostMapping(value={"/batchDelete"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse batchDelete(HttpServletRequest request, @RequestParam(value="ids") String ids) {
        BaseResponse response = new BaseResponse();
        try {
            this.proxyObjectService.batchDeleteProxyObject(ids);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u4fee\u6539\u4ee3\u7406\u72b6\u6001")
    @PostMapping(value={"/toggleEnable"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse toggleEnable(HttpServletRequest request, @RequestParam(value="ids") String ids, @RequestParam(value="enbale") boolean enbale) {
        BaseResponse response = new BaseResponse();
        try {
            this.proxyObjectService.toggleProxyObjectEnable(ids, enbale);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u6388\u6743\u670d\u52a1")
    @PostMapping(value={"/addOne"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse addProxyObject(HttpServletRequest request, @ModelAttribute ProxyObject proxyObject) {
        BaseResponse response = new BaseResponse();
        try {
            this.proxyObjectService.saveOneProxyObject(proxyObject.getAuthway().intValue(), proxyObject);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u670d\u52a1\u6388\u6743")
    @PostMapping(value={"/savelimit"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse savelimit(HttpServletRequest request, @RequestParam(value="ids") String ids, @ModelAttribute ProxyObjectLimit proxyObjectLimit) {
        BaseResponse response = new BaseResponse();
        try {
            this.proxyObjectService.saveLimitParams(ids, proxyObjectLimit);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u83b7\u53d6token")
    @GetMapping(value={"/getToken"}, produces={"application/json;charset=UTF-8"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="objectId", value="\u5bf9\u8c61id", required=true), @ApiImplicitParam(name="type", value="\u7c7b\u578b(0 \u4e34\u65f6 1.\u7528\u6237 2\u5e94\u7528)", required=true)})
    public BaseResponse getToken(HttpServletRequest request, @RequestParam(value="objectId") String objectId, @RequestParam(value="type") int type) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            TokenModel model = TokenModel.temp;
            if (type == 1) {
                model = TokenModel.User;
            } else if (type == 2) {
                model = TokenModel.application;
            }
            String token = this.proxyTokenService.fetchToken(objectId, "", model);
            response.setData((Object)token);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u83b7\u53d6\u4ee3\u7406\u5730\u5740")
    @PostMapping(value={"/queryProxyURL"}, produces={"application/json;charset=UTF-8"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="objectId", value="\u5bf9\u8c61id", required=true)})
    public BaseResponse queryProxyURL(HttpServletRequest request, @RequestParam(value="objectId") String objectId) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            String url = this.proxyObjectService.queryProxyURL2(this.proxyUrl, objectId);
            response.setData((Object)url);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u83b7\u53d6\u4ee3\u7406\u5730\u57402(\u901a\u8fc7\u4ee3\u7406\u670d\u52a1\u63a5\u53e3\u83b7\u53d6)")
    @PostMapping(value={"/queryProxyURL2"}, produces={"application/json;charset=UTF-8"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="objectId", value="\u5bf9\u8c61id", required=true)})
    public BaseResponse queryProxyURL2(HttpServletRequest request, @RequestParam(value="objectId") String objectId) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            String url = ProxyUtil.queryProxyURLByObjectId((String)objectId);
            response.setData((Object)url);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u670d\u52a1\u66f4\u65b0\u901a\u77e5")
    @PostMapping(value={"/updateService"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse updateService(HttpServletRequest request, String sid) {
        BaseResponse response = new BaseResponse();
        try {
            this.proxyObjectService.updateProxyRoute(sid);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }
}

