/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.controller;

import com.geoway.ns.sys.dto.DataResponse;
import com.geoway.ns.sys.utils.MyRequestUtil;
import com.geoway.ns.zyfx.dto.DataOverviewDTO;
import com.geoway.ns.zyfx.service.DataStatisticsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6570\u636e\u7edf\u8ba1"})
@RestController
@RequestMapping(value={"/zyfx/dataStatistics"})
public class DataStatisticsController {
    private static final Logger log = LoggerFactory.getLogger(DataStatisticsController.class);
    @Autowired
    DataStatisticsService dataStatisticsService;

    @ApiOperation(value="\u9996\u9875\u6570\u636e\u7edf\u8ba1")
    @GetMapping(value={"/dataOverview.json"})
    public DataResponse<DataOverviewDTO> dataOverview(HttpServletRequest request) {
        DataResponse response = new DataResponse();
        try {
            String token = MyRequestUtil.queryAccessTokenInHeader((HttpServletRequest)request);
            DataOverviewDTO dataOverviewDTO = this.dataStatisticsService.dataOverview(token);
            response.setResult((Object)dataOverviewDTO);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.markFailure(e.getMessage());
            throw new RuntimeException(e);
        }
        return response;
    }

    @ApiOperation(value="\u8d44\u6e90\u603b\u91cf\u7edf\u8ba1")
    @GetMapping(value={"/datasetsStatics.json"})
    public DataResponse<Map<String, Object>> datasetsStatics(HttpServletRequest request, @RequestParam(value="groupType") int groupType, @RequestParam(value="staticType", required=false, defaultValue="YYYY") String staticType, @RequestParam(value="isApplication", required=false) String isApplication, @RequestParam(value="filterParam", required=false, defaultValue="") String filterParam) {
        DataResponse response = new DataResponse();
        try {
            Map<String, Object> maps = this.dataStatisticsService.datasetsStatics(groupType, staticType, isApplication, filterParam);
            response.setResult(maps);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.markFailure(e.getMessage());
            throw new RuntimeException(e);
        }
        return response;
    }

    @ApiOperation(value="\u8d44\u6e90\u5206\u7ec4\u7edf\u8ba1")
    @GetMapping(value={"/datasetsStaticsByType.json"})
    public DataResponse<Map<String, Object>> datasetsStaticsByType(HttpServletRequest request, @RequestParam(value="staticType", required=false, defaultValue="YYYY") String staticType, @RequestParam(value="filterParam", required=false, defaultValue="") String filterParam) {
        DataResponse response = new DataResponse();
        try {
            Map<String, Object> maps = this.dataStatisticsService.datasetsStaticsByType(staticType, filterParam);
            response.setResult(maps);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.markFailure(e.getMessage());
            throw new RuntimeException(e);
        }
        return response;
    }

    @ApiOperation(value="\u6570\u636e\u7533\u8bf7\u4e0b\u8f7d\u7edf\u8ba1")
    @GetMapping(value={"/applyDataStatic.json"})
    public DataResponse<List<Map<String, Object>>> applyDataStatic(HttpServletRequest request, @RequestParam(value="filterParam", required=false, defaultValue="") String filterParam, @RequestParam(value="maxCount", required=false, defaultValue="10") int maxCount) {
        DataResponse response = new DataResponse();
        try {
            List<Map<String, Object>> maps = this.dataStatisticsService.applyDataStatic(filterParam, maxCount);
            response.setResult(maps);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.markFailure(e.getMessage());
            throw new RuntimeException(e);
        }
        return response;
    }

    @ApiOperation(value="\u6570\u636e\u7c7b\u578b\u7edf\u8ba1")
    @GetMapping(value={"/dataTypeStatic.json"})
    public DataResponse<List<Map<String, Object>>> dataTypeStatic(HttpServletRequest request, @RequestParam(value="filterParam", required=false, defaultValue="") String filterParam) {
        DataResponse response = new DataResponse();
        try {
            List<Map<String, Object>> maps = this.dataStatisticsService.dataTypeStatic(filterParam);
            response.setResult(maps);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.markFailure(e.getMessage());
            throw new RuntimeException(e);
        }
        return response;
    }

    @ApiOperation(value="\u5ba1\u6279\u7c7b\u578b\u7edf\u8ba1")
    @GetMapping(value={"/applyTypeStatic.json"})
    public DataResponse<List<Map<String, Object>>> applyTypeStatic(HttpServletRequest request, @RequestParam(value="filterParam", required=false, defaultValue="") String filterParam, @RequestParam(value="staticType", required=false, defaultValue="YYYY") String staticType) {
        DataResponse response = new DataResponse();
        try {
            List<Map<String, Object>> maps = this.dataStatisticsService.applyTypeStatic(filterParam, staticType);
            response.setResult(maps);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.markFailure(e.getMessage());
            throw new RuntimeException(e);
        }
        return response;
    }
}

